/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.page.Page;
import com.galenframework.parser.IndentationStructureParser;
import com.galenframework.parser.StructNode;
import com.galenframework.speclang2.pagespec.MacroProcessor;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.speclang2.pagespec.PostProcessor;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.page.Locator;
import com.galenframework.specs.page.PageSpec;
import com.galenframework.utils.GalenUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class PageSpecReader {
    public PageSpec read(String path, Page page, SectionFilter sectionFilter, Properties properties, Map<String, Object> jsVariables, Map<String, Locator> objects) throws IOException {
        String contextPath = GalenUtils.getParentForFile(path);
        InputStream stream = GalenUtils.findFileOrResourceAsStream(path);
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        return this.read(stream, path, contextPath, page, sectionFilter, properties, jsVariables, objects);
    }

    public PageSpec read(InputStream inputStream, String source, String contextPath, Page page, SectionFilter sectionFilter, Properties properties, Map<String, Object> jsVariables, Map<String, Locator> objects) throws IOException {
        IndentationStructureParser structParser = new IndentationStructureParser();
        List<StructNode> structs = structParser.parse(inputStream, source);
        PageSpec pageSpec = new PageSpec(objects);
        PageSpecHandler pageSpecHandler = new PageSpecHandler(pageSpec, page, sectionFilter, contextPath, properties, jsVariables);
        List<StructNode> allProcessedChildNodes = new MacroProcessor(pageSpecHandler).process(structs);
        new PostProcessor(pageSpecHandler).process(allProcessedChildNodes);
        return pageSpecHandler.buildPageSpec();
    }
}

