/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.speclang2.pagespec;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.StructNode;
import com.galenframework.parser.SyntaxException;
import com.galenframework.speclang2.pagespec.PageSpecHandler;
import com.galenframework.utils.GalenUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class GroupsDefinitionProcessor {
    private final PageSpecHandler pageSpecHandler;

    public GroupsDefinitionProcessor(PageSpecHandler pageSpecHandler) {
        this.pageSpecHandler = pageSpecHandler;
    }

    public List<StructNode> process(StringCharReader reader, StructNode structNode) {
        if (!reader.getTheRest().isEmpty()) {
            throw new SyntaxException(structNode, "Groups definition does not take any arguments");
        }
        if (structNode.getChildNodes() != null) {
            for (StructNode groupNode : structNode.getChildNodes()) {
                if (groupNode.getChildNodes() != null && !groupNode.getChildNodes().isEmpty()) {
                    throw new SyntaxException(structNode, "groups should be declared in single line");
                }
                this.processGroupNode(groupNode);
            }
        }
        return Collections.emptyList();
    }

    private void processGroupNode(StructNode groupNode) {
        StringCharReader reader = new StringCharReader(groupNode.getName());
        List<Object> groups = new LinkedList();
        if (reader.firstNonWhiteSpaceSymbol() == '(') {
            groups = this.readMultipleGroups(reader);
        } else {
            String groupName = reader.readWord().trim();
            groups.add(groupName);
        }
        String objectStatements = reader.getTheRest().trim();
        if (objectStatements.isEmpty()) {
            throw new SyntaxException(groupNode, "Missing object statements");
        }
        List<String> objects = this.pageSpecHandler.findAllObjectsMatchingStrictStatements(objectStatements);
        if (!groups.isEmpty()) {
            for (String object : objects) {
                this.pageSpecHandler.applyGroupsToObject(object, groups);
            }
        }
    }

    private List<String> readMultipleGroups(StringCharReader reader) {
        reader.readUntilSymbol('(');
        String commaSeparatedGroups = reader.readUntilSymbol(')');
        return GalenUtils.fromCommaSeparated(commaSeparatedGroups);
    }
}

