/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.runner;

import com.galenframework.javascript.GalenJsExecutor;
import com.galenframework.runner.EventHandler;
import com.galenframework.runner.events.TestEvent;
import com.galenframework.runner.events.TestFilterEvent;
import com.galenframework.runner.events.TestRetryEvent;
import com.galenframework.runner.events.TestSuiteEvent;
import com.galenframework.tests.GalenTest;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class JsTestCollector {
    private List<GalenTest> collectedTests = new LinkedList<GalenTest>();
    private EventHandler eventHandler = new EventHandler();
    private GalenJsExecutor js = this.createExecutor();

    public JsTestCollector(List<GalenTest> tests) {
        this.collectedTests = tests;
    }

    private GalenJsExecutor createExecutor() {
        GalenJsExecutor jsExector = new GalenJsExecutor();
        jsExector.putObject("_galenCore", this);
        jsExector.eval(GalenJsExecutor.loadJsFromLibrary("GalenCore.js"));
        jsExector.eval(GalenJsExecutor.loadJsFromLibrary("GalenApi.js"));
        jsExector.eval(GalenJsExecutor.loadJsFromLibrary("GalenPages.js"));
        return jsExector;
    }

    public JsTestCollector() {
    }

    public void execute(File file) throws IOException {
        FileReader scriptFileReader = new FileReader(file);
        this.js.eval(scriptFileReader, file.getAbsolutePath());
    }

    public void addTest(GalenTest test) {
        this.collectedTests.add(test);
    }

    public List<GalenTest> getCollectedTests() {
        return this.collectedTests;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void addBeforeTestSuiteEvent(TestSuiteEvent event) {
        this.eventHandler.getBeforeTestSuiteEvents().add(event);
    }

    public void addAfterTestSuiteEvent(TestSuiteEvent event) {
        this.eventHandler.getAfterTestSuiteEvents().add(event);
    }

    public void addBeforeTestEvent(TestEvent event) {
        this.eventHandler.getBeforeTestEvents().add(event);
    }

    public void addAfterTestEvent(TestEvent event) {
        this.eventHandler.getAfterTestEvents().add(event);
    }

    public void addTestFilterEvent(TestFilterEvent event) {
        this.eventHandler.getTestFilterEvents().add(event);
    }

    public void addTestRetryEvent(TestRetryEvent event) {
        this.eventHandler.getTestRetryEvents().add(event);
    }
}

