/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.runner;

import com.galenframework.browser.Browser;
import com.galenframework.reports.TestReport;
import com.galenframework.specs.Spec;
import com.galenframework.specs.page.PageSection;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationListener;
import com.galenframework.validation.ValidationResult;

public class GalenPageRunner
implements ValidationListener {
    private ValidationListener validationListener;
    private TestReport report;

    public GalenPageRunner(TestReport report) {
        this.setReport(report);
    }

    public GalenPageRunner withValidationListener(ValidationListener validationListener) {
        this.setValidationListener(validationListener);
        return this;
    }

    public ValidationListener getValidationListener() {
        return this.validationListener;
    }

    public void setValidationListener(ValidationListener validationListener) {
        this.validationListener = validationListener;
    }

    public void run(Browser browser, GalenPageTest pageTest) throws Exception {
        if (pageTest.getScreenSize() != null) {
            browser.changeWindowSize(pageTest.getScreenSize());
        }
        if (pageTest.getUrl() != null && !pageTest.getUrl().isEmpty()) {
            browser.load(pageTest.getUrl());
        }
        for (GalenPageAction action : pageTest.getActions()) {
            this.tellBeforeAction(action);
            this.report.sectionStart(action.getOriginalCommand());
            this.executeAction(browser, pageTest, action);
            this.report.sectionEnd();
            this.tellAfterAction(action);
        }
    }

    private void executeAction(Browser browser, GalenPageTest pageTest, GalenPageAction action) throws Exception {
        action.execute(this.report, browser, pageTest, this);
    }

    private void tellAfterAction(GalenPageAction action) {
        if (this.validationListener != null) {
            this.validationListener.onAfterPageAction(action);
        }
    }

    private void tellBeforeAction(GalenPageAction action) {
        if (this.validationListener != null) {
            this.validationListener.onBeforePageAction(action);
        }
    }

    @Override
    public void onObject(PageValidation pageValidation, String objectName) {
        if (this.validationListener != null) {
            this.validationListener.onObject(pageValidation, objectName);
        }
    }

    @Override
    public void onAfterObject(PageValidation pageValidation, String objectName) {
        if (this.validationListener != null) {
            this.validationListener.onAfterObject(pageValidation, objectName);
        }
    }

    @Override
    public void onBeforeSpec(PageValidation pageValidation, String objectName, Spec spec) {
        if (this.validationListener != null) {
            this.validationListener.onBeforeSpec(pageValidation, objectName, spec);
        }
    }

    @Override
    public void onSpecError(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        if (this.validationListener != null) {
            this.validationListener.onSpecError(pageValidation, objectName, spec, result);
        }
    }

    @Override
    public void onSpecSuccess(PageValidation pageValidation, String objectName, Spec spec, ValidationResult result) {
        if (this.validationListener != null) {
            this.validationListener.onSpecSuccess(pageValidation, objectName, spec, result);
        }
    }

    @Override
    public void onGlobalError(Exception e) {
        if (this.validationListener != null) {
            this.validationListener.onGlobalError(e);
        }
    }

    @Override
    public void onBeforePageAction(GalenPageAction action) {
        if (this.validationListener != null) {
            this.onBeforePageAction(action);
        }
    }

    @Override
    public void onAfterPageAction(GalenPageAction action) {
        if (this.validationListener != null) {
            this.onAfterPageAction(action);
        }
    }

    @Override
    public void onBeforeSection(PageValidation pageValidation, PageSection pageSection) {
        if (this.validationListener != null) {
            this.validationListener.onBeforeSection(pageValidation, pageSection);
        }
    }

    @Override
    public void onAfterSection(PageValidation pageValidation, PageSection pageSection) {
        if (this.validationListener != null) {
            this.validationListener.onAfterSection(pageValidation, pageSection);
        }
    }

    @Override
    public void onSubLayout(PageValidation pageValidation, String objectName) {
        if (this.validationListener != null) {
            this.validationListener.onSubLayout(pageValidation, objectName);
        }
    }

    @Override
    public void onAfterSubLayout(PageValidation pageValidation, String objectName) {
        if (this.validationListener != null) {
            this.validationListener.onAfterSubLayout(pageValidation, objectName);
        }
    }

    @Override
    public void onSpecGroup(PageValidation pageValidation, String specGroupName) {
        if (this.validationListener != null) {
            this.validationListener.onSpecGroup(pageValidation, specGroupName);
        }
    }

    @Override
    public void onAfterSpecGroup(PageValidation pageValidation, String specGroupName) {
        if (this.validationListener != null) {
            this.validationListener.onAfterSpecGroup(pageValidation, specGroupName);
        }
    }

    public TestReport getReport() {
        return this.report;
    }

    public void setReport(TestReport report) {
        this.report = report;
    }
}

