/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.runner;

import com.galenframework.reports.GalenTestInfo;
import com.galenframework.runner.events.TestEvent;
import com.galenframework.runner.events.TestFilterEvent;
import com.galenframework.runner.events.TestRetryEvent;
import com.galenframework.runner.events.TestSuiteEvent;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(EventHandler.class);
    private List<TestEvent> beforeTestEvents = new LinkedList<TestEvent>();
    private List<TestEvent> afterTestEvents = new LinkedList<TestEvent>();
    private List<TestFilterEvent> testFilterEvents = new LinkedList<TestFilterEvent>();
    private List<TestRetryEvent> testRetryEvents = new LinkedList<TestRetryEvent>();
    private List<TestSuiteEvent> beforeTestSuiteEvents = new LinkedList<TestSuiteEvent>();
    private List<TestSuiteEvent> afterTestSuiteEvents = new LinkedList<TestSuiteEvent>();

    public List<TestEvent> getBeforeTestEvents() {
        return this.beforeTestEvents;
    }

    public void setBeforeTestEvents(List<TestEvent> beforeTestEvents) {
        this.beforeTestEvents = beforeTestEvents;
    }

    public List<TestEvent> getAfterTestEvents() {
        return this.afterTestEvents;
    }

    public void setAfterTestEvents(List<TestEvent> afterTestEvents) {
        this.afterTestEvents = afterTestEvents;
    }

    public List<TestSuiteEvent> getAfterTestSuiteEvents() {
        return this.afterTestSuiteEvents;
    }

    public void setAfterTestSuiteEvents(List<TestSuiteEvent> afterTestSuiteEvents) {
        this.afterTestSuiteEvents = afterTestSuiteEvents;
    }

    public List<TestSuiteEvent> getBeforeTestSuiteEvents() {
        return this.beforeTestSuiteEvents;
    }

    public void setBeforeTestSuiteEvents(List<TestSuiteEvent> beforeTestSuiteEvents) {
        this.beforeTestSuiteEvents = beforeTestSuiteEvents;
    }

    public void invokeBeforeTestSuiteEvents() {
        this.execute(this.getBeforeTestSuiteEvents());
    }

    public void invokeAfterTestSuiteEvents() {
        this.execute(this.getAfterTestSuiteEvents());
    }

    private void execute(List<TestSuiteEvent> events) {
        if (events != null) {
            for (TestSuiteEvent event : events) {
                if (event == null) continue;
                try {
                    event.execute();
                }
                catch (Throwable ex) {
                    LOG.error("Unknow error during executing test suites.", ex);
                }
            }
        }
    }

    public void invokeBeforeTestEvents(GalenTestInfo testInfo) {
        this.execute(this.getBeforeTestEvents(), testInfo);
    }

    public void invokeAfterTestEvents(GalenTestInfo testInfo) {
        this.execute(this.getAfterTestEvents(), testInfo);
    }

    private void execute(List<TestEvent> events, GalenTestInfo testInfo) {
        if (events != null) {
            for (TestEvent event : events) {
                if (event == null) continue;
                try {
                    event.execute(testInfo);
                }
                catch (Throwable ex) {
                    LOG.error("Unknow error during executing test events.", ex);
                }
            }
        }
    }

    public List<TestFilterEvent> getTestFilterEvents() {
        return this.testFilterEvents;
    }

    public void setTestFilterEvents(List<TestFilterEvent> testFilterEvents) {
        this.testFilterEvents = testFilterEvents;
    }

    public List<TestRetryEvent> getTestRetryEvents() {
        return this.testRetryEvents;
    }

    public void setTestRetryEvents(List<TestRetryEvent> testRetryEvents) {
        this.testRetryEvents = testRetryEvents;
    }
}

