/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports.nodes;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.galenframework.reports.TestStatistic;
import com.galenframework.reports.model.FileTempStorage;
import com.galenframework.reports.model.LayoutObject;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.reports.model.LayoutSection;
import com.galenframework.reports.model.LayoutSpec;
import com.galenframework.reports.model.LayoutSpecGroup;
import com.galenframework.reports.nodes.TestReportNode;
import java.util.List;

public class LayoutReportNode
extends TestReportNode {
    @JsonUnwrapped
    private LayoutReport layoutReport;

    public LayoutReportNode(FileTempStorage parentStorage, LayoutReport layoutReport, String name) {
        super(parentStorage);
        this.setLayoutReport(layoutReport);
        parentStorage.registerStorage(layoutReport.getFileStorage());
        this.setName(name);
    }

    @Override
    public String getType() {
        return "layout";
    }

    public LayoutReport getLayoutReport() {
        return this.layoutReport;
    }

    public void setLayoutReport(LayoutReport layoutReport) {
        this.layoutReport = layoutReport;
    }

    @Override
    public TestStatistic fetchStatistic(TestStatistic testStatistic) {
        if (this.layoutReport.getSections() != null) {
            this.fetchStatisticForSections(this.layoutReport.getSections(), testStatistic);
        }
        return testStatistic;
    }

    private void fetchStatisticForSections(List<LayoutSection> sections, TestStatistic testStatistic) {
        for (LayoutSection section : sections) {
            if (section.getSections() != null) {
                this.fetchStatisticForSections(section.getSections(), testStatistic);
            }
            if (section.getObjects() == null) continue;
            for (LayoutObject object : section.getObjects()) {
                this.fetchStatisticForObject(object, testStatistic);
            }
        }
    }

    private void fetchStatisticForObject(LayoutObject object, TestStatistic testStatistic) {
        if (object.getSpecs() != null) {
            this.fetchStatisticFromSpecs(testStatistic, object.getSpecs());
        }
        if (object.getSpecGroups() != null) {
            for (LayoutSpecGroup specGroup : object.getSpecGroups()) {
                if (specGroup.getSpecs() == null) continue;
                this.fetchStatisticFromSpecs(testStatistic, specGroup.getSpecs());
            }
        }
    }

    private void fetchStatisticFromSpecs(TestStatistic testStatistic, List<LayoutSpec> specs) {
        for (LayoutSpec spec : specs) {
            if (spec.getSubLayout() != null && spec.getSubLayout().getSections() != null) {
                this.fetchStatisticForSections(spec.getSubLayout().getSections(), testStatistic);
                continue;
            }
            testStatistic.setTotal(testStatistic.getTotal() + 1);
            if (spec.getStatus() == TestReportNode.Status.WARN) {
                testStatistic.setWarnings(testStatistic.getWarnings() + 1);
                continue;
            }
            if (spec.getStatus() == TestReportNode.Status.ERROR) {
                testStatistic.setErrors(testStatistic.getErrors() + 1);
                continue;
            }
            testStatistic.setPassed(testStatistic.getPassed() + 1);
        }
    }
}

