/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.galenframework.page.Rect;
import com.galenframework.reports.model.LayoutObject;
import com.galenframework.reports.model.LayoutObjectDetails;
import com.galenframework.reports.model.LayoutReport;
import com.galenframework.reports.model.LayoutSection;
import com.galenframework.reports.model.LayoutSpec;
import com.galenframework.specs.page.PageSection;
import com.galenframework.validation.ValidationObject;
import java.util.List;
import java.util.Stack;

public class LayoutReportStack {
    private LayoutObject currentObject = null;
    private final LayoutReport layoutReport;
    private final Stack<LayoutSection> sectionStack = new Stack();
    private LayoutSpec currentSpec;
    private List<LayoutSpec> currentSpecCollector;

    public LayoutReportStack(LayoutReport layoutReport) {
        this.layoutReport = layoutReport;
    }

    public void pushSection(PageSection pageSection) {
        LayoutSection section = new LayoutSection(pageSection.getName(), pageSection.getPlace());
        if (!this.sectionStack.isEmpty()) {
            this.sectionStack.peek().addSection(section);
        } else {
            this.layoutReport.getSections().add(section);
        }
        this.sectionStack.push(section);
    }

    public void popSection() {
        this.sectionStack.pop();
    }

    public LayoutSection peekSection() {
        return this.sectionStack.peek();
    }

    public LayoutObject getCurrentObject() {
        return this.currentObject;
    }

    public void setCurrentObject(LayoutObject currentObject) {
        this.currentObject = currentObject;
        this.currentSpecCollector = currentObject.getSpecs();
    }

    public void setCurrentSpec(LayoutSpec currentSpec) {
        this.currentSpec = currentSpec;
    }

    public LayoutSpec getCurrentSpec() {
        return this.currentSpec;
    }

    public void putObjects(List<ValidationObject> validationObjects) {
        if (validationObjects != null) {
            for (ValidationObject validationObject : validationObjects) {
                int[] area = null;
                Rect rectArea = validationObject.getArea();
                if (rectArea != null) {
                    area = rectArea.toIntArray();
                }
                this.layoutReport.getObjects().put(validationObject.getName(), new LayoutObjectDetails(area));
            }
        }
    }

    public List<LayoutSpec> getCurrentSpecCollector() {
        return this.currentSpecCollector;
    }

    public void setCurrentSpecCollector(List<LayoutSpec> currentSpecCollector) {
        this.currentSpecCollector = currentSpecCollector;
    }
}

