/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.galenframework.reports.GalenTestAggregatedInfo;
import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.json.JsonReportBuilder;
import com.galenframework.reports.json.ReportOverview;
import com.galenframework.utils.GalenUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class HtmlReportBuilder {
    private static final String[] resources = new String[]{"galen-report.js", "handlebars-v2.0.0.js", "icon-sprites.png", "jquery-1.11.2.min.js", "report.css", "tablesorter.css", "tablesorter.js"};

    public void build(List<GalenTestInfo> tests, String reportFolderPath) throws IOException {
        GalenUtils.makeSureFolderExists(reportFolderPath);
        JsonReportBuilder jsonBuilder = new JsonReportBuilder();
        ReportOverview reportOverview = jsonBuilder.createReportOverview(tests);
        String overviewTemplate = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/html-report/report.tpl.html"));
        String testReportTemplate = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/html-report/report-test.tpl.html"));
        for (GalenTestAggregatedInfo aggregatedInfo : reportOverview.getTests()) {
            String testReportJson = jsonBuilder.exportTestReportToJsonString(aggregatedInfo);
            FileUtils.writeStringToFile((File)new File(reportFolderPath + File.separator + aggregatedInfo.getTestId() + ".html"), (String)testReportTemplate.replace("##REPORT-TEST-NAME##", aggregatedInfo.getTestInfo().getName()).replace("##REPORT-DATA##", testReportJson));
            FileUtils.writeStringToFile((File)new File(reportFolderPath + File.separator + aggregatedInfo.getTestId() + ".json"), (String)testReportJson);
            aggregatedInfo.getTestInfo().getReport().getFileStorage().copyAllFilesTo(new File(reportFolderPath));
        }
        String overviewJson = jsonBuilder.exportReportOverviewToJsonAsString(reportOverview);
        FileUtils.writeStringToFile((File)new File(reportFolderPath + File.separator + "report.html"), (String)overviewTemplate.replace("##REPORT-DATA##", overviewJson));
        FileUtils.writeStringToFile((File)new File(reportFolderPath + File.separator + "report.json"), (String)overviewJson);
        this.copyHtmlResources(reportFolderPath);
    }

    private void copyHtmlResources(String reportFolderPath) throws IOException {
        for (String resourceName : resources) {
            this.copyResourceToFolder("/html-report/" + resourceName, reportFolderPath + File.separator + resourceName);
        }
    }

    private void copyResourceToFolder(String resourcePath, String destFileName) throws IOException {
        File destFile = new File(destFileName);
        if (!destFile.exists() && !destFile.createNewFile()) {
            throw new RuntimeException("Cannot copy file to: " + destFile.getAbsolutePath());
        }
        IOUtils.copy((InputStream)this.getClass().getResourceAsStream(resourcePath), (OutputStream)new FileOutputStream(destFile));
    }
}

