/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.reports;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.galenframework.reports.TestReport;
import com.galenframework.tests.GalenEmptyTest;
import com.galenframework.tests.GalenTest;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class GalenTestInfo {
    private String name;
    @JsonIgnore
    private TestReport report = new TestReport();
    @JsonIgnore
    private Throwable exception;
    private Date startedAt = new Date();
    private Date endedAt = new Date();
    @JsonIgnore
    private GalenTest test;

    public GalenTestInfo(String name, GalenTest test) {
        this.setName(name);
        this.setTest(test);
    }

    public boolean isFailed() {
        return this.exception != null || this.report.fetchStatistic().getErrors() > 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TestReport getReport() {
        return this.report;
    }

    public void setReport(TestReport report) {
        this.report = report;
    }

    public void setException(Throwable ex) {
        this.exception = ex;
    }

    public Throwable getException() {
        return this.exception;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getEndedAt() {
        return this.endedAt;
    }

    public void setEndedAt(Date endedAt) {
        this.endedAt = endedAt;
    }

    public GalenTest getTest() {
        return this.test;
    }

    public void setTest(GalenTest test) {
        this.test = test;
    }

    public static GalenTestInfo fromString(String name) {
        return new GalenTestInfo(name, new GalenEmptyTest(name, null));
    }

    public static GalenTestInfo fromString(String name, List<String> groups) {
        return new GalenTestInfo(name, new GalenEmptyTest(name, groups));
    }

    public static GalenTestInfo fromMethod(Method method) {
        String name = method.getDeclaringClass().getSimpleName() + "#" + method.getName();
        return GalenTestInfo.fromString(name);
    }

    public static GalenTestInfo fromMethod(Method method, Object[] arguments) {
        StringBuilder builder = new StringBuilder(method.getDeclaringClass().getSimpleName() + "#" + method.getName());
        if (arguments != null && arguments.length > 0) {
            builder.append(" (");
            boolean shouldUseComma = false;
            for (Object argument : arguments) {
                if (shouldUseComma) {
                    builder.append(", ");
                }
                builder.append(GalenTestInfo.convertArgumentToString(argument));
                shouldUseComma = true;
            }
            builder.append(")");
        }
        return GalenTestInfo.fromString(builder.toString());
    }

    private static String convertArgumentToString(Object argument) {
        if (argument == null) {
            return "null";
        }
        if (argument instanceof String) {
            return "\"" + StringEscapeUtils.escapeJava((String)argument.toString()) + "\"";
        }
        if (argument instanceof Boolean) {
            return Boolean.toString((Boolean)argument);
        }
        return argument.toString();
    }
}

