/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.VarsParserJsProcessable;
import com.galenframework.suite.reader.Context;
import java.util.Properties;
import org.mozilla.javascript.NativeJavaObject;

public class VarsParser {
    private static final int PARSING_TEXT = 0;
    private static final int PARSING_PARAM = 1;
    private final VarsParserJsProcessable jsProcessor;
    private Context context;
    private int state = 0;
    private Properties properties;

    public VarsParser(Context context, Properties properties, VarsParserJsProcessable jsProcessor) {
        this.context = context;
        this.properties = properties;
        this.jsProcessor = jsProcessor;
    }

    public VarsParser(Context context, Properties properties) {
        this(context, properties, null);
    }

    public String parse(String templateText) {
        StringCharReader reader = new StringCharReader(templateText);
        StringBuffer buffer = new StringBuffer();
        StringBuffer currentExpression = new StringBuffer();
        while (reader.hasMore()) {
            char symbol = reader.next();
            if (this.state == 0) {
                if (symbol == '$' && reader.currentSymbol() == '{') {
                    this.state = 1;
                    currentExpression = new StringBuffer();
                    reader.next();
                    continue;
                }
                if (symbol == '\\' && reader.currentSymbol() == '$') {
                    buffer.append('$');
                    reader.next();
                    continue;
                }
                buffer.append(symbol);
                continue;
            }
            if (this.state != 1) continue;
            if (symbol == '}') {
                String expression = currentExpression.toString().trim();
                String value = this.getExpressionValueString(expression, this.context);
                if (value == null) {
                    value = "";
                }
                buffer.append(value.toString());
                this.state = 0;
                continue;
            }
            currentExpression.append(symbol);
        }
        return buffer.toString();
    }

    private String getExpressionValueString(String expression, Context context) {
        Object value = context.getValue(expression);
        if (value == null) {
            if (this.properties != null) {
                value = this.properties.getProperty(expression);
            }
            if (value == null) {
                value = System.getProperty(expression);
            }
        }
        if (value == null) {
            value = this.readJsExpression(expression);
        }
        if (value instanceof NativeJavaObject) {
            NativeJavaObject javaObject = (NativeJavaObject)value;
            value = javaObject.unwrap();
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private String readJsExpression(String expression) {
        if (this.jsProcessor != null) {
            return this.jsProcessor.evalStrictToString(expression);
        }
        return null;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

