/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.ExpectColorRanges;
import com.galenframework.parser.ExpectCommaSeparatedKeyValue;
import com.galenframework.parser.ExpectCommandLineArguments;
import com.galenframework.parser.ExpectCorrection;
import com.galenframework.parser.ExpectLocations;
import com.galenframework.parser.ExpectNumber;
import com.galenframework.parser.ExpectRange;
import com.galenframework.parser.ExpectSides;
import com.galenframework.parser.ExpectString;
import com.galenframework.parser.ExpectWord;
import com.galenframework.parser.Expectation;
import com.galenframework.parser.ExpectationErrorRate;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.Location;
import com.galenframework.specs.Range;
import com.galenframework.specs.Side;
import com.galenframework.specs.colors.ColorRange;
import com.galenframework.specs.page.CorrectionsRect;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class Expectations {
    public static List<Expectation<?>> expectThese(Expectation<?> ... expectations) {
        return Arrays.asList(expectations);
    }

    public static Expectation<List<Side>> sides() {
        return new ExpectSides();
    }

    public static Expectation<Range> range() {
        return new ExpectRange();
    }

    public static Expectation<String> objectName() {
        return new ExpectWord();
    }

    public static Expectation<String> filePath() {
        return new ExpectWord();
    }

    public static Expectation<Double> number() {
        return new ExpectNumber();
    }

    public static Expectation<String> word() {
        return new ExpectWord();
    }

    public static Expectation<String[]> commandLineArguments() {
        return new ExpectCommandLineArguments();
    }

    public static boolean isDelimeter(char symbol) {
        return symbol == ' ' || symbol == '\t';
    }

    public static boolean isWordDelimeter(char symbol) {
        return symbol == ' ' || symbol == '\t' || symbol == ',';
    }

    public static boolean isNumeric(char symbol) {
        return symbol == '-' || symbol >= '0' && symbol <= '9';
    }

    public static Expectation<List<Location>> locations() {
        return new ExpectLocations();
    }

    public static Expectation<CorrectionsRect> corrections() {
        return new ExpectCorrection();
    }

    public static Expectation<List<ColorRange>> colorRanges() {
        return new ExpectColorRanges();
    }

    public static Expectation<List<Pair<String, String>>> commaSeparatedRepeatedKeyValues() {
        return new ExpectCommaSeparatedKeyValue();
    }

    public static List<String> readAllWords(String arguments) {
        LinkedList<String> words = new LinkedList<String>();
        StringCharReader reader = new StringCharReader(arguments);
        ExpectWord expectWord = new ExpectWord();
        while (reader.hasMoreNormalSymbols()) {
            String word = expectWord.read(reader);
            if (word.isEmpty()) continue;
            words.add(word);
        }
        return words;
    }

    public static Expectation<String> doubleQuotedText() {
        return new Expectation<String>(){

            @Override
            public String read(StringCharReader charReader) {
                char firstNonWhiteSpaceSymbol = charReader.firstNonWhiteSpaceSymbol();
                if (firstNonWhiteSpaceSymbol == '\"') {
                    charReader.readSafeUntilSymbol('\"');
                    return new ExpectString().read(charReader);
                }
                throw new SyntaxException("Expected \" symbol, got: " + firstNonWhiteSpaceSymbol);
            }
        };
    }

    public static ExpectationErrorRate errorRate() {
        return new ExpectationErrorRate();
    }

    public static void expectNextWord(String expectedWord, StringCharReader reader) {
        String word = Expectations.word().read(reader);
        if (!expectedWord.equals(word)) {
            throw new SyntaxException("Expected: " + expectedWord + ", got: " + word);
        }
    }
}

