/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.Expectation;
import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;

public class ExpectNumber
implements Expectation<Double> {
    @Override
    public Double read(StringCharReader reader) {
        boolean started = false;
        boolean hadPointAlready = false;
        StringBuffer buffer = new StringBuffer();
        while (reader.hasMore()) {
            char symbol = reader.next();
            if (started && Expectations.isDelimeter(symbol)) break;
            if (symbol == '.') {
                if (hadPointAlready) {
                    throw new SyntaxException(String.format("Cannot parse number: \"%s\"", Character.valueOf(symbol)));
                }
                hadPointAlready = true;
                buffer.append(symbol);
                continue;
            }
            if (Expectations.isNumeric(symbol)) {
                buffer.append(symbol);
                started = true;
                continue;
            }
            if (!started) continue;
            reader.back();
            break;
        }
        String doubleText = buffer.toString();
        try {
            return Double.parseDouble(doubleText);
        }
        catch (Exception e) {
            throw new SyntaxException(String.format("Cannot parse number: \"%s\"", doubleText), (Throwable)e);
        }
    }
}

