/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import com.galenframework.parser.Expectation;
import com.galenframework.parser.Expectations;
import com.galenframework.parser.StringCharReader;
import com.galenframework.parser.SyntaxException;
import com.galenframework.specs.page.CorrectionsRect;

public class ExpectCorrection
implements Expectation<CorrectionsRect> {
    @Override
    public CorrectionsRect read(StringCharReader reader) {
        boolean started = false;
        StringBuffer numbersText = new StringBuffer();
        while (reader.hasMore()) {
            char symbol = reader.next();
            if (symbol == '(' && !started) {
                started = true;
                continue;
            }
            if (symbol == ')') {
                return this.processCorrection(numbersText.toString());
            }
            if (Expectations.isDelimeter(symbol)) continue;
            if (!started) {
                throw new SyntaxException("Error parsing corrections. Missing starting '(' symbol");
            }
            numbersText.append(symbol);
        }
        throw new SyntaxException("Error parsing corrections. Missing closing ')' symbol");
    }

    private CorrectionsRect processCorrection(String numbersText) {
        if (!numbersText.isEmpty()) {
            String[] values = numbersText.split(",");
            if (values.length == 4) {
                return new CorrectionsRect(this.readCorrection(values[0]), this.readCorrection(values[1]), this.readCorrection(values[2]), this.readCorrection(values[3]));
            }
            throw new SyntaxException("Wrong number of arguments in corrections: " + values.length);
        }
        throw new SyntaxException("Error parsing corrections. No values provided");
    }

    private CorrectionsRect.Correction readCorrection(String value) {
        if (value.length() == 0) {
            throw new SyntaxException("Incorrect correction. Don't use empty values");
        }
        char symbol = value.charAt(0);
        if (symbol == '-') {
            return new CorrectionsRect.Correction(Integer.parseInt(value.substring(1)), CorrectionsRect.Type.MINUS);
        }
        if (symbol == '+') {
            return new CorrectionsRect.Correction(Integer.parseInt(value.substring(1)), CorrectionsRect.Type.PLUS);
        }
        if (symbol == '=') {
            return new CorrectionsRect.Correction(Integer.parseInt(value.substring(1)), CorrectionsRect.Type.EQUALS);
        }
        return new CorrectionsRect.Correction(Integer.parseInt(value), CorrectionsRect.Type.PLUS);
    }
}

