/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.parser;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CommandLineReader {
    private final List<String> args;
    private final ListIterator<String> it;

    public CommandLineReader(String[] args) {
        this.args = new LinkedList<String>(Arrays.asList(args));
        this.it = this.args.listIterator();
    }

    public boolean hasNext() {
        return this.it.hasNext();
    }

    public boolean isNextArgument() {
        if (this.hasNext()) {
            String next = this.it.next();
            this.it.previous();
            return next != null && next.startsWith("--");
        }
        throw new IndexOutOfBoundsException();
    }

    public String readNext() {
        return this.it.next();
    }

    public Pair<String, String> readArgument() {
        if (this.hasNext()) {
            String argumentName = this.convertArgumentName(this.readNext());
            if (this.hasNext()) {
                String argumentValue = this.readNext();
                return new ImmutablePair((Object)argumentName, (Object)argumentValue);
            }
            throw new IndexOutOfBoundsException("Argument '" + argumentName + "' doesn't have a value");
        }
        throw new IndexOutOfBoundsException();
    }

    private String convertArgumentName(String argument) {
        return argument.substring(2);
    }

    public void skipArgument() {
        this.readNext();
    }
}

