/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.page.selenium;

import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import com.galenframework.page.AbsentPageElement;
import com.galenframework.page.Page;
import com.galenframework.page.PageElement;
import com.galenframework.page.Rect;
import com.galenframework.page.selenium.ByChain;
import com.galenframework.page.selenium.ScreenElement;
import com.galenframework.page.selenium.ViewportElement;
import com.galenframework.page.selenium.WebPageElement;
import com.galenframework.rainbow4j.Rainbow4J;
import com.galenframework.specs.page.Locator;
import com.galenframework.utils.GalenUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class SeleniumPage
implements Page {
    private WebDriver driver;
    private Map<String, PageElement> cachedPageElements = new HashMap<String, PageElement>();
    private PageElement parentObject;
    private BufferedImage cachedScreenshotImage;
    private File cachedScreenshotFile;
    private int offsetLeft = 0;
    private int offsetTop = 0;
    private final SearchContext driverSearchContext;

    public SeleniumPage(WebDriver driver) {
        this(driver, (SearchContext)driver);
    }

    private SeleniumPage(WebDriver driver, SearchContext driverSearchContext) {
        this.driver = driver;
        this.driverSearchContext = driverSearchContext;
    }

    private SeleniumPage(WebDriver driver, SearchContext searchContext, Locator objectContextLocator) {
        this.driver = driver;
        WebElement contextElement = this.findObjectContext(searchContext, objectContextLocator);
        this.driverSearchContext = contextElement;
        this.parentObject = new WebPageElement(driver, "parent", contextElement, objectContextLocator).withOffset(this.offsetLeft, this.offsetTop);
    }

    private WebElement findObjectContext(SearchContext searchContext, Locator objectContextLocator) {
        if (objectContextLocator != null) {
            ByChain byChain = ByChain.fromLocator(objectContextLocator);
            if (byChain == null) {
                throw new RuntimeException("Cannot convert locator " + objectContextLocator.prettyString());
            }
            return byChain.findElement(searchContext);
        }
        throw new IllegalArgumentException("objectContextLocator cannot be null");
    }

    @Override
    public PageElement getObject(Locator objectLocator) {
        return this.locatorToElement("unnamed", objectLocator);
    }

    @Override
    public PageElement getObject(String objectName, Locator objectLocator) {
        if (objectName != null) {
            PageElement pageElement = this.cachedPageElements.get(objectName);
            if (pageElement == null) {
                pageElement = this.getObject(objectLocator);
                this.cachedPageElements.put(objectName, pageElement);
                return pageElement;
            }
            return pageElement;
        }
        return this.locatorToElement("unnamed", objectLocator);
    }

    private List<WebElement> driverFindElements(ByChain byChain) {
        return byChain.findElements(this.driverSearchContext);
    }

    private WebElement driverFindElement(ByChain byChain) {
        return byChain.findElement(this.driverSearchContext);
    }

    private PageElement locatorToElement(String objectName, Locator objectLocator) {
        PageElement pageElement;
        ByChain byChain = ByChain.fromLocator(objectLocator);
        try {
            WebElement webElement = this.driverFindElement(byChain);
            pageElement = new WebPageElement(this.driver, objectName, webElement, objectLocator).withOffset(this.offsetLeft, this.offsetTop);
        }
        catch (NoSuchElementException e) {
            pageElement = new AbsentPageElement();
        }
        return pageElement;
    }

    @Override
    public PageElement getSpecialObject(String objectName) {
        if ("screen".equals(objectName)) {
            return new ScreenElement(this.driver).withOffset(this.offsetLeft, this.offsetTop);
        }
        if ("viewport".equals(objectName)) {
            return new ViewportElement(this.driver);
        }
        if ("parent".equals(objectName) || "self".equals(objectName)) {
            if (this.parentObject != null) {
                return this.parentObject;
            }
            throw new RuntimeException("There is no " + objectName + " object defined on page");
        }
        return null;
    }

    @Override
    public int getObjectCount(Locator locator) {
        return this.driverFindElements(ByChain.fromLocator(locator)).size();
    }

    @Override
    public Page createObjectContextPage(Locator objectContextLocator) {
        return new SeleniumPage(this.driver, this.driverSearchContext, objectContextLocator);
    }

    @Override
    public File getScreenshotFile() {
        if (this.cachedScreenshotFile == null) {
            this.cachedScreenshotFile = this.createNewScreenshot();
        }
        return this.cachedScreenshotFile;
    }

    private File createNewScreenshot() {
        try {
            if (GalenConfig.getConfig().getBooleanProperty(GalenProperty.SCREENSHOT_FULLPAGE)) {
                return GalenUtils.makeFullScreenshot(this.driver);
            }
            return this.makeSimpleScreenshot();
        }
        catch (Exception e) {
            throw new RuntimeException("Error making screenshot", e);
        }
    }

    private File makeSimpleScreenshot() throws IOException {
        return GalenUtils.takeScreenshot(this.driver);
    }

    @Override
    public void setScreenshot(File screenshotFile) {
        this.cachedScreenshotFile = screenshotFile;
    }

    @Override
    public BufferedImage getScreenshotImage() {
        if (this.cachedScreenshotImage == null) {
            try {
                this.cachedScreenshotImage = Rainbow4J.loadImage((String)this.getScreenshotFile().getAbsolutePath());
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't take screenshot for page", e);
            }
        }
        return this.cachedScreenshotImage;
    }

    @Override
    public String getTitle() {
        return this.driver.getTitle();
    }

    @Override
    public void switchToFrame(PageElement mainObject) {
        WebPageElement webPageElement = (WebPageElement)mainObject;
        this.driver.switchTo().frame(webPageElement.getWebElement());
    }

    @Override
    public void switchToParentFrame() {
        this.driver.switchTo().parentFrame();
    }

    @Override
    public Page createFrameContext(PageElement frameElement) {
        SeleniumPage framePage = new SeleniumPage(this.driver);
        Rect mainObjectArea = frameElement.getArea();
        framePage.setOffset(mainObjectArea.getLeft(), mainObjectArea.getTop());
        framePage.switchToFrame(frameElement);
        framePage.setParentObject(frameElement);
        return framePage;
    }

    private void setOffset(int offsetLeft, int offsetTop) {
        this.offsetLeft = offsetLeft;
        this.offsetTop = offsetTop;
    }

    public PageElement getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(PageElement parentObject) {
        this.parentObject = parentObject;
    }

    public WebDriver getDriver() {
        return this.driver;
    }
}

