/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.page;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.galenframework.page.Point;
import java.awt.Rectangle;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Rect {
    private int left;
    private int width;
    private int top;
    private int height;

    public Rect(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
    }

    public Rect(Integer[] numbers) {
        if (numbers.length != 4) {
            throw new IndexOutOfBoundsException("Rect should take 4 arguments, got " + numbers.length);
        }
        this.left = numbers[0];
        this.top = numbers[1];
        this.width = numbers[2];
        this.height = numbers[3];
    }

    public Point[] getPoints() {
        return new Point[]{new Point(this.left, this.top), new Point(this.left + this.width, this.top), new Point(this.left + this.width, this.top + this.height), new Point(this.left, this.top + this.height)};
    }

    public boolean contains(Point point) {
        return point.getLeft() >= this.left && point.getLeft() <= this.left + this.width && point.getTop() >= this.top && point.getTop() <= this.top + this.height;
    }

    public int getLeft() {
        return this.left;
    }

    public int getWidth() {
        return this.width;
    }

    public int getTop() {
        return this.top;
    }

    public int getHeight() {
        return this.height;
    }

    @JsonIgnore
    public int getRight() {
        return this.left + this.width;
    }

    @JsonIgnore
    public int getBottom() {
        return this.top + this.height;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.left).append(this.top).append(this.width).append(this.height).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Rect)) {
            return false;
        }
        Rect rhs = (Rect)obj;
        return new EqualsBuilder().append(this.left, rhs.left).append(this.top, rhs.top).append(this.width, rhs.width).append(this.height, rhs.height).isEquals();
    }

    public String toString() {
        return String.format("Rect{left: %d, top: %d, w: %d, h: %d}", this.left, this.top, this.width, this.height);
    }

    public static Rect boundaryOf(Rect ... rects) {
        if (rects.length > 0) {
            Point[] points = rects[0].getBoundaryPoints();
            for (int i = 1; i < rects.length; ++i) {
                Point[] pointsNext = rects[i].getBoundaryPoints();
                points[0].setLeft(Math.min(points[0].getLeft(), pointsNext[0].getLeft()));
                points[0].setTop(Math.min(points[0].getTop(), pointsNext[0].getTop()));
                points[1].setLeft(Math.max(points[1].getLeft(), pointsNext[1].getLeft()));
                points[1].setTop(Math.max(points[1].getTop(), pointsNext[1].getTop()));
            }
            return new Rect(points[0].getLeft(), points[0].getTop(), points[1].getLeft() - points[0].getLeft(), points[1].getTop() - points[0].getTop());
        }
        return null;
    }

    private Point[] getBoundaryPoints() {
        return new Point[]{new Point(this.getLeft(), this.getTop()), new Point(this.getLeft() + this.getWidth(), this.getTop() + this.getHeight())};
    }

    public int[] toIntArray() {
        return new int[]{this.getLeft(), this.getTop(), this.getWidth(), this.getHeight()};
    }

    public Rect offset(int offsetLeft, int offsetTop) {
        return new Rect(this.left + offsetLeft, this.top + offsetTop, this.width, this.height);
    }

    public int calculatePointOffsetDistance(Point point) {
        int right = this.left + this.width;
        int bottom = this.top + this.height;
        int pointLeft = point.getLeft();
        int pointTop = point.getTop();
        if (this.contains(point)) {
            return this.max(this.top - pointTop, pointTop - bottom, this.left - pointLeft, pointLeft - right);
        }
        if (this.isQuadrant1(point)) {
            return this.max(Math.abs(this.left - pointLeft), Math.abs(this.top - pointTop));
        }
        if (this.isQuadrant2(point)) {
            return Math.abs(this.top - pointTop);
        }
        if (this.isQuadrant3(point)) {
            return this.max(Math.abs(pointLeft - right), Math.abs(this.top - pointTop));
        }
        if (this.isQuadrant4(point)) {
            return Math.abs(pointLeft - right);
        }
        if (this.isQuadrant5(point)) {
            return this.max(Math.abs(pointLeft - right), Math.abs(pointTop - bottom));
        }
        if (this.isQuadrant6(point)) {
            return Math.abs(pointTop - bottom);
        }
        if (this.isQuadrant7(point)) {
            return this.max(Math.abs(this.left - pointLeft), Math.abs(pointTop - bottom));
        }
        return Math.abs(this.left - pointLeft);
    }

    private boolean isQuadrant1(Point point) {
        return point.getLeft() <= this.left && point.getTop() <= this.top;
    }

    private boolean isQuadrant2(Point point) {
        return point.getLeft() >= this.left && point.getLeft() <= this.getRight() && point.getTop() <= this.top;
    }

    private boolean isQuadrant3(Point point) {
        return point.getLeft() >= this.getRight() && point.getTop() <= this.top;
    }

    private boolean isQuadrant4(Point point) {
        return point.getLeft() >= this.getRight() && point.getTop() >= this.top && point.getTop() <= this.getBottom();
    }

    private boolean isQuadrant5(Point point) {
        return point.getLeft() >= this.getRight() && point.getTop() >= this.getBottom();
    }

    private boolean isQuadrant6(Point point) {
        return point.getTop() >= this.getBottom() && point.getLeft() >= this.left && point.getLeft() <= this.getRight();
    }

    private boolean isQuadrant7(Point point) {
        return point.getLeft() <= this.left && point.getTop() >= this.getBottom();
    }

    private boolean isQuadrant8(Point point) {
        return point.getLeft() <= this.left && point.getTop() >= this.top && point.getTop() <= this.getBottom();
    }

    public int max(int ... values) {
        if (values.length > 0) {
            int max = values[0];
            for (int i = 0; i < values.length; ++i) {
                if (max >= values[i]) continue;
                max = values[i];
            }
            return max;
        }
        throw new IllegalArgumentException("Empty array");
    }

    public Rectangle toAwtRectangle() {
        return new Rectangle(this.left, this.top, this.width, this.height);
    }
}

