/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.javascript;

import com.galenframework.utils.GalenUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsFunctionLoad
extends BaseFunction {
    private static final Logger LOG = LoggerFactory.getLogger(JsFunctionLoad.class);
    private static final long serialVersionUID = 1L;
    private Stack<String> contextPathStack = new Stack();
    private Set<String> loadedFileIds = new HashSet<String>();

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw new RuntimeException("'load' function takes at least one argument");
        }
        for (Object arg : args) {
            if (arg instanceof NativeArray) {
                NativeArray array = (NativeArray)arg;
                int i = 0;
                while ((long)i < array.getLength()) {
                    Object path = array.get(i);
                    if (path == null) {
                        throw new NullPointerException("Cannot have null argument in load function");
                    }
                    this.load(path.toString(), cx, scope);
                    ++i;
                }
                continue;
            }
            if (arg == null) {
                throw new NullPointerException("Cannot have null argument in load function");
            }
            this.load(arg.toString(), cx, scope);
        }
        return null;
    }

    public void load(String filePath, Context cx, Scriptable scope) {
        try {
            String fullPath = this.constructFullPathToScript(filePath);
            this.loadScript(cx, scope, fullPath);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not load script: " + filePath, ex);
        }
    }

    private String constructFullPathToScript(String filePath) {
        if (filePath.startsWith("/")) {
            String localPath = filePath.substring(1);
            if (new File(localPath).exists()) {
                return localPath;
            }
        } else {
            String contextPath = this.peekContextPathStack();
            if (contextPath != null && !contextPath.isEmpty()) {
                return contextPath + File.separator + filePath;
            }
        }
        return filePath;
    }

    private String peekContextPathStack() {
        if (!this.contextPathStack.isEmpty()) {
            return this.contextPathStack.peek();
        }
        return null;
    }

    private void loadScript(Context cx, Scriptable scope, String fullPath) throws IOException {
        InputStream is = this.retrieveScriptAsInputStream(fullPath);
        String fileId = GalenUtils.calculateFileId(fullPath, is);
        if (!this.loadedFileIds.contains(fileId)) {
            File file = new File(fullPath);
            String parentPath = file.getParent();
            if (parentPath != null) {
                this.contextPathStack.push(file.getParent());
            }
            cx.evaluateReader(scope, (Reader)new InputStreamReader(is), file.getAbsolutePath(), 1, null);
            this.loadedFileIds.add(fileId);
            if (!this.contextPathStack.isEmpty()) {
                this.contextPathStack.pop();
            }
        }
    }

    private InputStream retrieveScriptAsInputStream(String fullPath) throws FileNotFoundException {
        InputStream is = GalenUtils.findFileOrResourceAsStream(fullPath);
        if (is == null) {
            throw new FileNotFoundException(fullPath);
        }
        return is;
    }

    public void print(String message) {
        System.out.print(message);
    }

    public void println(String message) {
        LOG.info(message);
    }

    public void putContextPath(String contextPath) {
        if (contextPath != null) {
            this.contextPathStack.push(contextPath);
        }
    }
}

