/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.config;

import com.galenframework.config.GalenProperty;
import com.galenframework.specs.SpecImage;
import com.galenframework.utils.GalenUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GalenConfig {
    private static final Logger LOG = LoggerFactory.getLogger(GalenConfig.class);
    public static final GalenConfig instance = new GalenConfig();
    public static final String GALEN_USER_HOME_CONFIG_NAME = ".galen.config";
    private Properties properties;

    private GalenConfig() {
        try {
            this.loadConfig();
        }
        catch (Exception e) {
            LOG.trace("Cannot load galen config", (Throwable)e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    private void loadConfig() throws IOException {
        this.properties = new Properties();
        this.loadConfigFromUserHome();
        this.loadConfigFromLocal();
    }

    private void loadConfigFromUserHome() throws IOException {
        InputStream stream = GalenUtils.findFileOrResourceAsStream(System.getProperty("user.home") + "/" + GALEN_USER_HOME_CONFIG_NAME);
        if (stream != null) {
            this.loadFromStream(stream);
        }
    }

    private void loadConfigFromLocal() throws IOException {
        InputStream stream = GalenUtils.findFileOrResourceAsStream(this.readProperty(GalenProperty.GALEN_CONFIG_FILE));
        if (stream == null) {
            stream = GalenUtils.findFileOrResourceAsStream("config");
        }
        this.loadFromStream(stream);
    }

    private void loadFromStream(InputStream stream) throws IOException {
        if (stream != null) {
            this.properties.load(stream);
            stream.close();
        }
        this.setSystemPropertiesFromConfig();
    }

    private void setSystemPropertiesFromConfig() {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            if (!name.startsWith("$.")) continue;
            System.setProperty(name.substring(2), this.properties.getProperty(name));
        }
    }

    public static void reloadConfigFromPath(String configPath) throws IOException {
        GalenConfig.getConfig().reloadConfig(configPath);
    }

    private void reloadConfig(String configPath) throws IOException {
        this.properties = new Properties();
        InputStream stream = GalenUtils.findFileOrResourceAsStream(configPath);
        this.loadFromStream(stream);
    }

    private List<String> convertCommaSeparatedList(String text) {
        String[] arr = text.split(",");
        LinkedList<String> list = new LinkedList<String>();
        for (String item : arr) {
            String itemText = item.trim();
            if (itemText.isEmpty()) continue;
            list.add(itemText);
        }
        return list;
    }

    public String readProperty(GalenProperty property) {
        return this.properties.getProperty(property.propertyName, System.getProperty(property.propertyName, property.defaultValue));
    }

    public String readMandatoryProperty(GalenProperty property) {
        String value = this.properties.getProperty(property.propertyName, System.getProperty(property.propertyName));
        if (value == null || value.trim().isEmpty()) {
            throw new RuntimeException("Missing property: " + property.propertyName);
        }
        return value;
    }

    public static synchronized GalenConfig getConfig() {
        return instance;
    }

    public void reset() throws IOException {
        this.loadConfig();
    }

    public int getRangeApproximation() {
        return Integer.parseInt(this.readProperty(GalenProperty.GALEN_RANGE_APPROXIMATION));
    }

    public List<String> getReportingListeners() {
        return this.convertCommaSeparatedList(this.readProperty(GalenProperty.GALEN_REPORTING_LISTENERS));
    }

    public String getDefaultBrowser() {
        return this.readProperty(GalenProperty.GALEN_DEFAULT_BROWSER);
    }

    public Integer getIntProperty(GalenProperty property) {
        String value = this.readProperty(property);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Couldn't parse property \"%s\" from config file", property.propertyName));
        }
    }

    public int getIntProperty(GalenProperty property, int min, int max) {
        int value = this.getIntProperty(property);
        if (value >= min && value <= max) {
            return value;
        }
        throw new RuntimeException(String.format("Property \"%s\"=%d in config file is not in allowed range [%d, %d]", property.propertyName, value, min, max));
    }

    public boolean getBooleanProperty(GalenProperty property) {
        String value = this.readProperty(property);
        return Boolean.parseBoolean(value);
    }

    public int getLogLevel() {
        String value = this.readProperty(GalenProperty.GALEN_LOG_LEVEL);
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        return 10;
    }

    public boolean getUseFailExitCode() {
        return this.getBooleanProperty(GalenProperty.GALEN_USE_FAIL_EXIT_CODE);
    }

    public String getTestJsSuffix() {
        return this.readProperty(GalenProperty.TEST_JS_SUFFIX);
    }

    public boolean shouldAutoresizeScreenshots() {
        return this.getBooleanProperty(GalenProperty.SCREENSHOT_AUTORESIZE);
    }

    public boolean shouldCheckVisibilityGlobally() {
        return this.getBooleanProperty(GalenProperty.SPEC_GLOBAL_VISIBILITY_CHECK);
    }

    public int getImageSpecDefaultTolerance() {
        return this.getIntProperty(GalenProperty.SPEC_IMAGE_TOLERANCE);
    }

    public SpecImage.ErrorRate getImageSpecDefaultErrorRate() {
        return SpecImage.ErrorRate.fromString(this.readProperty(GalenProperty.SPEC_IMAGE_ERROR_RATE));
    }

    public void setProperty(GalenProperty property, String value) {
        this.properties.setProperty(property.propertyName, value);
    }

    public String getTestSuffix() {
        return this.readProperty(GalenProperty.TEST_SUFFIX);
    }

    public String getStringProperty(GalenProperty property) {
        return this.readProperty(property);
    }
}

