/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.browser;

import com.galenframework.browser.Browser;
import com.galenframework.browser.BrowserFactory;
import com.galenframework.browser.SeleniumBrowser;
import com.galenframework.browser.SeleniumGridBrowserFactory;
import com.galenframework.config.GalenConfig;
import com.galenframework.config.GalenProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;

public class SeleniumBrowserFactory
implements BrowserFactory {
    public static final String FIREFOX = "firefox";
    public static final String CHROME = "chrome";
    public static final String IE = "ie";
    public static final String PHANTOMJS = "phantomjs";
    public static final String SAFARI = "safari";
    public static final String EDGE = "edge";
    private String browserType = GalenConfig.getConfig().getDefaultBrowser();

    public SeleniumBrowserFactory(String browserType) {
        this.browserType = browserType;
    }

    public SeleniumBrowserFactory() {
    }

    @Override
    public Browser openBrowser() {
        if (this.shouldBeUsingGrid()) {
            return this.createSeleniumGridBrowser();
        }
        return this.createLocalBrowser();
    }

    private Browser createSeleniumGridBrowser() {
        String gridUrl = GalenConfig.getConfig().readMandatoryProperty(GalenProperty.GALEN_BROWSERFACTORY_SELENIUM_GRID_URL);
        SeleniumGridBrowserFactory gridFactory = new SeleniumGridBrowserFactory(gridUrl);
        gridFactory.setBrowser(GalenConfig.getConfig().readProperty(GalenProperty.GALEN_BROWSERFACTORY_SELENIUM_GRID_BROWSER));
        gridFactory.setBrowserVersion(GalenConfig.getConfig().readProperty(GalenProperty.GALEN_BROWSERFACTORY_SELENIUM_GRID_BROWSERVERSION));
        String platform = GalenConfig.getConfig().readProperty(GalenProperty.GALEN_BROWSERFACTORY_SELENIUM_GRID_PLATFORM);
        if (platform != null && !platform.trim().isEmpty()) {
            gridFactory.setPlatform(Platform.valueOf((String)platform.toUpperCase()));
        }
        return gridFactory.openBrowser();
    }

    private boolean shouldBeUsingGrid() {
        return GalenConfig.getConfig().getBooleanProperty(GalenProperty.GALEN_BROWSERFACTORY_SELENIUM_RUNINGRID);
    }

    private Browser createLocalBrowser() {
        return new SeleniumBrowser(SeleniumBrowserFactory.getDriver(this.browserType));
    }

    public static WebDriver getDriver(String browserType) {
        if (StringUtils.isEmpty((CharSequence)browserType) || FIREFOX.equals(browserType)) {
            return new FirefoxDriver((Capabilities)SeleniumBrowserFactory.getBrowserCapabilities(browserType));
        }
        if (CHROME.equals(browserType)) {
            return new ChromeDriver((Capabilities)SeleniumBrowserFactory.getBrowserCapabilities(browserType));
        }
        if (IE.equals(browserType)) {
            return new InternetExplorerDriver((Capabilities)SeleniumBrowserFactory.getBrowserCapabilities(browserType));
        }
        if (PHANTOMJS.equals(browserType)) {
            return new PhantomJSDriver();
        }
        if (SAFARI.equals(browserType)) {
            return new SafariDriver();
        }
        if (EDGE.equals(browserType)) {
            return new EdgeDriver();
        }
        throw new RuntimeException(String.format("Unknown browser type: \"%s\"", browserType));
    }

    public static DesiredCapabilities getBrowserCapabilities(String driverParameter) {
        DesiredCapabilities capabilities = null;
        if (driverParameter.equalsIgnoreCase(FIREFOX)) {
            capabilities = DesiredCapabilities.firefox();
        }
        if (driverParameter.equalsIgnoreCase(IE)) {
            capabilities = DesiredCapabilities.internetExplorer();
            capabilities.setCapability("ignoreProtectedModeSettings", true);
            capabilities.setCapability("ie.ensureCleanSession", true);
        }
        if (driverParameter.equalsIgnoreCase(CHROME)) {
            capabilities = DesiredCapabilities.chrome();
        }
        return capabilities;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.browserType).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("browserType", (Object)this.browserType).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SeleniumBrowserFactory)) {
            return false;
        }
        SeleniumBrowserFactory rhs = (SeleniumBrowserFactory)obj;
        return new EqualsBuilder().append((Object)this.browserType, (Object)rhs.browserType).isEquals();
    }
}

