/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.browser;

import com.galenframework.browser.Browser;
import com.galenframework.browser.BrowserFactory;
import com.galenframework.browser.SeleniumBrowser;
import com.galenframework.javascript.GalenJsExecutor;
import java.io.File;
import java.io.FileReader;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mozilla.javascript.NativeJavaObject;
import org.openqa.selenium.WebDriver;

public class JsBrowserFactory
implements BrowserFactory {
    private String scriptPath;
    private String[] args;

    public JsBrowserFactory(String scriptPath, String[] args) {
        this.scriptPath = scriptPath;
        this.args = args;
    }

    @Override
    public Browser openBrowser() {
        Object result;
        File file = new File(this.scriptPath);
        GalenJsExecutor js = new GalenJsExecutor();
        js.putObject("args", this.args);
        try {
            FileReader scriptFileReader = new FileReader(file);
            result = js.eval(scriptFileReader, this.scriptPath);
        }
        catch (Exception e) {
            throw new RuntimeException("Error opening browser", e);
        }
        if (result == null) {
            throw new RuntimeException("You need to return either WebDriver either Browser instance from script");
        }
        if (result instanceof NativeJavaObject) {
            NativeJavaObject nativeJavaObject = (NativeJavaObject)result;
            Object object = nativeJavaObject.unwrap();
            if (object instanceof WebDriver) {
                return new SeleniumBrowser((WebDriver)object);
            }
            if (object instanceof Browser) {
                return (Browser)object;
            }
            throw new RuntimeException("Expecting WebDriver or Browser but got " + object.getClass());
        }
        throw new RuntimeException("Expecting NativeJavaObject but got " + result.getClass());
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("scriptPath", (Object)this.scriptPath).append("args", (Object[])this.args).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.scriptPath).append((Object[])this.args).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JsBrowserFactory)) {
            return false;
        }
        JsBrowserFactory rhs = (JsBrowserFactory)obj;
        return new EqualsBuilder().append((Object)this.scriptPath, (Object)rhs.scriptPath).append((Object[])this.args, (Object[])rhs.args).isEquals();
    }
}

