/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.GalenAction;
import com.galenframework.actions.GalenActionConfigArguments;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class GalenActionConfig
extends GalenAction {
    public static final String GALEN_USER_HOME_CONFIG_NAME = ".galen.config";
    private final GalenActionConfigArguments configArguments;

    public GalenActionConfig(String[] arguments, PrintStream outStream, PrintStream errStream) {
        super(arguments, outStream, errStream);
        this.configArguments = GalenActionConfigArguments.parse(arguments);
    }

    @Override
    public void execute() throws IOException {
        if (this.configArguments.getGlobal().booleanValue()) {
            this.createConfigFor(System.getProperty("user.home") + File.separator + GALEN_USER_HOME_CONFIG_NAME);
        } else {
            this.createConfigFor("galen.config");
        }
    }

    private void createConfigFor(String filePath) throws IOException {
        File file = new File(filePath);
        if (!file.exists()) {
            if (!file.createNewFile()) {
                throw new RuntimeException("Could not create file: " + file.getAbsolutePath());
            }
            FileOutputStream fos = new FileOutputStream(file);
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)this.getClass().getResourceAsStream("/config-template.conf"), (Writer)writer, (String)"UTF-8");
            IOUtils.write((String)writer.toString(), (OutputStream)fos, (String)"UTF-8");
            fos.flush();
            fos.close();
            this.outStream.println("Created config file: " + file.getAbsolutePath());
        } else {
            this.errStream.println("Config file already exists");
        }
    }
}

