/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.ArgumentsUtils;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class GalenActionCheckArguments {
    private List<String> paths;
    private List<String> includedTags;
    private List<String> excludedTags;
    private String url;
    private Dimension screenSize;
    private String htmlReport;
    private String testngReport;
    private String junitReport;
    private String jsonReport;
    private String javascript;
    private String config;

    public static GalenActionCheckArguments parse(String[] args) {
        CommandLine cmd;
        args = ArgumentsUtils.processSystemProperties(args);
        Options options = new Options();
        options.addOption("i", "include", true, "Tags for sections that should be included in test run");
        options.addOption("e", "exclude", true, "Tags for sections that should be excluded from test run");
        options.addOption("h", "htmlreport", true, "Path for html output report");
        options.addOption("j", "jsonreport", true, "Path for json report");
        options.addOption("g", "testngreport", true, "Path for testng xml report");
        options.addOption("x", "junitreport", true, "Path for junit xml report");
        options.addOption("u", "url", true, "Initial test url");
        options.addOption("s", "size", true, "Browser window size");
        options.addOption("J", "javascript", true, "JavaScript code that should be executed before checking layout");
        options.addOption("c", "config", true, "Path to config");
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (MissingArgumentException e) {
            throw new IllegalArgumentException("Missing value for " + e.getOption().getLongOpt(), e);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        GalenActionCheckArguments arguments = new GalenActionCheckArguments();
        arguments.setTestngReport(cmd.getOptionValue("g"));
        arguments.setJunitReport(cmd.getOptionValue("x"));
        arguments.setHtmlReport(cmd.getOptionValue("h"));
        arguments.setJsonReport(cmd.getOptionValue("j"));
        arguments.setUrl(cmd.getOptionValue("u"));
        arguments.setScreenSize(GalenActionCheckArguments.convertScreenSize(cmd.getOptionValue("s")));
        arguments.setJavascript(cmd.getOptionValue("J"));
        arguments.setIncludedTags(ArgumentsUtils.convertTags(cmd.getOptionValue("i")));
        arguments.setExcludedTags(ArgumentsUtils.convertTags(cmd.getOptionValue("e")));
        arguments.setPaths(Arrays.asList(cmd.getArgs()));
        arguments.setConfig(cmd.getOptionValue("c"));
        if (arguments.getPaths().isEmpty()) {
            throw new IllegalArgumentException("Missing spec files");
        }
        return arguments;
    }

    private static Dimension convertScreenSize(String text) {
        String[] values;
        if (text == null) {
            return null;
        }
        if (Pattern.matches("[0-9]+x[0-9]+", text) && (values = text.split("x")).length == 2) {
            return new Dimension(Integer.parseInt(values[0]), Integer.parseInt(values[1]));
        }
        throw new IllegalArgumentException("Incorrect size: " + text);
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public GalenActionCheckArguments setPaths(List<String> paths) {
        this.paths = paths;
        return this;
    }

    public String getJsonReport() {
        return this.jsonReport;
    }

    public GalenActionCheckArguments setJsonReport(String jsonReport) {
        this.jsonReport = jsonReport;
        return this;
    }

    public String getTestngReport() {
        return this.testngReport;
    }

    public GalenActionCheckArguments setTestngReport(String testngReport) {
        this.testngReport = testngReport;
        return this;
    }

    public String getJunitReport() {
        return this.junitReport;
    }

    public GalenActionCheckArguments setJunitReport(String junitReport) {
        this.junitReport = junitReport;
        return this;
    }

    public String getHtmlReport() {
        return this.htmlReport;
    }

    public GalenActionCheckArguments setHtmlReport(String htmlReport) {
        this.htmlReport = htmlReport;
        return this;
    }

    public List<String> getExcludedTags() {
        return this.excludedTags;
    }

    public GalenActionCheckArguments setExcludedTags(List<String> excludedTags) {
        this.excludedTags = excludedTags;
        return this;
    }

    public List<String> getIncludedTags() {
        return this.includedTags;
    }

    public GalenActionCheckArguments setIncludedTags(List<String> includedTags) {
        this.includedTags = includedTags;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public GalenActionCheckArguments setUrl(String url) {
        this.url = url;
        return this;
    }

    public Dimension getScreenSize() {
        return this.screenSize;
    }

    public GalenActionCheckArguments setScreenSize(Dimension screenSize) {
        this.screenSize = screenSize;
        return this;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public GalenActionCheckArguments setJavascript(String javascript) {
        this.javascript = javascript;
        return this;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.paths).append(this.includedTags).append(this.excludedTags).append((Object)this.url).append((Object)this.screenSize).append((Object)this.htmlReport).append((Object)this.testngReport).append((Object)this.junitReport).append((Object)this.jsonReport).append((Object)this.javascript).append((Object)this.config).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GalenActionCheckArguments)) {
            return false;
        }
        GalenActionCheckArguments rhs = (GalenActionCheckArguments)obj;
        return new EqualsBuilder().append(rhs.paths, this.paths).append(rhs.includedTags, this.includedTags).append(rhs.excludedTags, this.excludedTags).append((Object)rhs.url, (Object)this.url).append((Object)rhs.screenSize, (Object)this.screenSize).append((Object)rhs.htmlReport, (Object)this.htmlReport).append((Object)rhs.testngReport, (Object)this.testngReport).append((Object)rhs.junitReport, (Object)this.junitReport).append((Object)rhs.jsonReport, (Object)this.jsonReport).append((Object)rhs.javascript, (Object)this.javascript).append((Object)rhs.config, (Object)this.config).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("paths", this.paths).append("includedTags", this.includedTags).append("excludedTags", this.excludedTags).append("url", (Object)this.url).append("screenSize", (Object)this.screenSize).append("htmlReport", (Object)this.htmlReport).append("testngReport", (Object)this.testngReport).append("junitReport", (Object)this.junitReport).append("jsonReport", (Object)this.jsonReport).append("javascript", (Object)this.javascript).append("config", (Object)this.config).toString();
    }

    public GalenActionCheckArguments setConfig(String config) {
        this.config = config;
        return this;
    }

    public String getConfig() {
        return this.config;
    }
}

