/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.GalenAction;
import com.galenframework.actions.GalenActionCheckArguments;
import com.galenframework.actions.GalenActionTest;
import com.galenframework.actions.GalenActionTestArguments;
import com.galenframework.browser.SeleniumBrowserFactory;
import com.galenframework.runner.CombinedListener;
import com.galenframework.runner.EventHandler;
import com.galenframework.suite.GalenPageTest;
import com.galenframework.suite.actions.GalenPageActionCheck;
import com.galenframework.tests.GalenBasicTest;
import com.galenframework.tests.GalenTest;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;

public class GalenActionCheck
extends GalenAction {
    private final GalenActionCheckArguments checkArguments;
    private final CombinedListener listener;

    public GalenActionCheck(String[] arguments, PrintStream outStream, PrintStream errStream, CombinedListener listener) {
        super(arguments, outStream, errStream);
        this.checkArguments = GalenActionCheckArguments.parse(arguments);
        this.listener = this.createListeners(listener);
    }

    @Override
    public void execute() throws IOException {
        this.verifyArgumentsForPageCheck();
        this.loadConfigIfNeeded(this.getCheckArguments().getConfig());
        LinkedList<GalenTest> galenTests = new LinkedList<GalenTest>();
        for (String pageSpecPath : this.checkArguments.getPaths()) {
            GalenBasicTest test = new GalenBasicTest();
            test.setName(pageSpecPath);
            test.setPageTests(Arrays.asList(new GalenPageTest().withTitle("Simple check").withUrl(this.checkArguments.getUrl()).withSize(this.checkArguments.getScreenSize()).withBrowserFactory(new SeleniumBrowserFactory()).withActions(Arrays.asList(new GalenPageActionCheck().withSpec(pageSpecPath).withIncludedTags(this.checkArguments.getIncludedTags()).withExcludedTags(this.checkArguments.getExcludedTags()).withOriginalCommand(this.originalCommand(this.arguments))))));
            galenTests.add(test);
        }
        GalenActionTestArguments testArguments = new GalenActionTestArguments();
        testArguments.setHtmlReport(this.checkArguments.getHtmlReport());
        testArguments.setJsonReport(this.checkArguments.getJsonReport());
        testArguments.setJunitReport(this.checkArguments.getJunitReport());
        testArguments.setTestngReport(this.checkArguments.getTestngReport());
        GalenActionTest.runTests(new EventHandler(), galenTests, testArguments, this.listener);
    }

    private String originalCommand(String[] arguments) {
        StringBuilder builder = new StringBuilder("check ");
        for (String argument : arguments) {
            builder.append(" ");
            builder.append(argument);
        }
        return builder.toString();
    }

    private void verifyArgumentsForPageCheck() {
        if (this.checkArguments.getUrl() == null) {
            throw new IllegalArgumentException("Url is not specified");
        }
        if (this.checkArguments.getScreenSize() == null) {
            throw new IllegalArgumentException("Screen size is not specified");
        }
        if (this.checkArguments.getPaths().size() < 1) {
            throw new IllegalArgumentException("There are no specs specified");
        }
    }

    public GalenActionCheckArguments getCheckArguments() {
        return this.checkArguments;
    }
}

