/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.actions;

import com.galenframework.actions.GalenActionCheck;
import com.galenframework.actions.GalenActionConfig;
import com.galenframework.actions.GalenActionDump;
import com.galenframework.actions.GalenActionHelp;
import com.galenframework.actions.GalenActionTest;
import com.galenframework.actions.GalenActionVersion;
import com.galenframework.config.GalenConfig;
import com.galenframework.reports.ConsoleReportingListener;
import com.galenframework.runner.CombinedListener;
import com.galenframework.runner.CompleteListener;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;

public abstract class GalenAction {
    protected final PrintStream outStream;
    protected final PrintStream errStream;
    protected final String[] arguments;

    public GalenAction(String[] arguments, PrintStream outStream, PrintStream errStream) {
        this.arguments = arguments;
        this.outStream = outStream;
        this.errStream = errStream;
    }

    public void loadConfigIfNeeded(String configPath) throws IOException {
        if (configPath != null) {
            GalenConfig.reloadConfigFromPath(configPath);
        }
    }

    public abstract void execute() throws Exception;

    public static GalenAction create(String actionName, String[] arguments, PrintStream outStream, PrintStream errStream, CombinedListener combinedListener) {
        switch (actionName) {
            case "test": {
                return new GalenActionTest(arguments, outStream, errStream, combinedListener);
            }
            case "check": {
                return new GalenActionCheck(arguments, outStream, errStream, combinedListener);
            }
            case "dump": {
                return new GalenActionDump(arguments, outStream, errStream);
            }
            case "help": 
            case "-h": 
            case "--help": {
                return new GalenActionHelp(arguments, outStream, errStream);
            }
            case "version": 
            case "-v": 
            case "--version": {
                return new GalenActionVersion(arguments, outStream, errStream);
            }
            case "config": {
                return new GalenActionConfig(arguments, outStream, errStream);
            }
        }
        throw new RuntimeException("Unknown action: " + actionName);
    }

    public CombinedListener createListeners(CombinedListener originalListener) {
        try {
            CombinedListener combinedListener = new CombinedListener();
            combinedListener.add(new ConsoleReportingListener(this.outStream, this.outStream));
            List<CompleteListener> configuredListeners = GalenAction.getConfiguredListeners();
            for (CompleteListener configuredListener : configuredListeners) {
                combinedListener.add(configuredListener);
            }
            if (originalListener != null) {
                combinedListener.add(originalListener);
            }
            return combinedListener;
        }
        catch (Exception ex) {
            throw new RuntimeException("Couldn't configure listeners", ex);
        }
    }

    public static List<CompleteListener> getConfiguredListeners() throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        LinkedList<CompleteListener> configuredListeners = new LinkedList<CompleteListener>();
        List<String> classNames = GalenConfig.getConfig().getReportingListeners();
        for (String className : classNames) {
            Constructor<?> constructor = Class.forName(className).getConstructor(new Class[0]);
            configuredListeners.add((CompleteListener)constructor.newInstance(new Object[0]));
        }
        return configuredListeners;
    }
}

