/*******************************************************************************
* Copyright 2017 Ivan Shubin http://galenframework.com
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
* 
*   http://www.apache.org/licenses/LICENSE-2.0
* 
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
******************************************************************************/
package com.galenframework.actions;

import org.apache.commons.io.IOUtils;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class GalenActionHelp extends GalenAction {
    public GalenActionHelp(String[] arguments, PrintStream outStream, PrintStream errStream) {
        super(arguments, outStream, errStream);
    }

    @Override
    public void execute() throws IOException {
        InputStream helpStream = getClass().getResourceAsStream("/galen-help-text");
        IOUtils.copy(helpStream, outStream);
    }
}
