/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.activity.gallery.GridFilesActivity;
import com.gaadi.neon.activity.gallery.HorizontalFilesActivity;
import com.gaadi.neon.adapter.FolderHolder;
import com.gaadi.neon.enumerations.GalleryType;
import com.gaadi.neon.model.BucketModel;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ImagesFoldersAdapter
extends BaseAdapter {
    private Activity context;
    private ArrayList<BucketModel> folders;

    public ImagesFoldersAdapter(Activity context, ArrayList<BucketModel> bucketModels) {
        this.context = context;
        this.folders = bucketModels;
        if (NeonImagesHandler.getSingletonInstance().getGalleryParam() != null && NeonImagesHandler.getSingletonInstance().getGalleryParam().getGalleryViewType() != null && NeonImagesHandler.getSingletonInstance().getGalleryParam().getGalleryViewType() == GalleryType.Folder_Alphabetical_Sorted) {
            Collections.sort(this.folders, new Comparator<BucketModel>(){

                @Override
                public int compare(BucketModel bucketModel1, BucketModel bucketModel2) {
                    if (bucketModel1 == null || bucketModel1.getBucketName() == null) {
                        return bucketModel2 == null || bucketModel2.getBucketName() == null ? 0 : -1;
                    }
                    if (bucketModel2 == null || bucketModel2.getBucketName() == null) {
                        return 1;
                    }
                    return bucketModel1.getBucketName().compareToIgnoreCase(bucketModel2.getBucketName());
                }
            });
        }
    }

    public int getCount() {
        return this.folders.size();
    }

    public Object getItem(int position) {
        return this.folders.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        FolderHolder holder;
        if (convertView == null) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            convertView = inflater.inflate(R.layout.gallery_folder_layout, null);
            holder = new FolderHolder();
            holder.imageView = (ImageView)convertView.findViewById(R.id.ivFolderThumbnail);
            holder.countFiles = (TextView)convertView.findViewById(R.id.tvCount);
            holder.FolderName = (TextView)convertView.findViewById(R.id.tvFolderName);
            convertView.setTag((Object)holder);
        }
        holder = (FolderHolder)convertView.getTag();
        final BucketModel bucketInfo = this.folders.get(position);
        if (bucketInfo.getFileCount() > 0) {
            holder.countFiles.setText((CharSequence)String.valueOf(bucketInfo.getFileCount()));
            holder.countFiles.setVisibility(0);
        } else {
            holder.countFiles.setVisibility(4);
        }
        holder.FolderName.setText((CharSequence)this.folders.get(position).getBucketName());
        ((RequestBuilder)((RequestBuilder)((RequestBuilder)Glide.with((Activity)this.context).load("file://" + this.folders.get(position).getBucketCoverImagePath()).diskCacheStrategy(DiskCacheStrategy.ALL)).placeholder(R.drawable.default_placeholder)).centerCrop()).into(holder.imageView);
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NeonImagesHandler.getSingletonInstance().getGalleryParam() != null && NeonImagesHandler.getSingletonInstance().getGalleryParam().getGalleryViewType() != null) {
                    Intent filesIntent;
                    switch (NeonImagesHandler.getSingletonInstance().getGalleryParam().getGalleryViewType()) {
                        case Folder_Alphabetical_Sorted: 
                        case Grid_Structure: {
                            filesIntent = new Intent((Context)ImagesFoldersAdapter.this.context, GridFilesActivity.class);
                            break;
                        }
                        case Horizontal_Structure: {
                            filesIntent = new Intent((Context)ImagesFoldersAdapter.this.context, HorizontalFilesActivity.class);
                            break;
                        }
                        default: {
                            filesIntent = new Intent((Context)ImagesFoldersAdapter.this.context, GridFilesActivity.class);
                        }
                    }
                    filesIntent.putExtra("BucketName", bucketInfo.getBucketName());
                    filesIntent.putExtra("BucketId", bucketInfo.getBucketId());
                    ImagesFoldersAdapter.this.context.startActivityForResult(filesIntent, 300);
                }
            }
        });
        return convertView;
    }
}

