/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.text.Spannable;
import android.text.style.ForegroundColorSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;

public class ImageTagsAdapter
extends ArrayAdapter<ImageTagModel> {
    private final LayoutInflater mInflater;
    private Context context;
    private ImageTagsModelsHolder mHolder;
    private FileInfo fileOnViewPager;

    public ImageTagsAdapter(Context context, FileInfo _fileOnViewPager) {
        super(context, 0x1090009);
        this.context = context;
        this.fileOnViewPager = _fileOnViewPager;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.setDropDownViewResource(R.layout.color_layout_row);
    }

    public int getCount() {
        return NeonImagesHandler.getSingleonInstance().getGenericParam().getImageTagsModel().size();
    }

    public ImageTagModel getItem(int position) {
        return NeonImagesHandler.getSingleonInstance().getGenericParam().getImageTagsModel().get(position);
    }

    public long getItemId(int position) {
        return NeonImagesHandler.getSingleonInstance().getGenericParam().getImageTagsModel().indexOf(this.getItem(position));
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ImageTagModel tagsModel = NeonImagesHandler.getSingleonInstance().getGenericParam().getImageTagsModel().get(position);
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.color_layout_row, parent, false);
            this.mHolder = new ImageTagsModelsHolder();
            this.mHolder.text = (TextView)convertView.findViewById(R.id.colorValue);
            this.mHolder.colorLayoutRoot = convertView.findViewById(R.id.colorLayout);
            this.mHolder.iv_color = (ImageView)convertView.findViewById(R.id.color);
            convertView.setTag((Object)this.mHolder);
        } else {
            this.mHolder = (ImageTagsModelsHolder)convertView.getTag();
        }
        if (NeonImagesHandler.getSingleonInstance().checkImagesAvailableForTag(tagsModel)) {
            convertView.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)0x1060000));
        } else {
            convertView.setBackgroundColor(ContextCompat.getColor((Context)this.context, (int)17170445));
        }
        if (tagsModel.isMandatory()) {
            this.mHolder.text.setText((CharSequence)"");
            this.mHolder.text.append((CharSequence)("*" + tagsModel.getTagName()));
            Spannable sText = (Spannable)this.mHolder.text.getText();
            sText.setSpan((Object)new ForegroundColorSpan(-65536), 0, 1, 0);
            this.mHolder.text.setText((CharSequence)sText, TextView.BufferType.SPANNABLE);
        } else {
            this.mHolder.text.setText((CharSequence)("  " + tagsModel.getTagName()));
        }
        this.mHolder.iv_color.setVisibility(8);
        return convertView;
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.color_layout_row, parent, false);
            this.mHolder = new ImageTagsModelsHolder();
            this.mHolder.text = (TextView)convertView.findViewById(R.id.colorValue);
            this.mHolder.colorLayoutRoot = convertView.findViewById(R.id.colorLayout);
            this.mHolder.iv_color = (ImageView)convertView.findViewById(R.id.color);
            convertView.setTag((Object)this.mHolder);
        } else {
            this.mHolder = (ImageTagsModelsHolder)convertView.getTag();
        }
        this.mHolder.text.setText((CharSequence)NeonImagesHandler.getSingleonInstance().getGenericParam().getImageTagsModel().get(position).getTagName());
        return convertView;
    }

    private class ImageTagsModelsHolder {
        TextView text;
        ImageView iv_color;
        View colorLayoutRoot;

        private ImageTagsModelsHolder() {
        }
    }
}

