/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.NotificationCompat;
import android.support.v4.app.TaskStackBuilder;
import android.support.v4.content.ContextCompat;
import android.support.v4.os.EnvironmentCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.gaadi.neon.util.FileInfo;
import com.scanlibrary.R;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class NeonUtils {
    public static void createNotification(Context context, int smallIcon, String title, String content, Intent resultIntent, int imageUploadNotifId) {
        NotificationCompat.Builder mBuilder = new NotificationCompat.Builder(context).setSmallIcon(smallIcon).setContentTitle((CharSequence)title).setAutoCancel(true).setContentText((CharSequence)content);
        TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)context);
        stackBuilder.addNextIntent(resultIntent);
        PendingIntent resultPendingIntent = stackBuilder.getPendingIntent(0, 0x8000000);
        mBuilder.setContentIntent(resultPendingIntent);
        NotificationManager mNotificationManager = (NotificationManager)context.getSystemService("notification");
        mNotificationManager.notify(imageUploadNotifId, mBuilder.build());
    }

    public static String getStringSharedPreference(Context context, String key, String defaultValue) {
        SharedPreferences preferences = context.getApplicationContext().getSharedPreferences("com.gcloud.gaadi.prefs", 0);
        if (preferences.contains(key)) {
            return preferences.getString(key, defaultValue);
        }
        return defaultValue;
    }

    private String verifyFolder(File file) {
        File[] filesInFolder = file.listFiles();
        if (filesInFolder != null && filesInFolder.length > 0) {
            for (File file1 : filesInFolder) {
                if (!file1.getName().contains("jpg") && !file1.getName().contains("jpeg") && !file1.getName().contains("png")) continue;
                return file1.getAbsolutePath();
            }
        }
        return "";
    }

    private ArrayList<FileInfo> getFolders() {
        File pathPictures = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        ArrayList<FileInfo> files1 = this.getAllFoldersInfo(pathPictures);
        File pathDCIM = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        ArrayList<FileInfo> files2 = this.getAllFoldersInfo(pathDCIM);
        files1.addAll(files2);
        String secStore = System.getenv("SECONDARY_STORAGE");
        try {
            if (secStore != null) {
                int index = secStore.indexOf(":");
                String externalStorage = "";
                externalStorage = index > 0 ? secStore.substring(0, index) : secStore;
                String externalStorageDCIM = externalStorage + "/DCIM";
                File externalFile = new File(externalStorageDCIM);
                ArrayList<FileInfo> externalFiles = this.getAllFoldersInfo(externalFile);
                files1.addAll(externalFiles);
            }
        }
        catch (Exception index) {
            // empty catch block
        }
        File pathWhatsApp = new File(Environment.getExternalStorageDirectory() + "/WhatsApp/Media/WhatsApp Images");
        Log.e((String)"Gallery", (String)pathWhatsApp.getAbsolutePath());
        ArrayList<FileInfo> files3 = this.getAllFoldersInfo(pathWhatsApp);
        files1.addAll(files3);
        File pathDownload = new File(Environment.getExternalStorageDirectory() + "/Download");
        Log.e((String)"Gallery", (String)("pathDownload : " + pathDownload.getName()));
        ArrayList<FileInfo> files4 = this.getAllFoldersInfo(pathDownload);
        files1.addAll(files4);
        return files1;
    }

    private ArrayList<FileInfo> getAllFoldersInfo(File file) {
        ArrayList<FileInfo> allFiles = new ArrayList<FileInfo>();
        File[] contentPictures = file.listFiles();
        if (contentPictures == null || contentPictures.length == 0) {
            Log.e((String)"Gallery", (String)"No Files found at the path mentioned");
        } else {
            Boolean makeSelfFolder = false;
            for (File folder : contentPictures) {
                if (!folder.isDirectory()) {
                    makeSelfFolder = true;
                }
                String valid = this.verifyFolder(folder);
                if (folder.getName().equals("Sent") || valid.length() <= 0) continue;
                FileInfo fileInfo = new FileInfo();
                fileInfo.setDisplayName(folder.getName());
                fileInfo.setFileName(folder.getAbsolutePath());
                File[] imagesInFolder = folder.listFiles();
                if (imagesInFolder == null) continue;
                if (imagesInFolder.length == 0) {
                    fileInfo.setFilePath(folder.getAbsolutePath());
                } else {
                    fileInfo.setType(FileInfo.FILE_TYPE.FOLDER);
                    fileInfo.setFileCount(imagesInFolder.length);
                    fileInfo.setFilePath(imagesInFolder[imagesInFolder.length - 1].getAbsolutePath());
                }
                allFiles.add(fileInfo);
            }
            if (makeSelfFolder.booleanValue()) {
                FileInfo selfFolder = new FileInfo();
                selfFolder.setDisplayName(file.getName());
                selfFolder.setType(FileInfo.FILE_TYPE.FOLDER);
                selfFolder.setFileName(file.getAbsolutePath());
                selfFolder.setFilePath(contentPictures[contentPictures.length - 1].getAbsolutePath());
                allFiles.add(selfFolder);
            }
        }
        return allFiles;
    }

    public static ArrayList<FileInfo> removeFileInfo(ArrayList<FileInfo> source, FileInfo fileInfo) {
        for (FileInfo fileInfo1 : source) {
            if (!fileInfo.getFilePath().equals(fileInfo1.getFilePath())) continue;
            source.remove(fileInfo);
            break;
        }
        return source;
    }

    public static void removeFileInfo(ArrayList<String> source, ArrayList<FileInfo> removeFiles, Boolean flag) {
        if (source == null) {
            return;
        }
        for (FileInfo fileInfo : removeFiles) {
            if (!source.contains(fileInfo.getFilePath())) continue;
            source.remove(fileInfo.getFilePath());
        }
    }

    public static void addFileInfo(ArrayList<FileInfo> source, FileInfo fileInfo) {
        Boolean alreadyPresent = false;
        for (FileInfo fileInfo1 : source) {
            if (!fileInfo.getFilePath().equals(fileInfo1.getFilePath())) continue;
            alreadyPresent = true;
            break;
        }
        if (!alreadyPresent.booleanValue()) {
            source.add(fileInfo);
        }
    }

    public static void removeFileInfo(ArrayList<FileInfo> source, String filePath) {
        for (FileInfo fileInfo : source) {
            if (!filePath.equals(fileInfo.getFilePath())) continue;
            source.remove(fileInfo);
            break;
        }
    }

    public static void removeFileInfo(ArrayList<FileInfo> source, ArrayList<FileInfo> fileInfos) {
        ArrayList<FileInfo> toBeDeleted = new ArrayList<FileInfo>();
        block0: for (FileInfo fileInfo : source) {
            for (FileInfo fileInfo1 : fileInfos) {
                if (!fileInfo1.getFilePath().equals(fileInfo.getFilePath())) continue;
                toBeDeleted.add(fileInfo);
                continue block0;
            }
        }
        source.removeAll(toBeDeleted);
    }

    public static void expand(final View v) {
        v.measure(-1, -2);
        final int targetHeight = v.getMeasuredHeight();
        v.getLayoutParams().height = 0;
        v.setVisibility(0);
        Animation a = new Animation(){

            protected void applyTransformation(float interpolatedTime, Transformation t) {
                v.getLayoutParams().height = interpolatedTime == 1.0f ? -2 : (int)((float)targetHeight * interpolatedTime);
                v.requestLayout();
            }

            public boolean willChangeBounds() {
                return true;
            }
        };
        a.setDuration((long)((int)((float)targetHeight / v.getContext().getResources().getDisplayMetrics().density)));
        v.startAnimation(a);
    }

    public static Uri getImageStoreUri() {
        return MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    }

    public static boolean getBooleanSharedPreference(Context context, String key, boolean defaultValue) {
        SharedPreferences preferences = context.getApplicationContext().getSharedPreferences("com.gcloud.gaadi.prefs", 0);
        if (preferences.contains(key)) {
            return preferences.getBoolean(key, defaultValue);
        }
        return defaultValue;
    }

    public static void setBooleanSharedPreference(Context context, String key, boolean value) {
        SharedPreferences preferences = context.getApplicationContext().getSharedPreferences("com.gcloud.gaadi.prefs", 0);
        SharedPreferences.Editor editor = preferences.edit();
        if (key != null && !key.isEmpty()) {
            editor.putBoolean(key, value);
            editor.apply();
        }
    }

    public static boolean checkForPermission(final Context context, String[] permissions, final int requestCode, String requestFor) {
        final ArrayList<String> permissionNeededForList = NeonUtils.checkSelfPermission(context, permissions);
        String requestsFor = permissionNeededForList.get(permissionNeededForList.size() - 1);
        permissionNeededForList.remove(permissionNeededForList.size() - 1);
        if (permissionNeededForList.isEmpty()) {
            return true;
        }
        if (!requestsFor.isEmpty()) {
            new AlertDialog.Builder(context).setTitle((CharSequence)context.getString(R.string.permission_error)).setMessage((CharSequence)context.getString(R.string.you_need_to_allow_access_to, (Object[])new String[]{requestFor, requestFor})).setPositiveButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    NeonUtils.requestPermission(context, permissionNeededForList.toArray(new String[permissionNeededForList.size()]), requestCode);
                }
            }).setNegativeButton((CharSequence)context.getString(R.string.go_to_app_info), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
                    Uri uri = Uri.fromParts((String)"package", (String)context.getPackageName(), null);
                    intent.setData(uri);
                    ((Activity)context).startActivityForResult(intent, 10);
                }
            }).create().show();
        }
        NeonUtils.requestPermission(context, permissionNeededForList.toArray(new String[permissionNeededForList.size()]), requestCode);
        return false;
    }

    private static ArrayList<String> checkSelfPermission(Context context, String[] permissions) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder requestsFor = new StringBuilder();
        for (String permission : permissions) {
            if (ActivityCompat.checkSelfPermission((Context)context, (String)permission) == 0) continue;
            list.add(permission);
            if (NeonUtils.getBooleanSharedPreference(context, permission, false)) {
                if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)((Activity)context), (String)permission)) continue;
                if (requestsFor.length() > 0) {
                    requestsFor.append(", ");
                }
                requestsFor.append(permission.substring(permission.lastIndexOf(".") + 1));
                continue;
            }
            NeonUtils.setBooleanSharedPreference(context, permission, true);
        }
        if (requestsFor.length() > 0) {
            list.add(requestsFor.toString());
        } else {
            list.add("");
        }
        return list;
    }

    private static void requestPermission(Context context, String[] permissions, int requestCode) {
        ActivityCompat.requestPermissions((Activity)((Activity)context), (String[])permissions, (int)requestCode);
    }

    public static int isFrontCameraAvailable() {
        Camera.CameraInfo ci = new Camera.CameraInfo();
        for (int i = 0; i < Camera.getNumberOfCameras(); ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)ci);
            if (ci.facing != 1) continue;
            return 1;
        }
        return 0;
    }

    public static Bitmap doBrightness(Bitmap src, int value) {
        int width = src.getWidth();
        int height = src.getHeight();
        Bitmap bmOut = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)src.getConfig());
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel = src.getPixel(x, y);
                int A = Color.alpha((int)pixel);
                int R2 = Color.red((int)pixel);
                int G = Color.green((int)pixel);
                int B = Color.blue((int)pixel);
                if ((R2 += value) > 255) {
                    R2 = 255;
                } else if (R2 < 0) {
                    R2 = 0;
                }
                if ((G += value) > 255) {
                    G = 255;
                } else if (G < 0) {
                    G = 0;
                }
                if ((B += value) > 255) {
                    B = 255;
                } else if (B < 0) {
                    B = 0;
                }
                bmOut.setPixel(x, y, Color.argb((int)A, (int)R2, (int)G, (int)B));
            }
        }
        return bmOut;
    }

    public static File getEmptyStoragePath(Context ctx) {
        File externalDir;
        File mediaFile = null;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss.SSS").format(new Date());
        String selectedPath = null;
        ArrayList list = (ArrayList)NeonUtils.getSdCardPaths(ctx, true);
        for (String path : list) {
            long freeBytes = new File(path).getFreeSpace();
            if (freeBytes <= 5120L) continue;
            selectedPath = path;
            break;
        }
        if (!(externalDir = new File(selectedPath, ctx.getString(R.string.app_name))).exists() && !externalDir.mkdir()) {
            Log.d((String)"MyCameraApp", (String)"failed to create directory");
            return null;
        }
        mediaFile = new File(externalDir.getPath() + File.separator + "IMG_" + timeStamp + ".jpg");
        return mediaFile;
    }

    public static List<String> getSdCardPaths(Context context, boolean includePrimaryExternalStorage) {
        File mediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).toString());
        ArrayList<String> result = new ArrayList<String>();
        if (!mediaStorageDir.exists()) {
            if (!mediaStorageDir.mkdir()) {
                Log.e((String)"CommonUtils", (String)"Pictures Directory not found");
            } else {
                result.add(mediaStorageDir.getAbsolutePath());
            }
        } else {
            result.add(mediaStorageDir.getAbsolutePath());
        }
        File[] externalCacheDirs = ContextCompat.getExternalFilesDirs((Context)context, null);
        if (externalCacheDirs == null || externalCacheDirs.length == 0) {
            return null;
        }
        if (externalCacheDirs.length == 1) {
            if (externalCacheDirs[0] == null) {
                return null;
            }
            String storageState = EnvironmentCompat.getStorageState((File)externalCacheDirs[0]);
            if (!"mounted".equals(storageState)) {
                return null;
            }
            if (!includePrimaryExternalStorage && Build.VERSION.SDK_INT >= 11 && Environment.isExternalStorageEmulated()) {
                return null;
            }
        }
        if (includePrimaryExternalStorage || externalCacheDirs.length == 1) {
            result.add(externalCacheDirs[0].getAbsolutePath());
        }
        for (int i = 1; i < externalCacheDirs.length; ++i) {
            String storageState;
            File file = externalCacheDirs[i];
            if (file == null || !"mounted".equals(storageState = EnvironmentCompat.getStorageState((File)file))) continue;
            result.add(externalCacheDirs[i].getAbsolutePath());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

