/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.media.ThumbnailUtils;
import android.os.Bundle;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.ImageShow;
import com.gaadi.neon.activity.camera.NeonBaseCameraActivity;
import com.gaadi.neon.enumerations.CameraType;
import com.gaadi.neon.enumerations.GalleryType;
import com.gaadi.neon.enumerations.ResponseCode;
import com.gaadi.neon.fragment.CameraFragment1;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.interfaces.LivePhotoNextTagListener;
import com.gaadi.neon.interfaces.OnPermissionResultListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.AnimationUtils;
import com.gaadi.neon.util.CustomParameters;
import com.gaadi.neon.util.ExifInterfaceHandling;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.FindLocations;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.PermissionType;
import com.scanlibrary.R;
import com.scanlibrary.databinding.NormalCameraActivityLayoutBinding;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NormalCameraActivityNeon
extends NeonBaseCameraActivity
implements CameraFragment1.SetOnPictureTaken,
LivePhotoNextTagListener,
FindLocations.ILocation {
    ICameraParam cameraParams;
    RelativeLayout tagsLayout;
    List<ImageTagModel> tagModels;
    int currentTag;
    NormalCameraActivityLayoutBinding binder;
    private TextView tvTag;
    private TextView tvNext;
    private TextView tvPrevious;
    private ImageView buttonGallery;
    private Location location;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bindXml();
        this.cameraParams = NeonImagesHandler.getSingletonInstance().getCameraParam();
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            this.binder.buttonDone.setVisibility(4);
        } else {
            this.binder.buttonDone.setVisibility(0);
        }
        this.customize();
        this.bindCameraFragment();
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            NeonImagesHandler.getSingletonInstance().setLivePhotoNextTagListener(this);
        }
        if (this.cameraParams == null || this.cameraParams.getCustomParameters() == null || this.cameraParams.getCustomParameters().getLocationRestrictive()) {
            FindLocations.getInstance().init((Activity)this);
            FindLocations.getInstance().checkPermissions((Activity)this);
        }
    }

    private void bindCameraFragment() {
        try {
            this.askForPermissionIfNeeded(PermissionType.write_external_storage, new OnPermissionResultListener(){

                @Override
                public void onResult(boolean permissionGranted) {
                    if (permissionGranted) {
                        try {
                            NormalCameraActivityNeon.this.askForPermissionIfNeeded(PermissionType.camera, new OnPermissionResultListener(){

                                @Override
                                public void onResult(boolean permissionGranted) {
                                    if (permissionGranted) {
                                        new Handler().post(new Runnable(){

                                            @Override
                                            public void run() {
                                                try {
                                                    boolean locationRestrictive = true;
                                                    if (NormalCameraActivityNeon.this.cameraParams != null && NormalCameraActivityNeon.this.cameraParams.getCustomParameters() != null) {
                                                        locationRestrictive = NormalCameraActivityNeon.this.cameraParams.getCustomParameters().getLocationRestrictive();
                                                    }
                                                    CameraFragment1 fragment = CameraFragment1.getInstance(locationRestrictive);
                                                    FragmentManager manager = NormalCameraActivityNeon.this.getSupportFragmentManager();
                                                    manager.beginTransaction().replace(R.id.content_frame, (Fragment)fragment).commit();
                                                }
                                                catch (Exception e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                        });
                                    } else {
                                        if (NeonImagesHandler.getSingletonInstance().isNeutralEnabled()) {
                                            NormalCameraActivityNeon.this.finish();
                                        } else {
                                            NeonImagesHandler.getSingletonInstance().sendImageCollectionAndFinish((Activity)NormalCameraActivityNeon.this, ResponseCode.Camera_Permission_Error);
                                        }
                                        Toast.makeText((Context)NormalCameraActivityNeon.this, (int)R.string.permission_error, (int)0).show();
                                    }
                                }
                            });
                        }
                        catch (ManifestPermission manifestPermission) {
                            manifestPermission.printStackTrace();
                        }
                    } else {
                        if (NeonImagesHandler.getSingletonInstance().isNeutralEnabled()) {
                            NormalCameraActivityNeon.this.finish();
                        } else {
                            NeonImagesHandler.getSingletonInstance().sendImageCollectionAndFinish((Activity)NormalCameraActivityNeon.this, ResponseCode.Write_Permission_Error);
                        }
                        Toast.makeText((Context)NormalCameraActivityNeon.this, (int)R.string.permission_error, (int)0).show();
                    }
                }
            });
        }
        catch (ManifestPermission manifestPermission) {
            manifestPermission.printStackTrace();
        }
    }

    private void bindXml() {
        this.binder = (NormalCameraActivityLayoutBinding)DataBindingUtil.setContentView((Activity)this, (int)R.layout.normal_camera_activity_layout);
        this.tvTag = this.binder.tvTag;
        this.tvNext = this.binder.tvSkip;
        this.tvPrevious = this.binder.tvPrev;
        this.buttonGallery = this.binder.buttonGallery;
        this.tagsLayout = this.binder.rlTags;
        this.binder.setHandlers(this);
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.buttonDone) {
            if (!NeonImagesHandler.getSingletonInstance().isNeutralEnabled()) {
                if (NeonImagesHandler.getSingletonInstance().getCameraParam().enableImageEditing() || NeonImagesHandler.getSingletonInstance().getCameraParam().getTagEnabled()) {
                    Intent intent = new Intent((Context)this, ImageShow.class);
                    this.startActivity(intent);
                    this.finish();
                } else if (NeonImagesHandler.getSingletonInstance().validateNeonExit((Activity)this)) {
                    NeonImagesHandler.getSingletonInstance().sendImageCollectionAndFinish((Activity)this, ResponseCode.Success);
                    this.finish();
                }
            } else {
                this.setResult(-1);
                this.finish();
            }
        } else if (id2 == R.id.buttonGallery) {
            try {
                IGalleryParam galleryParam = NeonImagesHandler.getSingletonInstance().getGalleryParam();
                if (galleryParam == null) {
                    galleryParam = new IGalleryParam(){

                        @Override
                        public boolean selectVideos() {
                            return false;
                        }

                        @Override
                        public GalleryType getGalleryViewType() {
                            return GalleryType.Grid_Structure;
                        }

                        @Override
                        public boolean enableFolderStructure() {
                            return true;
                        }

                        @Override
                        public boolean galleryToCameraSwitchEnabled() {
                            return true;
                        }

                        @Override
                        public boolean isRestrictedExtensionJpgPngEnabled() {
                            return true;
                        }

                        @Override
                        public int getNumberOfPhotos() {
                            return NeonImagesHandler.getSingletonInstance().getCameraParam().getNumberOfPhotos();
                        }

                        @Override
                        public boolean getTagEnabled() {
                            return NeonImagesHandler.getSingletonInstance().getCameraParam().getTagEnabled();
                        }

                        @Override
                        public List<ImageTagModel> getImageTagsModel() {
                            return NeonImagesHandler.getSingletonInstance().getCameraParam().getImageTagsModel();
                        }

                        public ArrayList<FileInfo> getAlreadyAddedImages() {
                            return null;
                        }

                        @Override
                        public boolean enableImageEditing() {
                            return NeonImagesHandler.getSingletonInstance().getCameraParam().enableImageEditing();
                        }

                        @Override
                        public CustomParameters getCustomParameters() {
                            return NeonImagesHandler.getSingletonInstance().getCameraParam().getCustomParameters();
                        }
                    };
                }
                PhotosLibrary.collectPhotos(NeonImagesHandler.getSingletonInstance().getRequestCode(), (Context)this, NeonImagesHandler.getSingletonInstance().getLibraryMode(), PhotosMode.setGalleryMode().setParams(galleryParam), NeonImagesHandler.getSingleonInstance().getImageResultListener());
                this.finish();
            }
            catch (NeonException e) {
                e.printStackTrace();
            }
        } else if (id2 == R.id.tvSkip) {
            if (this.currentTag == this.tagModels.size() - 1) {
                if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
                    if (NeonImagesHandler.getSingletonInstance().validateNeonExit((Activity)this)) {
                        NeonImagesHandler.getSingletonInstance().sendImageCollectionAndFinish((Activity)this, ResponseCode.Success);
                    }
                } else {
                    this.onClick((View)this.binder.buttonDone);
                }
            } else {
                this.setTag(this.getNextTag(), true);
            }
        } else if (id2 == R.id.tvPrev) {
            this.setTag(this.getPreviousTag(), false);
        }
    }

    private boolean finishValidation() {
        if (NeonImagesHandler.getSingleonInstance().getCameraParam().getTagEnabled()) {
            for (int i = 0; i < this.tagModels.size(); ++i) {
                if (!this.tagModels.get(i).isMandatory() || NeonImagesHandler.getSingleonInstance().checkImagesAvailableForTag(this.tagModels.get(i))) continue;
                Toast.makeText((Context)this, (CharSequence)String.format(this.getString(R.string.tag_mandatory_error), this.tagModels.get(i).getTagName()), (int)0).show();
                return false;
            }
        } else {
            if (NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) {
                Toast.makeText((Context)this, (int)R.string.no_images, (int)0).show();
                return false;
            }
            if (NeonImagesHandler.getSingleonInstance().getImagesCollection().size() < NeonImagesHandler.getSingleonInstance().getCameraParam().getNumberOfPhotos()) {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.more_images, new Object[]{NeonImagesHandler.getSingleonInstance().getCameraParam().getNumberOfPhotos() - NeonImagesHandler.getSingleonInstance().getImagesCollection().size()}), (int)0).show();
                return false;
            }
        }
        return true;
    }

    public ImageTagModel getNextTag() {
        ++this.currentTag;
        if (this.currentTag == this.tagModels.size() - 1) {
            this.tvNext.setVisibility(0);
            this.tvNext.setText((CharSequence)this.getString(R.string.finish));
        }
        if (this.currentTag > 0) {
            this.tvPrevious.setVisibility(0);
        }
        ImageTagModel imageTagModel = this.tagModels.get(this.currentTag);
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            this.tvPrevious.setVisibility(4);
            if (imageTagModel.isMandatory()) {
                this.tvNext.setVisibility(4);
            } else {
                this.tvNext.setText((CharSequence)"Skip");
                this.tvNext.setVisibility(0);
            }
        }
        return imageTagModel;
    }

    public ImageTagModel getPreviousTag() {
        if (this.currentTag > 0) {
            --this.currentTag;
        }
        if (this.currentTag != this.tagModels.size() - 1) {
            this.tvNext.setText((CharSequence)this.getString(R.string.next));
        }
        if (this.currentTag == 0) {
            this.tvPrevious.setVisibility(8);
        }
        return this.tagModels.get(this.currentTag);
    }

    public void setTag(ImageTagModel imageTagModel, boolean rightToLeft) {
        this.tvTag.setText((CharSequence)(imageTagModel.isMandatory() ? "*" + imageTagModel.getTagName() : imageTagModel.getTagName()));
        if (rightToLeft) {
            AnimationUtils.translateOnXAxis((View)this.tvTag, 200, 0);
        } else {
            AnimationUtils.translateOnXAxis((View)this.tvTag, -200, 0);
        }
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            NeonImagesHandler.getSingletonInstance().setCurrentTag(this.tvTag.getText().toString().trim());
        }
    }

    private void customize() {
        if (this.cameraParams != null && this.cameraParams.getTagEnabled()) {
            this.tagsLayout.setVisibility(0);
            this.tagModels = this.cameraParams.getImageTagsModel();
            this.initialiazeCurrentTag();
            ImageTagModel singleTagModel = this.tagModels.get(this.currentTag);
            if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
                if (singleTagModel.isMandatory()) {
                    this.tvNext.setVisibility(4);
                } else {
                    this.tvNext.setVisibility(0);
                    this.tvNext.setText((CharSequence)"Skip");
                }
                this.tvPrevious.setVisibility(4);
            } else {
                this.tvNext.setVisibility(0);
            }
            this.setTag(singleTagModel, true);
        } else {
            this.tagsLayout.setVisibility(8);
            this.findViewById(R.id.rlTags).setVisibility(8);
        }
        if (this.cameraParams != null) {
            this.buttonGallery.setVisibility(this.cameraParams.cameraToGallerySwitchEnabled() ? 0 : 4);
        }
    }

    private void initialiazeCurrentTag() {
        for (int i = 0; i < NeonImagesHandler.getSingletonInstance().getGenericParam().getImageTagsModel().size(); ++i) {
            if (!this.tagModels.get(i).isMandatory() || NeonImagesHandler.getSingletonInstance().checkImagesAvailableForTag(this.tagModels.get(i))) continue;
            this.currentTag = i;
            break;
        }
        if (this.currentTag == this.tagModels.size() - 1) {
            this.tvNext.setVisibility(0);
            this.tvNext.setText((CharSequence)this.getString(R.string.finish));
        }
        if (this.currentTag > 0) {
            this.tvPrevious.setVisibility(0);
        }
    }

    public void onBackPressed() {
        if (NeonImagesHandler.getSingletonInstance().isNeutralEnabled()) {
            super.onBackPressed();
        } else if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null) {
            NeonImagesHandler.getSingletonInstance().showBackOperationAlertIfNeededLive((Activity)this);
        } else {
            NeonImagesHandler.getSingletonInstance().showBackOperationAlertIfNeeded((Activity)this);
        }
    }

    @Override
    public void onPictureTaken(String filePath) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(filePath);
        fileInfo.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        fileInfo.setSource(FileInfo.SOURCE.PHONE_CAMERA);
        if (this.cameraParams.getTagEnabled()) {
            fileInfo.setFileTag(this.tagModels.get(this.currentTag));
        }
        if (this.binder.imageHolderView.getVisibility() != 0) {
            this.binder.imageHolderView.setVisibility(0);
        }
        boolean locationRestriction = this.cameraParams == null || this.cameraParams.getCustomParameters() == null || this.cameraParams.getCustomParameters().getLocationRestrictive();
        boolean isUpdated = true;
        if (locationRestriction) {
            isUpdated = this.updateExifInfo(fileInfo);
        }
        if (isUpdated) {
            NeonImagesHandler.getSingletonInstance().putInImageCollection(fileInfo, (Context)this);
            if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() == null) {
                ImageTagModel imageTagModel;
                if (NeonImagesHandler.getSingletonInstance().getCameraParam().getCameraViewType() == CameraType.gallery_preview_camera) {
                    ImageView image = new ImageView((Context)this);
                    Bitmap thumbnail = ThumbnailUtils.extractThumbnail((Bitmap)BitmapFactory.decodeFile((String)filePath), (int)200, (int)200);
                    image.setImageBitmap(thumbnail);
                    this.binder.imageHolderView.addView((View)image);
                }
                if (this.cameraParams.getTagEnabled() && (imageTagModel = this.tagModels.get(this.currentTag)).getNumberOfPhotos() > 0 && NeonImagesHandler.getSingletonInstance().getNumberOfPhotosCollected(imageTagModel) >= imageTagModel.getNumberOfPhotos()) {
                    this.onClick((View)this.binder.tvSkip);
                }
            }
        } else {
            Toast.makeText((Context)this, (CharSequence)"Unable to find location, Please try again later.", (int)0).show();
        }
    }

    @Override
    public void getLocation(Location location) {
        this.location = location;
    }

    @Override
    public void getAddress(String locationAddress) {
    }

    @Override
    public void getPermissionStatus(Boolean locationPermission) {
        boolean locationPermission1 = locationPermission;
        FindLocations.getInstance().init((Activity)this);
    }

    @Override
    public boolean updateExifInfo(FileInfo fileInfo) {
        try {
            if (this.location == null) {
                return false;
            }
            File file = new File(fileInfo.getFilePath());
            if (!file.exists()) {
                Toast.makeText((Context)this, (CharSequence)(NeonImagesHandler.getSingletonInstance().getCurrentTag() + " File does not exist"), (int)0).show();
                return false;
            }
            ExifInterfaceHandling exifInterfaceHandling = new ExifInterfaceHandling(file);
            exifInterfaceHandling.setLocation(this.location);
            if (String.valueOf(this.location.getLatitude()).equals(exifInterfaceHandling.getAttribute("GPSLatitudeRef"))) {
                return true;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void onNextTag() {
        ImageTagModel imageTagModel;
        if (NeonImagesHandler.getSingletonInstance().getLivePhotosListener() != null && this.cameraParams.getTagEnabled() && (imageTagModel = this.tagModels.get(this.currentTag)).getNumberOfPhotos() > 0 && NeonImagesHandler.getSingletonInstance().getNumberOfPhotosCollected(imageTagModel) >= imageTagModel.getNumberOfPhotos()) {
            this.onClick((View)this.binder.tvSkip);
        }
    }
}

