/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.scanlibrary.R;
import java.util.ArrayList;

public class FlashModeRecyclerHorizontalAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private static final String TAG = "FlashModeRecycler";
    private Context mContext;
    private ArrayList<String> flashList;
    private OnItemClickListener mItemClickListener;

    public FlashModeRecyclerHorizontalAdapter(Context context, ArrayList<String> imageList) {
        this.flashList = imageList == null ? new ArrayList() : imageList;
        this.mContext = context;
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.flash_layout_row, null);
        return new ViewHolder(view);
    }

    public ArrayList<String> getItems() {
        return this.flashList;
    }

    public void onBindViewHolder(ViewHolder holder, int position) {
        String name = this.flashList.get(position);
        Log.d((String)TAG, (String)("onBindViewHolder: " + name));
        holder.text.setVisibility(8);
        if ("off".equals(name)) {
            holder.icon.setImageResource(R.drawable.ic_flash_off);
        } else if ("on".equals(name)) {
            holder.icon.setImageResource(R.drawable.ic_flash_on);
        } else if ("auto".equals(name)) {
            holder.icon.setImageResource(R.drawable.ic_flash_auto);
        } else if ("red-eye".equals(name)) {
            holder.icon.setImageResource(R.drawable.ic_flash_red_eye);
        } else if ("torch".equals(name)) {
            holder.icon.setImageResource(R.drawable.ic_flash_torch);
        } else {
            holder.text.setText((CharSequence)name);
            holder.text.setVisibility(0);
        }
    }

    public int getItemCount() {
        return this.flashList.size();
    }

    public void setOnItemClickListener(OnItemClickListener mItemClickListener) {
        this.mItemClickListener = mItemClickListener;
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        TextView text;
        ImageView icon;

        public ViewHolder(View itemView) {
            super(itemView);
            this.text = (TextView)itemView.findViewById(R.id.colorValue);
            this.icon = (ImageView)itemView.findViewById(R.id.flash_icon);
            itemView.setOnClickListener((View.OnClickListener)this);
        }

        public void onClick(View v) {
            if (FlashModeRecyclerHorizontalAdapter.this.mItemClickListener != null) {
                FlashModeRecyclerHorizontalAdapter.this.mItemClickListener.onItemClick(v, this.getPosition());
            }
        }
    }
}

