package com.intsig.csopen.util;

import android.os.Build;

public class Log {
	
	private static final String TAG = "CsOpen.SDK.Log";
	
	public static final int LEVEL_VERBOSE = 0;
	public static final int LEVEL_DEBUG = 1;
	public static final int LEVEL_INFO = 2;
	public static final int LEVEL_WARNING = 3;
	public static final int LEVEL_ERROR = 4;
	public static final int LEVEL_NONE = 5;
	private static int sLevel = 5;

//	private static PrintStream sOutputStream;
//	private static byte[] X = null;
	
	private static final String SYSTEM_INFO;
	
	static {
		StringBuilder localStringBuilder;
		(localStringBuilder = new StringBuilder()).append("VERSION.RELEASE:["
				+ Build.VERSION.RELEASE);
		localStringBuilder.append("] VERSION.CODENAME:["
				+ Build.VERSION.CODENAME);
		localStringBuilder.append("] VERSION.INCREMENTAL:["
				+ Build.VERSION.INCREMENTAL);
		localStringBuilder.append("] BOARD:[" + Build.BOARD);
		localStringBuilder.append("] DEVICE:[" + Build.DEVICE);
		localStringBuilder.append("] DISPLAY:[" + Build.DISPLAY);
		localStringBuilder.append("] FINGERPRINT:[" + Build.FINGERPRINT);
		localStringBuilder.append("] HOST:[" + Build.HOST);
		localStringBuilder.append("] MANUFACTURER:[" + Build.MANUFACTURER);
		localStringBuilder.append("] MODEL:[" + Build.MODEL);
		localStringBuilder.append("] PRODUCT:[" + Build.PRODUCT);
		localStringBuilder.append("] TAGS:[" + Build.TAGS);
		localStringBuilder.append("] TYPE:[" + Build.TYPE);
		localStringBuilder.append("] USER:[" + Build.USER + "]");
		SYSTEM_INFO = localStringBuilder.toString();
	}

//	public static void setOutputPath(String fileName, String paramString2,
//			String paramString3, int paramInt) {
//		if (TextUtils.isEmpty(fileName) 
//				|| TextUtils.isEmpty(paramString3)){
//			return;
//		}
//		File file = new File(fileName);
//		if (!file.exists()){
//			return;
//		}
//		try {
//			FileInputStream fis = new FileInputStream(fileName);
//			FileOutputStream fos = new FileOutputStream(fileName, true);
//			setOutputStream(fis, fos, paramString2, paramString3, paramInt);
//			if (fis != null)
//				fis.close();
//			return;
//		} catch (Exception localException) {
//			localException.printStackTrace();
//		}
//	}
//
//	public static void setOutputStream(InputStream is, OutputStream os, String paramString1,
//			String paramString2, int paramInt) {
//		try {
//			sOutputStream = new PrintStream(new BufferedOutputStream(os));
//			long l1;
//			if (is != null) {
//				paramString1 = Util.nullAsNil(
//								(is = new BufferedReader(
//										new InputStreamReader(is)))
//										.readLine()).substring(2).trim();
//				paramString2 = Util.nullAsNil(is.readLine())
//						.substring(2).trim();
//				l1 = Util.getLong(Util.nullAsNil(is.readLine())
//						.trim().substring(2), 0L);
//				d("MicroMsg.SDK.Log",
//						"using provided info, type=%s, user=%s, createtime=%d",
//						new Object[] { paramString1, paramString2,
//								Long.valueOf(l1) });
//			} else {
//				l1 = System.currentTimeMillis();
//				LogHelper.initLogHeader(sOutputStream, paramString1, paramString2, l1,
//						paramInt);
//			}
//			long l2 = l1;
//			is = paramString2;
//			(os = new StringBuffer()).append(is);
//			os.append(l2);
//			os.append("dfdhgc");
//			X = MD5.getMessageDigest(os.toString().getBytes())
//					.substring(7, 21).getBytes();
//			android.util.Log.d("MicroMsg.SDK.Log", "set up out put stream");
//			return;
//		} catch (Exception localException) {
//			localException.printStackTrace();
//		}
//	}
//
//	public static void reset() {
//		sOutputStream = null;
//		X = null;
//	}

	/**
	 * set SDK log level
	 * @param level values in {{@link #LEVEL_ERROR}, {@link #LEVEL_DEBUG}, 
	 * {@link #LEVEL_INFO}, {@link #LEVEL_NONE}, {@link #LEVEL_VERBOSE}, {@link #LEVEL_WARNING}}
	 */
	public static void setLevel(int level) {
		if(level >= 0 && level <= 5){
			sLevel = level;
			android.util.Log.w(TAG, "new log level: " + level);
		}else{
			throw new IllegalArgumentException("illegal parameter level, values should be in range [0, 5]");
		}
	}

	public static int getLevel() {
		return sLevel;
	}
	
	public static void e(String tag, String msg) {
		e(tag, msg, null);
	}

	public static void w(String tag, String msg) {
		w(tag, msg, null);
	}

	public static void i(String tag, String msg) {
		i(tag, msg, null);
	}

	public static void d(String tag, String msg) {
		d(tag, msg, null);
	}

	public static void v(String tag, String msg) {
		v(tag, msg, null);
	}

	public static void e(String tag, String msg, Object[] param) {
		if (sLevel > LEVEL_ERROR){
			return;
		}
		msg = (param == null) ? msg : String.format(msg, param);
		android.util.Log.e(tag, msg);
	}

	public static void w(String tag, String msg, Object[] param) {
		if (sLevel > LEVEL_WARNING){
			return;
		}
		msg = (param == null) ? msg : String.format(msg, param);
		android.util.Log.w(tag, msg);
	}

	public static void i(String tag, String msg, Object[] param) {
		if (sLevel > LEVEL_INFO)
			return;
		msg = (param == null) ? msg : String.format(msg, param);
		android.util.Log.i(tag, msg);
	}

	public static void d(String tag, String msg, Object[] param) {
		if (sLevel > LEVEL_DEBUG)
			return;
		msg = (param == null) ? msg : String.format(msg, param);
		android.util.Log.d(tag, msg);
	}

	public static void v(String tag, String msg, Object[] param) {
		if (sLevel > LEVEL_VERBOSE)
			return;
		msg = (param == null) ? msg : String.format(msg, param);
		android.util.Log.v(tag, msg);
	}

	public static String getSysInfo() {
		return SYSTEM_INFO;
	}


}