/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.view;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;

public class ScanRecordControl {
    private static final String TAG = "ScanRecordControl";
    private static final String SET_CRASHED_IMAGE_FOUND = "setcrashedimagefound";
    private static final String SET_CRASHED_IMAGE_PATH = "setcrashedimagepath";
    private static final String SET_TRIMMED_IMAGE_BORDER = "settrimmedimageborder";
    private static final String SET_IMAGE_BRIGHT_DETAIL_CONTRAST = "setimagebrightdetailcontrast";
    private static final String SET_IMAGE_SCAN_STEP = "setimagescanstep";
    private static final String SET_IMAGE_ENHANCE_MODE = "setimageenhancemode";
    private static final String SET_SCAN_FINISH_NORMAL = "setscanfinishnormal";
    public static final String DECODE_IMAGE_BYTE_STEP = "decode_image_byte";
    public static final String DETECT_IMAGE_STEP = "detect_image";
    public static final String DETECT_COLOR_IMAGE_MODE_STEP = "detect_color_image_mode_step";
    public static final String DETECT_IMAGE_ANGLE_STEP = "detect_image_angle";
    public static final String DECODE_IMAGE_STEP = "decode_image";
    public static final String TRIM_IMAGE_STEP = "trim_image";
    public static final String ENHANCE_IMAGE_STEP = "enhance_image";
    public static final String ROTATE_SCALE_IMAGE_STEP = "rotate_scale_image";
    public static final String ADJUST_IMAGE_STEP = "adjust_image";
    public static final String ENCODE_IMAGE_STEP = "encode_image";
    public static final String INIT_CONTEXT_STEP = "init_context";
    public static final String DESTROY_CONTEXT_STEP = "destroy_context";
    public static final String RELEASE_IMAGE_STEP = "release_image";
    public static final String DEWARP_IMAGE_PLANE = "dewarp_image_plane";
    public static final String DECODE_THUMB_STEP = "decode_thumb";
    public static final String TRIM_THUMB_STEP = "trim_thumb";
    public static final String ENHANCE_THUMB_STEP = "enhance_thumb";
    public static final String ROTATE_SCALE_THUMB_STEP = "rotate_scale_thumb";
    public static final String ADJUST_THUMB_STEP = "adjust_thumb";
    public static final String ENCODE_THUMB_STEP = "encode_thumb";
    private static ScanRecordControl mScanRecordControl;
    private SharedPreferences mPreferences;

    private ScanRecordControl(Context context) {
        this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    public static ScanRecordControl getInstance(Context context) {
        if (mScanRecordControl == null) {
            mScanRecordControl = new ScanRecordControl(context);
        }
        return mScanRecordControl;
    }

    public boolean isCrashedImageFound() {
        boolean result = false;
        return result;
    }

    public void setCrashedImageFound(boolean found) {
        if (this.mPreferences != null) {
            this.mPreferences.edit().putBoolean(SET_CRASHED_IMAGE_FOUND, found).commit();
        }
        Log.d((String)TAG, (String)("setCrashedImageFound found=" + found));
    }

    public void setImageRawPath(String path) {
        if (this.mPreferences != null && !this.isCrashedImageFound()) {
            this.mPreferences.edit().putString(SET_CRASHED_IMAGE_PATH, path).commit();
        }
        Log.d((String)TAG, (String)("setImageRawPath path=" + path + " is crashed " + this.isCrashedImageFound() + " mPreferences != null=" + (this.mPreferences != null)));
    }

    public String getImageRawPath() {
        String path = "";
        if (this.mPreferences != null) {
            path = this.mPreferences.getString(SET_CRASHED_IMAGE_PATH, "");
        }
        Log.d((String)TAG, (String)("getImageRawPath path=" + path + " mPreferences != null=" + (this.mPreferences != null)));
        return path;
    }

    public void setTrimmedImageBorder(String border) {
        if (this.mPreferences != null && !this.isCrashedImageFound()) {
            this.mPreferences.edit().putString(SET_TRIMMED_IMAGE_BORDER, border).commit();
        }
        Log.d((String)TAG, (String)("setTrimmedImageBorder border=" + border));
    }

    public void setTrimmedImageBorder(int[] rawBounds, int[] requestBounds) {
        StringBuilder stringBuilder = new StringBuilder();
        if (rawBounds != null) {
            for (int i : rawBounds) {
                stringBuilder.append(i).append(",");
            }
        }
        if (requestBounds != null) {
            for (int i : requestBounds) {
                stringBuilder.append(i).append(",");
            }
        }
        this.setTrimmedImageBorder(stringBuilder.toString());
    }

    public String getTrimmedImageBorder() {
        String border = "";
        if (this.mPreferences != null) {
            border = this.mPreferences.getString(SET_TRIMMED_IMAGE_BORDER, "");
        }
        Log.d((String)TAG, (String)("getTrimmedImageBorder border=" + border));
        return border;
    }

    public void setImageBrightDetailContrastIndexs(int bright, int detail, int contrast) {
        if (this.mPreferences != null && !this.isCrashedImageFound()) {
            this.mPreferences.edit().putString(SET_IMAGE_BRIGHT_DETAIL_CONTRAST, bright + "," + detail + "," + contrast).commit();
        }
        Log.d((String)TAG, (String)("setImageBrightDetailContrastIndexs index=" + bright + "," + detail + "," + contrast));
    }

    public String getImageBrightDetailContrastIndexs() {
        String index = "";
        if (this.mPreferences != null) {
            index = this.mPreferences.getString(SET_IMAGE_BRIGHT_DETAIL_CONTRAST, "");
        }
        Log.d((String)TAG, (String)("getImageBrightDetailContrastIndexs index=" + index));
        return index;
    }

    public void setCurrentScanStep(String step) {
        if (this.mPreferences != null && !this.isCrashedImageFound()) {
            this.mPreferences.edit().putString(SET_IMAGE_SCAN_STEP, step).commit();
        }
        Log.d((String)TAG, (String)("setCurrentScanStep step=" + step));
    }

    public String getCurrentScanStep() {
        String step = "";
        if (this.mPreferences != null) {
            step = this.mPreferences.getString(SET_IMAGE_SCAN_STEP, "");
        }
        Log.d((String)TAG, (String)("getCurrentScanStep step=" + step));
        return step;
    }

    public void setImageEnhanceMode(int mode) {
        if (this.mPreferences != null) {
            this.mPreferences.edit().putInt(SET_IMAGE_ENHANCE_MODE, mode).commit();
        }
        Log.d((String)TAG, (String)("setImageEnhanceMode mode=" + mode));
    }

    public int getImageEnhanceMode() {
        int mode = -1;
        if (this.mPreferences != null) {
            mode = this.mPreferences.getInt(SET_IMAGE_ENHANCE_MODE, -1);
        }
        Log.d((String)TAG, (String)("getImageEnhanceMode mode=" + mode));
        return mode;
    }

    public void uploadCrashedImage2Server() {
    }

    public void setScannFinishNormal(boolean normal) {
        if (this.mPreferences != null) {
            this.mPreferences.edit().putBoolean(SET_SCAN_FINISH_NORMAL, normal).commit();
        }
        Log.d((String)TAG, (String)("setScannFinishNormal normal=" + normal));
    }

    public boolean isScannFinishNormal() {
        boolean result = true;
        if (this.mPreferences != null) {
            result = this.mPreferences.getBoolean(SET_SCAN_FINISH_NORMAL, true);
        }
        Log.d((String)TAG, (String)("isScannFinishNormal result=" + result));
        return result;
    }
}

