/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.view;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.gaadi.neon.activity.ImageScannerActivity;
import com.gaadi.neon.view.ScanRecordControl;
import com.intsig.scanner.ScannerEngine;
import com.intsig.scanner.ScannerSDK;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class ISImageEnhanceHandler {
    private static final String TAG = "ISImageEnhanceHandler";
    private Context mContext;
    private int mEngineContext;
    private ScanRecordControl mScanRecordControl;
    private String mRawJpgPath;
    private String mThumbJpgPath;
    private int mThumbStruct;
    private ArrayList<IsImageHandleFinishListener> mListeners;
    private boolean mIsThumbTrimed = false;
    private boolean mIsThumbTriming = false;
    private ImageStoreRequest mCurRequest;
    private ImageStoreRequest mFinishRequest;
    private ImageStoreRequest mRequest;
    private static ISImageEnhanceHandler sInstance;
    ScannerSDK mScannerSDK;

    public static ISImageEnhanceHandler newInstance(Context context, Handler handler, ScannerSDK mScannerSDK) {
        sInstance = new ISImageEnhanceHandler(context, handler, mScannerSDK);
        return sInstance;
    }

    public static void releaseInstace() {
        sInstance = null;
    }

    private ISImageEnhanceHandler(Context context, Handler handler, ScannerSDK mScannerSDK) {
        this.mContext = context;
        this.mEngineContext = 0;
        this.mScannerSDK = mScannerSDK;
        this.mListeners = new ArrayList();
        this.mScanRecordControl = ScanRecordControl.getInstance(context);
    }

    public void setImagePath(String rawPath, String thumbPath) {
        this.mRawJpgPath = rawPath;
        this.mThumbJpgPath = thumbPath;
        this.mScanRecordControl.setImageRawPath(rawPath);
    }

    public void setEngineContext(int enginecontext) {
        this.mEngineContext = enginecontext;
        Log.d((String)TAG, (String)("setEngineContext = " + enginecontext));
    }

    private int decodeImageS(String imgPath) {
        Log.d((String)TAG, (String)("decodeImageS beign: " + imgPath));
        long start = System.currentTimeMillis();
        int imageStruct = ScannerEngine.decodeImageS((String)imgPath);
        start = System.currentTimeMillis() - start;
        Log.d((String)TAG, (String)("decodeImageS consume " + start));
        Log.d((String)TAG, (String)("decodeImageS finished, memory address:" + imageStruct));
        if (!ISImageEnhanceHandler.isLegalImageStruct(imageStruct)) {
            Log.d((String)TAG, (String)("decodeImageS fail: " + imageStruct + ", file exist = " + new File(imgPath).exists()));
        }
        return imageStruct;
    }

    public static boolean isLegalImageStruct(int imageStruct) {
        return imageStruct > 0;
    }

    public void trimThumb(int[] bounds) {
        Log.d((String)TAG, (String)"trimThumb beign");
        this.mIsThumbTriming = true;
        long start = System.currentTimeMillis();
        if (!ISImageEnhanceHandler.isLegalImageStruct(this.mThumbStruct)) {
            this.mThumbStruct = this.decodeImageS(this.mThumbJpgPath);
        }
        if (ISImageEnhanceHandler.isLegalImageStruct(this.mThumbStruct)) {
            this.mScanRecordControl.setCurrentScanStep("trim_thumb");
            this.mScanRecordControl.setTrimmedImageBorder(null, bounds);
            this.mScanRecordControl.setImageRawPath(this.mThumbJpgPath);
            try {
                boolean result = this.mScannerSDK.trimImage(this.mEngineContext, this.mThumbStruct, bounds, ImageScannerActivity.TRIM_IMAGE_MAXSIDE);
                Log.d((String)TAG, (String)("trimThumb result " + result + ", " + Arrays.toString(bounds)));
            }
            catch (RuntimeException e) {
                Log.d((String)TAG, (String)e.getMessage());
            }
            this.mIsThumbTrimed = true;
        } else {
            Log.d((String)TAG, (String)("trimThumb decode thumb struct fail " + this.mThumbStruct));
        }
        start = System.currentTimeMillis() - start;
        this.mIsThumbTriming = false;
        Log.d((String)TAG, (String)("trimThumb consume " + start));
    }

    public class ImageStoreRequest {
        public int[] bounds;
        public int rotation;
        public int enhanceMode;
        public int brightness;
        public int detail;
        public int contrast;

        public boolean equals(Object o) {
            boolean res = false;
            if (o instanceof ImageStoreRequest) {
                ImageStoreRequest other = (ImageStoreRequest)o;
                if (this.bounds != null && other.bounds != null) {
                    for (int i = 0; i < this.bounds.length; ++i) {
                        if (this.bounds[i] == other.bounds[i]) continue;
                        return res;
                    }
                } else if (this.bounds != null || other.bounds != null) {
                    return res;
                }
                res = this.rotation == other.rotation && this.enhanceMode == other.enhanceMode && this.brightness == other.brightness && this.detail == other.detail && this.contrast == other.contrast;
            }
            return res;
        }

        public String toString() {
            return this.bounds + ", rotation = " + this.rotation + ", mode = " + this.enhanceMode + ", brightness = " + this.brightness + ", detail = " + this.detail + ", contrast = " + this.contrast;
        }
    }

    public static interface IsImageHandleFinishListener {
        public void onImageHandleFinish(long var1);
    }
}

