/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.animation.AnimatorInflater;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import com.gaadi.neon.view.HorizontalListView;
import com.gaadi.neon.view.ISImageEnhanceHandler;
import com.gaadi.neon.view.ScanRecordControl;
import com.intsig.scanner.CommonUtil;
import com.intsig.scanner.ScannerEngine;
import com.intsig.scanner.ScannerSDK;
import com.intsig.view.DocumentUtil;
import com.intsig.view.ImageEditView;
import com.intsig.view.MagnifierView;
import com.intsig.view.RotateBitmap;
import com.intsig.view.Utils;
import com.scanlibrary.R;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ImageScannerActivity
extends Activity
implements AdapterView.OnItemSelectedListener,
View.OnClickListener {
    public static final int IMPORT_FROM_CAMERA = 0;
    public static final int IMPORT_FROM_GALLERY = 1;
    public static final int IMPORT_FROM_FILEDIR = 2;
    public static final int ENHANCE_AUTO_MODE = 0;
    public static final int ENHANCE_RAW_MODE = 1;
    public static final int ENHANCE_LINER_FUTURE_MODE = 2;
    public static final int ENHANCE_MAGIC_FUTURE_MODE = 3;
    public static final int ENHANCE_GRAY_FUTURE_MODE = 4;
    public static final int ENHANCE_BLACKWHITE_FUTURE_MODE = 5;
    protected static final int PROGRESS_ENHANCE_INCREASE = 1006;
    protected static final int PROGRESS_TRIM_INCREASE = 1005;
    private static final String TAG = ImageScannerActivity.class.getSimpleName();
    private static final int REQ_CODE_GALLERY_IMPORT = 0;
    private static final int MSG_ROTATE_IMAGE = 1014;
    private static final int MAX_COPY_TRY_TIME = 2;
    private static final int WIDTH = 100;
    private static final int HEIGHT = 100;
    public static int TRIM_IMAGE_MAXSIDE = 1600;
    public static String EXTRA_KEY_RESULT_ERROR_CODE = "EXTRA_KEY_RESULT_ERROR_CODE";
    public static String EXTRA_KEY_RESULT_ERROR_MSG = "EXTRA_KEY_RESULT_ERROR_MSG";
    public static String EXTRA_TRIM_IMAGE_MAXSIDE = "EXTRA_TRIM_IMAGE_MAXSIDE";
    public static String EXTRA_KEY_APP_KEY = "EXTRA_KEY_APP_KEY";
    public static String EXTRA_TRIM_NORMAL_COLOR = "EXTRA_TRIM_NORMAL_COLOR";
    public static String EXTRA_TRIM_ERROR_COLOR = "EXTRA_TRIM_ERROR_COLOR";
    public static String EXTRA_KEY_RESULT_DATA_PATH = "EXTRA_KEY_RESULT_DATA_PATH";
    public static String EXTRA_IMPORT_IMG_TYPE = "EXTRA_IMPORT_IMG_TYPE";
    public static String EXTRA_KEY_INPUTFILE_DATA_PATH = "EXTRA_KEY_INPUTFILE_DATA_PATH";
    public static String EXTRA_KEY_ENHANCE_MODE_INDEX = "EXTRA_KEY_ENHANCE_MODE_INDEX";
    public static String EXTRA_KEY_JUDGE_GRAYORCOLOR = "EXTRA_KEY_JUDGE_GRAYORCOLOR";
    public static int MIN_SIDE_LENGTH = 800;
    public static int MAX_DISPLAY_WIDTH = 1280;
    private static int TRIM_IMAGE_SAVESIDE = 60;
    private static int TRIM_IMAGE_SAVELOCALSIDE = 60;
    private static SimpleDateFormat sPdfTime = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private static String APPKEY = "b68116bfdbcac018b4852bf851-vagfvt";
    private static int importImgType = 0;
    private static int mNormalColor = -10512907;
    private static int mErrorColor = -27392;
    private static double sTrimAnimThumbMaxSize;
    protected final int PROCESS_FINISH = 1008;
    protected final int PROGRESS_STEP_CHANGED = 1007;
    private final int REQUEST_CAPTURE_PIC = 100;
    RelativeLayout mTakePhotoLayout;
    String outPutFilePath = null;
    String inPutFilePath = null;
    int mEnhanceModeIndexExtra = -1;
    MagnifierView mMagnifierView;
    RelativeLayout ocr_scan_rel;
    ImageView ocr_scan_line;
    LinearLayout bt_toolbar_line;
    LinearLayout bt_process_line;
    TextView bt_process_comment_id;
    ProgressBar progress_horizontal;
    View mEnhanceModeBar;
    String mOriTrimImageEnchancePath;
    boolean boolClick = true;
    boolean isFullRegion = false;
    RotateBitmap bitmapRotate = null;
    Bitmap oriBitmap = null;
    TextView bt_addButton;
    TextView bt_add_from_camera;
    TextView gray_comment_id;
    TextView gray_comment_idCrop;
    Bitmap bmmIVEnhance;
    ISImageEnhanceHandler mRawImageHandler;
    ScanRecordControl mScanRecordControl;
    String sPreStoreThumbPath = null;
    boolean mIsTrim = false;
    ImageProcessListener mImageProcessListener;
    boolean isSmallScreen = true;
    boolean mIs7Tablet = false;
    private ImageView mIVEnhance;
    private ImageEditView mIvEditView;
    private View mTrimView;
    private View mEnhanceView;
    private LinearLayout mBtnNext;
    private String mRootPath;
    private String mOriTrimImagePath;
    private String mOriTrimImagePathResult;
    private Spinner mSpinner;
    private ScannerSDK mScannerSDK;
    private float mScale = 1.0f;
    private Bitmap mOriginalEnhanceBitmap;
    private Bitmap mEnhanceBitmap;
    private String mCurrentInputImagePath;
    private int[] mLastDetectBorder;
    private int mEngineContext;
    private int mCurOrientation;
    private int mAutoMode;
    private boolean boolJudgeGrayOrColor = false;
    private String[] mModeNames = new String[]{"Auto", "Original", "Brighten", "Enhance and Sharpen", "Gray Mode", "Black and White"};
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what != 0) {
                Log.d((String)TAG, (String)("handleMessage: error msg.what != 0 for " + ImageScannerActivity.this.inPutFilePath));
                String loginfoString = CommonUtil.getPkgSigKeyLog((Context)ImageScannerActivity.this, (String)APPKEY);
                Log.e((String)"Init MSG:", (String)loginfoString);
                Toast.makeText((Context)ImageScannerActivity.this, (CharSequence)("Authorization failed-->" + msg.what + "\n" + loginfoString), (int)1).show();
                ImageScannerActivity.this.boolClick = false;
                Intent data = new Intent();
                data.putExtra(EXTRA_KEY_RESULT_ERROR_CODE, msg.what);
                data.putExtra(EXTRA_KEY_RESULT_ERROR_MSG, CommonUtil.commentMsg((int)msg.what));
                ImageScannerActivity.this.setResult(0, data);
                ImageScannerActivity.this.finish();
            } else if (importImgType == 0 || importImgType == 1 || importImgType == 2) {
                ImageScannerActivity.this.mOriTrimImagePath = ImageScannerActivity.this.inPutFilePath;
                File file = new File(ImageScannerActivity.this.mOriTrimImagePath);
                if (file.exists()) {
                    ImageScannerActivity.this.loadTrimImageFile(ImageScannerActivity.this.mOriTrimImagePath);
                } else {
                    Toast.makeText((Context)ImageScannerActivity.this, (CharSequence)"The path of the input cut edge graph is incorrect", (int)1).show();
                }
            }
            super.handleMessage(msg);
        }
    };
    private int[] mBitmapDetectBound;
    private int[] mBitmapDetectBoundLast;
    private float[] mViewTtrimBound;
    private int mEnhanceMode = 17;
    private ProgressDialog mProgressDialog;
    private double mTrimScale;
    private boolean mIsTextRotationValid;
    private boolean mIsNameCardMode;
    private int mRotation = 0;
    private int mEnRotation = 0;
    private int[] mCurrentThumbBounds;
    private int[] mCurrentFileBounds;
    private Bitmap mThumb;
    private Bitmap mEnhanceSource;
    private RotateBitmap mRotateBitmap;
    private Handler mHandlerAnim = new Handler(){

        public void dispatchMessage(Message msg) {
            switch (msg.what) {
                case 1007: {
                    ImageScannerActivity.this.mThumb = (Bitmap)msg.obj;
                    ImageScannerActivity.this.progress_horizontal.setProgress(0);
                    ImageScannerActivity.this.mRotateBitmap.setBitmap(ImageScannerActivity.this.mThumb);
                    ImageScannerActivity.this.mRotateBitmap.setRotation(ImageScannerActivity.this.mRotation);
                    ImageScannerActivity.this.mIvEditView.setImageRotateBitmapResetBase(ImageScannerActivity.this.mRotateBitmap, false);
                    break;
                }
                case 1005: {
                    ImageScannerActivity.this.mThumb = (Bitmap)msg.obj;
                    ImageScannerActivity.this.progress_horizontal.setProgress(msg.arg1);
                    if (msg.arg1 > 70) {
                        ImageScannerActivity.this.bt_process_comment_id.setText((CharSequence)ImageScannerActivity.this.getResources().getString(R.string.begin_enhance));
                    } else {
                        ImageScannerActivity.this.bt_process_comment_id.setText((CharSequence)ImageScannerActivity.this.getResources().getString(R.string.begin_trim));
                    }
                    ImageScannerActivity.this.mRotateBitmap.setBitmap(ImageScannerActivity.this.mThumb);
                    ImageScannerActivity.this.mRotateBitmap.setRotation(ImageScannerActivity.this.mRotation);
                    ImageScannerActivity.this.mIvEditView.setImageRotateBitmapResetBase(ImageScannerActivity.this.mRotateBitmap, false);
                    break;
                }
                case 1006: {
                    break;
                }
            }
            super.dispatchMessage(msg);
        }
    };
    private ExecutorService mFixedThreadPool = null;
    private Bitmap[] mEnhanceModeBitmap = new Bitmap[7];
    private boolean mFinishPrepareEnhanceMenuThumb = true;
    private int mEnhanceModeIndex = 0;

    private static int[] getImageSizeBound(String pathName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
        int[] wh = null;
        if (options.mCancel || options.outWidth == -1 || options.outHeight == -1) {
            Log.d((String)TAG, (String)("getImageBound error " + pathName));
        } else {
            wh = new int[]{options.outWidth, options.outHeight};
        }
        return wh;
    }

    private static float[] getScanBoundF(int[] size, int[] borders) {
        float[] bound = null;
        if (size != null) {
            if (borders == null) {
                Log.d((String)TAG, (String)"did not found bound");
                bound = new float[]{0.0f, 0.0f, size[0], 0.0f, size[0], size[1], 0.0f, size[1]};
            } else {
                bound = new float[8];
                for (int j = 0; j < bound.length; ++j) {
                    bound[j] = borders[j];
                }
                for (int i = 0; i < 4; ++i) {
                    if (bound[i * 2] < 0.0f) {
                        bound[i * 2] = 0.0f;
                    }
                    if (bound[i * 2 + 1] < 0.0f) {
                        bound[i * 2 + 1] = 0.0f;
                    }
                    if (bound[i * 2] > (float)size[0]) {
                        bound[i * 2] = size[0];
                    }
                    if (!(bound[i * 2 + 1] > (float)size[1])) continue;
                    bound[i * 2 + 1] = size[1];
                }
            }
        }
        return bound;
    }

    public static void recycleImageView(View view) {
        Bitmap bmp;
        Drawable drawable2;
        if (view == null) {
            return;
        }
        if (view instanceof ImageView && (drawable2 = ((ImageView)view).getDrawable()) instanceof BitmapDrawable && (bmp = ((BitmapDrawable)drawable2).getBitmap()) != null && !bmp.isRecycled()) {
            ((ImageView)view).setImageBitmap(null);
            bmp.recycle();
            Object var2_2 = null;
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.ac_scanner);
        Intent intent = this.getIntent();
        String appkeyString = intent.getStringExtra(EXTRA_KEY_APP_KEY);
        if (!TextUtils.isEmpty((CharSequence)appkeyString)) {
            APPKEY = appkeyString;
        }
        mNormalColor = intent.getIntExtra(EXTRA_TRIM_NORMAL_COLOR, mNormalColor);
        mErrorColor = intent.getIntExtra(EXTRA_TRIM_ERROR_COLOR, mErrorColor);
        importImgType = intent.getIntExtra(EXTRA_IMPORT_IMG_TYPE, 0);
        this.outPutFilePath = intent.getStringExtra(EXTRA_KEY_RESULT_DATA_PATH);
        this.inPutFilePath = intent.getStringExtra(EXTRA_KEY_INPUTFILE_DATA_PATH);
        TRIM_IMAGE_MAXSIDE = intent.getIntExtra(EXTRA_TRIM_IMAGE_MAXSIDE, TRIM_IMAGE_MAXSIDE);
        this.boolJudgeGrayOrColor = intent.getBooleanExtra(EXTRA_KEY_JUDGE_GRAYORCOLOR, false);
        this.mEnhanceModeIndexExtra = intent.getIntExtra(EXTRA_KEY_ENHANCE_MODE_INDEX, -1);
        this.mRootPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        this.mRootPath = this.mRootPath + File.separator + "intsig" + File.separator + "demo_imagescanner";
        this.mOriTrimImagePath = this.mRootPath + File.separator + "oriTrim.jpg";
        this.mOriTrimImageEnchancePath = this.mRootPath + File.separator + "oriTrimWaitEn.jpg";
        this.mOriTrimImagePathResult = this.outPutFilePath;
        File dir = new File(this.mRootPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.mScannerSDK = new ScannerSDK();
        new Thread(new Runnable(){

            @Override
            public void run() {
                int code = ImageScannerActivity.this.mScannerSDK.initSDK((Context)ImageScannerActivity.this, APPKEY);
                ImageScannerActivity.this.mEngineContext = ImageScannerActivity.this.mScannerSDK.initThreadContext();
                ImageScannerActivity.this.mHandler.sendEmptyMessage(code);
                Log.d((String)TAG, (String)("code=" + code));
            }
        }).start();
        this.mBitmapDetectBound = new int[8];
        this.mViewTtrimBound = new float[8];
        this.mBitmapDetectBoundLast = new int[8];
        this.mCurOrientation = this.getResources().getConfiguration().orientation;
        this.mModeNames = this.getResources().getStringArray(R.array.arrays_enhance);
        this.initView();
    }

    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.cui_trim_rotate_right) {
            this.mRotation += 90;
            this.bitmapRotate = new RotateBitmap(this.oriBitmap, this.mRotation);
            this.mIvEditView.rotate(this.bitmapRotate, true);
            this.mBitmapDetectBound = this.mIvEditView.getRegion(false);
            for (int i = 0; i < this.mBitmapDetectBound.length; ++i) {
                this.mViewTtrimBound[i] = this.mBitmapDetectBound[i];
            }
        } else if (viewId == R.id.cui_trim_totate_left) {
            if (this.mRotation == 0) {
                this.mRotation = 360;
            }
            this.mRotation -= 90;
            this.bitmapRotate = new RotateBitmap(this.oriBitmap, this.mRotation);
            this.mIvEditView.rotate(this.bitmapRotate, true);
            this.mBitmapDetectBound = this.mIvEditView.getRegion(false);
            for (int i = 0; i < this.mBitmapDetectBound.length; ++i) {
                this.mViewTtrimBound[i] = this.mBitmapDetectBound[i];
            }
        } else if (viewId == R.id.cui_trim_selectall) {
            int i;
            if (!this.isFullRegion) {
                this.mBitmapDetectBoundLast = this.mIvEditView.getRegion(false);
                this.mIvEditView.setFullRegion(this.mScale, null);
                this.isFullRegion = true;
            } else {
                this.isFullRegion = false;
                if (this.mBitmapDetectBoundLast != null) {
                    for (i = 0; i < this.mBitmapDetectBoundLast.length; ++i) {
                        this.mViewTtrimBound[i] = this.mBitmapDetectBoundLast[i];
                    }
                    this.mIvEditView.setRegion(this.mViewTtrimBound, this.mScale);
                }
            }
            this.mBitmapDetectBound = this.mIvEditView.getRegion(false);
            for (i = 0; i < this.mBitmapDetectBound.length; ++i) {
                this.mViewTtrimBound[i] = this.mBitmapDetectBound[i];
            }
        } else if (viewId == R.id.cui_enhance_left_line) {
            this.mEnRotation += 90;
            if (this.mEnRotation > 360) {
                this.mEnRotation = 90;
            }
            Log.d((String)"mEnRotation", (String)(this.mEnRotation + ""));
            EnhanceTask enhanceTask = new EnhanceTask(this.getEnhanceMode(this.mEnhanceModeIndex));
            enhanceTask.execute(new Void[0]);
        } else if (viewId == R.id.bt_back_add_line) {
            this.setResult(0);
            this.finish();
        } else if (viewId == R.id.bt_enhance) {
            if (this.mIvEditView.isCanTrim(this.mEngineContext)) {
                this.startProcess();
            } else {
                Toast.makeText((Context)this, (int)R.string.bound_trim_error, (int)0).show();
            }
        } else if (viewId == R.id.bt_back_trim_line) {
            int[] imgBound = ImageScannerActivity.getImageSizeBound(this.mOriTrimImagePath);
            this.mIvEditView.setRawImageBounds(imgBound);
            this.mIvEditView.loadDrawBitmap(this.oriBitmap);
            this.mIvEditView.setRegion(this.mViewTtrimBound, this.mScale);
            this.mIvEditView.setRegionVisibility(true);
            this.bitmapRotate = new RotateBitmap(this.oriBitmap, this.mRotation);
            this.mIvEditView.rotate(this.bitmapRotate, true);
            this.enterTrimLayout();
            this.mMagnifierView.setVisibility(0);
        } else if (viewId == R.id.cui_enhance_save_line) {
            this.mEnhanceView.setVisibility(8);
            this.mTrimView.setVisibility(0);
            this.mMagnifierView.setVisibility(8);
            this.mMagnifierView.recycleAllBitmap();
            this.mMagnifierView.recycleBGBitmap();
            String outputPath = this.saveBitmap2File(this.mEnhanceBitmap);
            Intent data = new Intent();
            data.putExtra(EXTRA_KEY_RESULT_DATA_PATH, outputPath);
            this.setResult(-1, data);
            this.finish();
        }
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        Log.d((String)TAG, (String)("position=" + position));
        if (this.mOriginalEnhanceBitmap != null) {
            EnhanceTask enhanceTask = new EnhanceTask(this.getEnhanceMode(position));
            enhanceTask.execute(new Void[0]);
        } else {
            Log.d((String)TAG, (String)("mOriginalEnhanceBitmap=" + this.mOriginalEnhanceBitmap));
        }
    }

    public void onNothingSelected(AdapterView<?> parent) {
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            if (requestCode == 0) {
                this.mIvEditView.setRegionVisibility(false);
                this.progressExportImage(data);
            }
            if (requestCode == 100) {
                this.loadTrimImageFile(this.mOriTrimImagePath);
            }
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mEngineContext != 0 && this.mScannerSDK != null) {
            this.mScannerSDK.destroyContext(this.mEngineContext);
        }
        if (this.mOriginalEnhanceBitmap != null && !this.mOriginalEnhanceBitmap.isRecycled()) {
            this.mOriginalEnhanceBitmap.recycle();
            this.mOriginalEnhanceBitmap = null;
        }
        if (this.mEnhanceBitmap != null && !this.mEnhanceBitmap.isRecycled()) {
            this.mEnhanceBitmap.recycle();
            this.mEnhanceBitmap = null;
        }
        if (this.mThumb != null && !this.mThumb.isRecycled()) {
            this.mThumb.recycle();
            this.mThumb = null;
        }
        if (this.mEnhanceSource != null && !this.mEnhanceSource.isRecycled()) {
            this.mEnhanceSource.recycle();
            this.mEnhanceSource = null;
        }
        this.releaseModeThumb();
        if (this.mRawImageHandler != null) {
            this.mRawImageHandler.setEngineContext(0);
            this.mRawImageHandler = null;
            ISImageEnhanceHandler.releaseInstace();
        }
        if (this.mFixedThreadPool != null) {
            this.mFixedThreadPool.shutdown();
            this.mFixedThreadPool = null;
        }
        if (this.oriBitmap != null) {
            this.oriBitmap.recycle();
            this.oriBitmap = null;
        }
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
            this.mProgressDialog = null;
        }
        if (this.mRotateBitmap != null) {
            this.mRotateBitmap.recycle();
            this.mRotateBitmap = null;
        }
        if (this.bitmapRotate != null) {
            this.bitmapRotate.recycle();
            this.bitmapRotate = null;
        }
        if (this.mIvEditView != null) {
            this.mIvEditView = null;
        }
        if (this.mMagnifierView != null) {
            this.mMagnifierView.setVisibility(8);
            this.mMagnifierView.recycleAllBitmap();
            this.mMagnifierView = null;
        }
        if (this.mIVEnhance != null) {
            ImageScannerActivity.recycleImageView((View)this.mIVEnhance);
        }
        if (this.bmmIVEnhance != null && !this.bmmIVEnhance.isRecycled()) {
            this.bmmIVEnhance.recycle();
            this.bmmIVEnhance = null;
        }
        this.mHandler = null;
        this.bt_addButton = null;
        this.bt_add_from_camera = null;
        this.mBitmapDetectBound = null;
        this.mBitmapDetectBoundLast = null;
        this.mViewTtrimBound = null;
        this.mRawImageHandler = null;
        this.mScanRecordControl = null;
        this.mThumb = null;
        this.mEnhanceSource = null;
        this.mImageProcessListener = null;
        this.mIVEnhance = null;
        this.mTrimView = null;
        this.mEnhanceView = null;
        this.mBtnNext = null;
        this.mSpinner = null;
        System.gc();
    }

    private void initView() {
        this.mTrimView = this.findViewById(R.id.rl_trim);
        this.mEnhanceView = this.findViewById(R.id.ll_enhance);
        this.mIvEditView = (ImageEditView)this.findViewById(R.id.iv_trim);
        this.gray_comment_id = (TextView)this.findViewById(R.id.gray_comment_id);
        this.gray_comment_idCrop = (TextView)this.findViewById(R.id.gray_comment_id2);
        if (this.boolJudgeGrayOrColor) {
            this.gray_comment_id.setVisibility(0);
            this.gray_comment_idCrop.setVisibility(0);
        } else {
            this.gray_comment_id.setVisibility(8);
            this.gray_comment_idCrop.setVisibility(8);
        }
        this.mIvEditView.setDrapPoint(R.drawable.dragpoint);
        this.mIvEditView.setRegionVisibility(false);
        this.mIvEditView.setOnCornorChangeListener((ImageEditView.OnCornorChangeListener)new MyCornerChangeListener());
        this.mIvEditView.setOffset(this.getResources().getDimension(R.dimen.highlight_point_diameter));
        this.findViewById(R.id.take_photo_id).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.close_photo_id).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.bt_back_add_line).setOnClickListener((View.OnClickListener)this);
        this.mBtnNext = (LinearLayout)this.findViewById(R.id.bt_enhance);
        this.mBtnNext.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.cui_trim_rotate_right).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.cui_trim_totate_left).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.cui_trim_selectall).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.bt_back_trim_line).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.cui_enhance_save_line).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.cui_enhance_left_line).setOnClickListener((View.OnClickListener)this);
        this.bt_toolbar_line = (LinearLayout)this.findViewById(R.id.bt_toolbar_line);
        this.bt_process_line = (LinearLayout)this.findViewById(R.id.bt_process_line);
        this.progress_horizontal = (ProgressBar)this.findViewById(R.id.progress_horizontal);
        this.bt_process_comment_id = (TextView)this.findViewById(R.id.bt_process_comment_id);
        this.mIVEnhance = (ImageView)this.findViewById(R.id.iv_enhance);
        this.mEnhanceModeBar = this.findViewById(R.id.iv_enhance_groupbar);
        this.ocr_scan_rel = (RelativeLayout)this.findViewById(R.id.ocr_scan_rel);
        this.ocr_scan_line = (ImageView)this.findViewById(R.id.ocr_scan_line);
        this.mMagnifierView = (MagnifierView)this.findViewById(R.id.magnifier_view);
    }

    public void enterTrimLayout() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ImageScannerActivity.this.mEnhanceView.setVisibility(8);
                ImageScannerActivity.this.mTrimView.setVisibility(0);
            }
        });
    }

    public void enterEnhanceLayout() {
        if (this.mSpinner == null) {
            this.mSpinner = (Spinner)this.findViewById(R.id.sp_enhance_mode);
            ArrayAdapter adapter = ArrayAdapter.createFromResource((Context)this, (int)R.array.arrays_enhance, (int)R.layout.spinner_checked_text);
            adapter.setDropDownViewResource(0x1090009);
            this.mSpinner.setAdapter((SpinnerAdapter)adapter);
            this.mSpinner.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        }
        this.mEnhanceView.setVisibility(0);
        this.mTrimView.setVisibility(8);
        this.showIvEnhance(this.mOriginalEnhanceBitmap);
    }

    public void showIvEnhance(Bitmap morBitmap) {
        int h;
        Matrix matrix = new Matrix();
        float scaleFloat = 0.5f;
        int w = morBitmap.getWidth();
        float maxwh = w > (h = morBitmap.getHeight()) ? (float)w : (float)h;
        scaleFloat = 1200.0f / maxwh;
        Log.d((String)"test", (String)(maxwh + ",scaleFloat:" + scaleFloat));
        scaleFloat = scaleFloat > 1.0f ? 1.0f : scaleFloat;
        matrix.setScale(scaleFloat, scaleFloat);
        this.bmmIVEnhance = Bitmap.createBitmap((Bitmap)morBitmap, (int)0, (int)0, (int)morBitmap.getWidth(), (int)morBitmap.getHeight(), (Matrix)matrix, (boolean)true);
        Log.i((String)"bmmIVEnhance", (String)("Image size after compression" + this.bmmIVEnhance.getAllocationByteCount() / 1024 / 1024 + "MWidth is" + this.bmmIVEnhance.getWidth() + "Height is" + this.bmmIVEnhance.getHeight()));
        this.mIVEnhance.setImageBitmap(this.bmmIVEnhance);
    }

    public void changeBitmap(String mOriTrimImagePathResult) {
        File file = new File(mOriTrimImagePathResult);
        Log.i((String)"mOriTrimImagePathResult", (String)("The map's address\uff1a" + file.length()));
        if (file.exists()) {
            Bitmap trimBitmap = null;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)mOriTrimImagePathResult, (BitmapFactory.Options)options);
            int bitmapWidth = options.outWidth;
            int bitmapHeight = options.outHeight;
            Log.d((String)TAG, (String)("bitmapWidth=" + bitmapWidth + " bitmapHeight=" + bitmapHeight));
            if (bitmapWidth > 0 && bitmapHeight > 0) {
                int inSampleSize;
                float scale;
                int viewWidth = this.mIvEditView.getWidth();
                int viewHeight = this.mIvEditView.getHeight();
                float scaleX = 1.0f * (float)viewWidth / (float)bitmapWidth;
                float scaleY = 1.0f * (float)viewHeight / (float)bitmapHeight;
                Log.i((String)"testBitmap", (String)("viewWidth:" + viewWidth + "viewHeight" + viewHeight + "bitmapWidth" + bitmapWidth + "bitmapHeight\uff1a" + bitmapHeight));
                float f = scale = scaleX > scaleY ? scaleY : scaleX;
                if ((double)scale >= 0.5 && scale < 1.0f) {
                    scale = 0.5f;
                }
                if ((inSampleSize = (int)(1.0f / scale)) == 0) {
                    inSampleSize = 1;
                }
                options.inJustDecodeBounds = false;
                options.inSampleSize = inSampleSize;
                options.inPreferredConfig = Bitmap.Config.RGB_565;
                trimBitmap = BitmapFactory.decodeFile((String)mOriTrimImagePathResult, (BitmapFactory.Options)options);
                Log.i((String)"changeBitmap", (String)("The size of the compressed image" + trimBitmap.getAllocationByteCount() / 1024 / 1024 + "M width is" + trimBitmap.getWidth() + "Height is" + trimBitmap.getHeight() + "inSampleSize\uff1a" + inSampleSize));
            }
            if (this.mOriginalEnhanceBitmap != null && !this.mOriginalEnhanceBitmap.isRecycled()) {
                this.mOriginalEnhanceBitmap.recycle();
            }
            this.mOriginalEnhanceBitmap = trimBitmap;
        }
    }

    public Bitmap reviewPicRotate(Bitmap bitmap, int degree) {
        if (degree != 0) {
            Matrix m = new Matrix();
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            m.setRotate((float)degree);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)m, (boolean)true);
        }
        return bitmap;
    }

    private void startTtrim() {
        if (TextUtils.isEmpty((CharSequence)this.mOriTrimImagePath)) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCurrentInputImagePath)) {
            TrimTask trimTask = new TrimTask(this.mCurrentInputImagePath);
            trimTask.execute(new Void[0]);
        }
    }

    private void startProcess() {
        this.getTrimRegions();
        TrimAnimTask task = new TrimAnimTask();
        task.execute(new Void[0]);
    }

    public int getEnhanceMode(int which) {
        int mode = 17;
        switch (which) {
            case 1: {
                mode = 17;
                break;
            }
            case 0: {
                mode = -1;
                break;
            }
            case 2: {
                mode = 15;
                break;
            }
            case 3: {
                mode = 17;
                break;
            }
            case 4: {
                mode = 10;
                break;
            }
            case 5: {
                mode = 16;
                break;
            }
            default: {
                mode = -1;
            }
        }
        return mode;
    }

    public void onBackPressed() {
        super.onBackPressed();
    }

    private void showProgressDialog() {
        if (this.mProgressDialog == null) {
            this.mProgressDialog = new ProgressDialog((Context)this);
            this.mProgressDialog.setProgress(0);
            this.mProgressDialog.setMessage((CharSequence)this.getResources().getString(R.string.a_msg_working));
        }
        this.mProgressDialog.show();
    }

    public void dismissProgressDialog() {
        if (this.mProgressDialog != null) {
            this.mProgressDialog.dismiss();
        }
    }

    public String saveBitmap2File(Bitmap src) {
        Log.d((String)TAG, (String)("saveBitmap2File, outPutFilePath=" + this.outPutFilePath));
        return this.mOriTrimImagePathResult;
    }

    public boolean isValidImage(String path) {
        return !TextUtils.isEmpty((CharSequence)path) && (path.endsWith("png") || path.endsWith("jpg"));
    }

    private void progressExportImage(Intent data) {
        if (data != null) {
            Uri u = data.getData();
            Log.d((String)TAG, (String)("data.getData()=" + u));
            if (u != null) {
                String path = DocumentUtil.getInstance().getPath((Context)this, u);
                if (this.isValidImage(path)) {
                    this.loadTrimImageFile(path);
                } else {
                    Toast.makeText((Context)this, (int)R.string.a_msg_illegal, (int)0).show();
                }
            }
        } else {
            Log.d((String)TAG, (String)"data==null");
        }
    }

    private void loadTrimImageFile(final String imageFilePath) {
        Log.d((String)TAG, (String)"loadTrimImageFile: trim intit");
        if (TextUtils.isEmpty((CharSequence)imageFilePath)) {
            Log.d((String)TAG, (String)"imageFilePath is empty");
            return;
        }
        File file = new File(imageFilePath);
        if (!file.exists()) {
            Log.d((String)TAG, (String)"imageFilePath is not exist");
            return;
        }
        Log.d((String)TAG, (String)("loadTrimImageFile, imageFilePath=" + imageFilePath));
        this.enterTrimLayout();
        this.mIvEditView.post(new Runnable(){

            @Override
            public void run() {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
                int bitmapWidth = options.outWidth;
                int bitmapHeight = options.outHeight;
                Log.d((String)TAG, (String)("bitmapWidth=" + bitmapWidth + " bitmapHeight=" + bitmapHeight));
                if (bitmapWidth > 0 && bitmapHeight > 0) {
                    int viewWidth = ImageScannerActivity.this.mIvEditView.getWidth();
                    int viewHeight = ImageScannerActivity.this.mIvEditView.getHeight();
                    if (viewHeight == 0 || viewWidth == 0) {
                        viewWidth = 1080;
                        viewHeight = 1920;
                    }
                    if (viewWidth > 0 && viewHeight > 0) {
                        float scaleX = 1.0f * (float)viewWidth / (float)bitmapWidth;
                        float scaleY = 1.0f * (float)viewHeight / (float)bitmapHeight;
                        float scale = scaleX > scaleY ? scaleY : scaleX;
                        int inSampleSize = (int)(1.0f / scale);
                        if (inSampleSize == 0) {
                            inSampleSize = 1;
                        }
                        options.inSampleSize = inSampleSize;
                        Log.d((String)"inSampleSize:", (String)(inSampleSize + ""));
                        options.inJustDecodeBounds = false;
                        Bitmap testBitmap = BitmapFactory.decodeFile((String)imageFilePath, (BitmapFactory.Options)options);
                        ImageScannerActivity.this.mScale = 1.0f * (float)testBitmap.getWidth() / (float)bitmapWidth;
                        Log.i((String)"testBitmap", (String)("Image size after compression" + testBitmap.getAllocationByteCount() / 1024 / 1024 + "MWidth is" + testBitmap.getWidth() + "Height is" + testBitmap.getHeight() + "mScale:" + ImageScannerActivity.this.mScale));
                        int[] imgBound = new int[]{bitmapWidth, bitmapHeight};
                        ImageScannerActivity.this.mIvEditView.setRawImageBounds(imgBound);
                        ImageScannerActivity.this.mIvEditView.loadDrawBitmap(testBitmap);
                        RectF imgbound = new RectF(0.0f, 0.0f, (float)testBitmap.getWidth(), (float)testBitmap.getHeight());
                        ImageScannerActivity.this.oriBitmap = testBitmap;
                        ImageScannerActivity.this.mIvEditView.getImageMatrix().mapRect(imgbound);
                        ImageScannerActivity.this.setMagnifierView(testBitmap, imgbound);
                        ImageScannerActivity.this.mCurrentInputImagePath = imageFilePath;
                        DetectBorderTask detectTask = new DetectBorderTask(imageFilePath);
                        detectTask.execute(new Void[0]);
                    }
                } else {
                    Log.d((String)TAG, (String)("bitmapWidth=" + bitmapWidth + " bitmapHeight=" + bitmapHeight));
                }
            }
        });
    }

    public void setMagnifierView(Bitmap testBitmap, RectF imgbound) {
        Bitmap mBg = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.ic_done);
        float RADIUS = this.getResources().getDimension(R.dimen.magnifier_radius);
        float BOTTOM_HEIGHT = this.getResources().getDimension(R.dimen.dock_bar_height);
        this.mMagnifierView.setImage(testBitmap, imgbound, RADIUS, BOTTOM_HEIGHT, mBg);
    }

    public void updateMagnifierView(float x, float y) {
        this.mMagnifierView.setVisibility(0);
        this.mMagnifierView.update(x, y, this.mRotation, this.mIvEditView.getImageMatrix());
    }

    public void dismissMagnifierView() {
        if (this.mMagnifierView != null) {
            this.mMagnifierView.setVisibility(8);
            this.mMagnifierView.dismiss();
            this.mMagnifierView.recycleBGBitmap();
        }
    }

    public void changeDisplayAndSide() {
        StringBuffer sb = new StringBuffer(1024);
        DisplayMetrics outMetrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(outMetrics);
        int minLen = Math.min(outMetrics.heightPixels, outMetrics.widthPixels);
        int maxLen = Math.max(outMetrics.heightPixels, outMetrics.widthPixels);
        minLen = Math.max(minLen, 960);
        maxLen = Math.max(maxLen, 1280);
        float ratio = (float)(maxLen * maxLen * 4 * 3) * 100.0f / (float)Runtime.getRuntime().maxMemory();
        sb.append("\nRatio(New):").append(String.format("%.3f%%", Float.valueOf(ratio)));
        if (ratio > 25.0f) {
            int offset = 50;
            if (ratio > 35.0f) {
                maxLen = (int)((float)maxLen - 50.0f * (outMetrics.density + 2.0f));
            } else if (ratio > 30.0f) {
                maxLen = (int)((float)maxLen - 50.0f * (outMetrics.density + 1.0f));
            } else if (ratio > 25.0f) {
                maxLen = (int)((float)maxLen - 50.0f * outMetrics.density);
            }
            ratio = (float)(maxLen * maxLen * 4 * 3) * 100.0f / (float)Runtime.getRuntime().maxMemory();
        }
        ratio = 1.47456E9f / (float)Runtime.getRuntime().maxMemory();
        MIN_SIDE_LENGTH = minLen;
        MAX_DISPLAY_WIDTH = maxLen;
    }

    private void getTrimRegions() {
        if (this.mIvEditView.isRegionVisible()) {
            this.mCurrentThumbBounds = this.mIvEditView.getRegion(true);
            this.mCurrentFileBounds = this.mIvEditView.getRegion(false);
        } else {
            Log.d((String)TAG, (String)"getTrimRegions while mImageView.isRegionAvailable() = false");
        }
        this.changeDisplayAndSide();
        Bitmap.Config config = null;
        if (config == null) {
            config = this.getDefaultConfig();
        }
        this.mThumb = Utils.loadBitmap((String)this.mCurrentInputImagePath, (int)MIN_SIDE_LENGTH, (int)(MIN_SIDE_LENGTH * MAX_DISPLAY_WIDTH), (Bitmap.Config)config, (boolean)false, (int[])this.mCurrentFileBounds);
        for (int i = 0; i < this.mCurrentThumbBounds.length; ++i) {
            this.mCurrentThumbBounds[i] = this.mCurrentFileBounds[i];
        }
        this.mRotateBitmap = new RotateBitmap(this.mThumb, this.mRotation);
        sTrimAnimThumbMaxSize = this.mThumb.getWidth() / 2;
        if (sTrimAnimThumbMaxSize < 400.0) {
            sTrimAnimThumbMaxSize = 400.0;
        }
        this.mRawImageHandler = ISImageEnhanceHandler.newInstance(this.getApplicationContext(), this.mHandlerAnim, this.mScannerSDK);
        this.sPreStoreThumbPath = this.mRootPath + File.separator + "pretempthumb.jpg";
        this.storeThumbToFile(this.sPreStoreThumbPath);
        this.mRawImageHandler.setImagePath(this.mCurrentInputImagePath, this.sPreStoreThumbPath);
        this.mRawImageHandler.setEngineContext(this.mEngineContext);
        this.mScanRecordControl = ScanRecordControl.getInstance(this.getApplicationContext());
        if (!this.mScanRecordControl.isScannFinishNormal() && new File(this.mScanRecordControl.getImageRawPath()).exists()) {
            this.mScanRecordControl.setCrashedImageFound(true);
        }
    }

    private void storeThumbToFile(String path) {
        try {
            FileOutputStream out = new FileOutputStream(path);
            this.mThumb.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.close();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.getMessage());
        }
        Log.d((String)TAG, (String)("storeThumbToFile\uff1a " + path));
    }

    private Bitmap copySmallBitmap(Bitmap src) {
        Bitmap dst = null;
        if (src != null) {
            Bitmap.Config config = src.getConfig();
            if (config == null) {
                config = this.getDefaultConfig();
            }
            try {
                double scale;
                this.mTrimScale = scale = Math.min(sTrimAnimThumbMaxSize / (double)src.getWidth(), sTrimAnimThumbMaxSize / (double)src.getHeight());
                dst = Bitmap.createScaledBitmap((Bitmap)src, (int)((int)((double)src.getWidth() * scale)), (int)((int)((double)src.getHeight() * scale)), (boolean)true);
                Log.d((String)TAG, (String)("ori w,h = " + src.getWidth() + ", " + src.getHeight() + "; dst w,h = " + (int)((double)src.getWidth() * scale) + ", " + (int)((double)src.getHeight() * scale) + ", mTrimScale = " + this.mTrimScale));
            }
            catch (OutOfMemoryError e) {
                Log.d((String)TAG, (String)"copyBitmap", (Throwable)e);
                System.gc();
            }
        }
        return dst;
    }

    public Bitmap.Config getDefaultConfig() {
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(memInfo);
        Runtime runtime = Runtime.getRuntime();
        long PROCESS_MEMORY_LIMIT = runtime.maxMemory();
        boolean boolavailMem = memInfo.availMem >= 0x3000000L;
        boolean boollimit = PROCESS_MEMORY_LIMIT >= 0x3000000L;
        Bitmap.Config DEFAULT_BITMAP_CONFIG = boolavailMem && boollimit ? Bitmap.Config.ARGB_8888 : Bitmap.Config.RGB_565;
        return DEFAULT_BITMAP_CONFIG;
    }

    public Bitmap copyBitmap(Bitmap src, Bitmap.Config config) {
        Bitmap dst = null;
        if (src != null) {
            try {
                if (config == null) {
                    config = src.getConfig();
                }
                if (config == null) {
                    config = this.getDefaultConfig();
                }
                dst = src.copy(config, true);
            }
            catch (OutOfMemoryError e) {
                Log.d((String)TAG, (String)"copyBitmap", (Throwable)e);
                System.gc();
            }
        }
        return dst;
    }

    public void recycleBitmap(Bitmap bitmapRec) {
        if (bitmapRec != null && !bitmapRec.isRecycled()) {
            bitmapRec.recycle();
        }
    }

    private void releaseModeThumb() {
        if (this.mEnhanceModeBitmap != null) {
            for (int index = 0; index < this.mEnhanceModeBitmap.length; ++index) {
                if (this.mEnhanceModeBitmap[index] == null || this.mEnhanceModeBitmap[index].isRecycled()) continue;
                this.mEnhanceModeBitmap[index].recycle();
                this.mEnhanceModeBitmap[index] = null;
            }
        }
    }

    private Bitmap getEnhanceSourceCopyBitmap(Bitmap.Config config) {
        Bitmap result = null;
        result = this.copyBitmap(this.mEnhanceSource, config);
        return result;
    }

    private int[] getEnhanceMenuThumbSize(int thumbWidth, int thumbHeight, int rotation) {
        int[] size = new int[2];
        if (thumbWidth <= 0) {
            thumbWidth = 100;
        }
        if (thumbHeight <= 0) {
            thumbHeight = 100;
        }
        if (rotation == 90 || rotation == 270) {
            int temp = thumbWidth;
            thumbWidth = thumbHeight;
            thumbHeight = temp;
        }
        size[0] = thumbWidth;
        size[1] = thumbHeight;
        return size;
    }

    private int[] getPhoneEnhanceMenuSize() {
        int[] size = new int[]{(int)((float)this.mIvEditView.getWidth() / 4.5f), this.getResources().getDimensionPixelSize(R.dimen.enhance_menu_height)};
        return size;
    }

    private int[] get7TabletEnhanceMenuSize() {
        int[] size = new int[2];
        size[0] = this.mIvEditView.getWidth() / 6;
        if (this.mCurOrientation == 2) {
            size[1] = this.getResources().getDimensionPixelSize(R.dimen.enhance_menu_height);
        } else if (this.mCurOrientation == 1) {
            size[1] = this.getResources().getDimensionPixelSize(R.dimen.enhance_menu_height_7tablet_portrait);
        }
        return size;
    }

    private int[] get10TabletEnhanceMenuSize() {
        int[] size = new int[2];
        if (this.mCurOrientation == 2) {
            size[0] = this.getResources().getDimensionPixelSize(R.dimen.pad_image_scan_gridview_item_width);
            size[1] = this.mIvEditView.getHeight() / 6;
        } else if (this.mCurOrientation == 1) {
            size[0] = this.mIvEditView.getWidth() / 6;
            size[1] = this.getResources().getDimensionPixelSize(R.dimen.pad_image_scan_gridview_item_height);
        }
        return size;
    }

    private void adust7TabletEnhanceMenuHeight() {
        int[] size = this.get7TabletEnhanceMenuSize();
        if (size[1] > 0) {
            ViewGroup.LayoutParams params = this.mEnhanceModeBar.getLayoutParams();
            params.height = size[1];
            this.mEnhanceModeBar.setLayoutParams(params);
        }
    }

    private void handleModeMenuThumb(Bitmap src) {
        this.mFinishPrepareEnhanceMenuThumb = false;
        if (this.mFixedThreadPool == null) {
            int numberProcessors = 1;
            if (Runtime.getRuntime().availableProcessors() > 2) {
                numberProcessors = 2;
            }
            this.mFixedThreadPool = Executors.newFixedThreadPool(numberProcessors);
        }
        int engineContext = ScannerEngine.initThreadContext();
        int[] size = ScannerEngine.nativeDewarpImagePlaneForSize((int)engineContext, (int)src.getWidth(), (int)src.getHeight(), (int[])this.mCurrentThumbBounds);
        ScannerEngine.destroyThreadContext((int)engineContext);
        int[] menuSize = null;
        int[] thumbSize = null;
        int margin = this.getResources().getDimensionPixelSize(R.dimen.enhance_menu_margin);
        if (this.isSmallScreen && !this.mIs7Tablet) {
            menuSize = this.getPhoneEnhanceMenuSize();
            menuSize[0] = menuSize[0] - margin - margin;
            thumbSize = this.getEnhanceMenuThumbSize(menuSize[0], menuSize[1], this.mRotation);
        } else if (this.mIs7Tablet) {
            menuSize = this.get7TabletEnhanceMenuSize();
            menuSize[0] = menuSize[0] - margin - margin;
            menuSize[1] = menuSize[1] - margin - margin;
            thumbSize = this.getEnhanceMenuThumbSize(menuSize[0], menuSize[1], this.mRotation);
        } else {
            menuSize = this.get10TabletEnhanceMenuSize();
            menuSize[0] = menuSize[0] - margin - margin;
            menuSize[1] = menuSize[1] - margin - margin;
            thumbSize = this.getEnhanceMenuThumbSize(menuSize[0], menuSize[1], this.mRotation);
        }
        Bitmap rawThumb = this.getCentreCropScaleBitmap(src, thumbSize[0], thumbSize[1], size);
        long startTime = System.currentTimeMillis();
        Future<Bitmap> autoFuture = this.mFixedThreadPool.submit(new EnhanceCallable(rawThumb, this.mAutoMode));
        Future<Bitmap> linerFuture = this.mFixedThreadPool.submit(new EnhanceCallable(rawThumb, 15));
        Future<Bitmap> magicFuture = this.mFixedThreadPool.submit(new EnhanceCallable(rawThumb, 17));
        Future<Bitmap> grayFuture = this.mFixedThreadPool.submit(new EnhanceCallable(rawThumb, 10));
        Future<Bitmap> blackWhiteFuture = this.mFixedThreadPool.submit(new EnhanceCallable(rawThumb, 16));
        try {
            this.mEnhanceModeBitmap[1] = autoFuture.get();
            this.mEnhanceModeBitmap[0] = rawThumb;
            this.mEnhanceModeBitmap[2] = linerFuture.get();
            this.mEnhanceModeBitmap[3] = magicFuture.get();
            this.mEnhanceModeBitmap[4] = grayFuture.get();
            this.mEnhanceModeBitmap[5] = blackWhiteFuture.get();
        }
        catch (InterruptedException e) {
            Log.d((String)TAG, (String)("InterruptedException msg=" + e.getMessage()));
        }
        catch (ExecutionException e) {
            Log.d((String)TAG, (String)("ExecutionException msg=" + e.getMessage()));
        }
        boolean findNumThumb = false;
        for (int index = 0; index < this.mEnhanceModeBitmap.length; ++index) {
            if (this.mEnhanceModeBitmap[index] != null) continue;
            findNumThumb = true;
            break;
        }
        if (!findNumThumb) {
            this.mFinishPrepareEnhanceMenuThumb = true;
        }
        Log.d((String)TAG, (String)("handleModeMenuThumb Time=" + (System.currentTimeMillis() - startTime)));
    }

    private Bitmap getCentreCropScaleBitmap(Bitmap src, int viewWidth, int viewHeight, int[] trimSize) {
        Bitmap dstBitmap = null;
        if (src != null && viewWidth > 0 && viewHeight > 0) {
            float imageScale;
            int left = 0;
            int top = 0;
            int cropWidth = 0;
            int cropHeght = 0;
            float srcScale = 1.0f * (float)src.getWidth() / (float)src.getHeight();
            if (trimSize != null && trimSize[0] > 0 && trimSize[1] > 0) {
                imageScale = 1.0f * (float)trimSize[0] / (float)trimSize[1];
                if (srcScale > imageScale) {
                    cropHeght = src.getHeight();
                    cropWidth = (int)(imageScale * (float)cropHeght);
                } else {
                    cropWidth = src.getWidth();
                    cropHeght = (int)((float)cropWidth / imageScale);
                }
            } else {
                imageScale = srcScale;
                cropHeght = src.getHeight();
                cropWidth = src.getWidth();
            }
            float viewScale = 1.0f * (float)viewWidth / (float)viewHeight;
            float scale = 1.0f;
            if ((double)Math.abs(viewScale - imageScale) > 0.001) {
                if (viewScale > imageScale) {
                    scale = (float)viewWidth / (float)cropWidth;
                    cropHeght = (int)((float)cropWidth / viewScale);
                } else {
                    scale = (float)viewHeight / (float)cropHeght;
                    cropWidth = (int)((float)cropHeght * viewScale);
                }
            } else {
                scale = (float)viewWidth / (float)cropWidth;
            }
            top = (src.getHeight() - cropHeght) / 2;
            left = (src.getWidth() - cropWidth) / 2;
            if (left >= 0 && left <= src.getWidth() && top >= 0 && top <= src.getHeight() && cropWidth > 0 && cropWidth <= src.getWidth() && cropHeght > 0 && cropHeght <= src.getHeight()) {
                Matrix m = null;
                if (scale < 1.0f) {
                    m = new Matrix();
                    m.postScale(scale, scale);
                }
                if (this.mRotation != 0) {
                    if (m == null) {
                        m = new Matrix();
                    }
                    m.postRotate((float)this.mRotation);
                }
                try {
                    dstBitmap = Bitmap.createBitmap((Bitmap)src, (int)left, (int)top, (int)cropWidth, (int)cropHeght, (Matrix)m, (boolean)true);
                    if (dstBitmap == src) {
                        Log.d((String)TAG, (String)"dstBitmap == src");
                        dstBitmap = this.copyBitmap(src, null);
                    }
                }
                catch (OutOfMemoryError e) {
                    Log.d((String)TAG, (String)e.getMessage());
                }
            }
        }
        return dstBitmap;
    }

    private void initEnhanceBar() {
        if (this.isSmallScreen && !this.mIs7Tablet && this.mEnhanceModeBar instanceof HorizontalListView) {
            int[] size = this.getPhoneEnhanceMenuSize();
            if (size[0] <= 0) {
                DisplayMetrics metrics = new DisplayMetrics();
                WindowManager wm = (WindowManager)this.getSystemService("window");
                wm.getDefaultDisplay().getMetrics(metrics);
                size[0] = (int)((float)metrics.widthPixels / 4.5f);
            }
            final int oneItemWidth = size[0];
            Log.d((String)TAG, (String)(" oneItemWidth=" + oneItemWidth));
            final HorizontalListView list = (HorizontalListView)this.mEnhanceModeBar;
            int margin = this.getResources().getDimensionPixelSize(R.dimen.enhance_menu_margin);
            final int thumbWidth = oneItemWidth - margin - margin;
            final BaseAdapter adapter = new BaseAdapter(){

                public View getView(int position, View convertView, ViewGroup parent) {
                    View view = convertView;
                    ImageView iv = null;
                    TextView tv = null;
                    if (view == null) {
                        view = View.inflate((Context)ImageScannerActivity.this, (int)R.layout.horizontal_list_item, null);
                        view.setMinimumWidth(oneItemWidth);
                        iv = (ImageView)view.findViewById(R.id.item_image);
                        tv = (TextView)view.findViewById(R.id.item_text);
                        tv.setMinimumWidth(thumbWidth);
                        ViewGroup.LayoutParams params = iv.getLayoutParams();
                        params.width = thumbWidth;
                        params.height = thumbWidth;
                        iv.setLayoutParams(params);
                    } else {
                        iv = (ImageView)view.findViewById(R.id.item_image);
                        tv = (TextView)view.findViewById(R.id.item_text);
                    }
                    RelativeLayout item_rel = (RelativeLayout)view.findViewById(R.id.item_rel);
                    try {
                        if (ImageScannerActivity.this.mEnhanceModeBitmap[position] != null && !ImageScannerActivity.this.mEnhanceModeBitmap[position].isRecycled()) {
                            iv.setImageBitmap(ImageScannerActivity.this.mEnhanceModeBitmap[position]);
                        } else {
                            iv.setImageBitmap(null);
                        }
                        if (ImageScannerActivity.this.mEnhanceModeIndex == position) {
                            item_rel.setBackgroundDrawable(ImageScannerActivity.this.getResources().getDrawable(R.drawable.rounded_choose));
                        } else {
                            item_rel.setBackgroundDrawable(ImageScannerActivity.this.getResources().getDrawable(R.drawable.rounded_unchoose));
                        }
                    }
                    catch (OutOfMemoryError e) {
                        Log.d((String)TAG, (String)e.getMessage());
                    }
                    Log.d((String)TAG, (String)("getView mEnhanceModeIndex=" + ImageScannerActivity.this.mEnhanceModeIndex + " pos=" + position));
                    tv.setText((CharSequence)ImageScannerActivity.this.mModeNames[position]);
                    return view;
                }

                public long getItemId(int position) {
                    return position;
                }

                public Object getItem(int position) {
                    return position;
                }

                public int getCount() {
                    return ImageScannerActivity.this.mModeNames.length;
                }
            };
            list.setAdapter((ListAdapter)adapter);
            list.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                public void onItemClick(AdapterView<?> parent, View view, int pos, long id2) {
                    ImageScannerActivity.this.mEnhanceModeIndex = pos;
                    Log.d((String)TAG, (String)("mEnhanceModeIndex=" + ImageScannerActivity.this.mEnhanceModeIndex));
                    if (ImageScannerActivity.this.mOriginalEnhanceBitmap != null) {
                        EnhanceTask enhanceTask = new EnhanceTask(ImageScannerActivity.this.getEnhanceMode(pos));
                        enhanceTask.execute(new Void[0]);
                    } else {
                        Log.d((String)TAG, (String)("mOriginalEnhanceBitmap=" + ImageScannerActivity.this.mOriginalEnhanceBitmap));
                    }
                    int firstViewPos = list.getFirstVisiblePosition();
                    int offset = 0;
                    int childpos = ImageScannerActivity.this.mEnhanceModeIndex - firstViewPos;
                    if (ImageScannerActivity.this.mEnhanceModeIndex > 0 && ImageScannerActivity.this.mEnhanceModeIndex < ImageScannerActivity.this.mModeNames.length - 1) {
                        offset = oneItemWidth / 2;
                    }
                    adapter.notifyDataSetChanged();
                }
            });
            if (this.mEnhanceModeIndex > 3) {
                float offset = ((float)this.mEnhanceModeIndex - 3.5f) * (float)oneItemWidth;
                list.scrollTo((int)offset);
            }
        }
    }

    static /* synthetic */ int[] access$2302(ImageScannerActivity x0, int[] x1) {
        x0.mLastDetectBorder = x1;
        return x1;
    }

    static /* synthetic */ int[] access$2602(ImageScannerActivity x0, int[] x1) {
        x0.mBitmapDetectBound = x1;
        return x1;
    }

    private class EnhanceCallable
    implements Callable<Bitmap> {
        private Bitmap mSrc;
        private int mMode;

        public EnhanceCallable(Bitmap src, int enhanceMode) {
            this.mSrc = src;
            this.mMode = enhanceMode;
        }

        @Override
        public Bitmap call() throws Exception {
            Bitmap dstBitmap = null;
            for (int repeat = 0; dstBitmap == null && repeat < 2; ++repeat) {
                dstBitmap = ImageScannerActivity.this.copyBitmap(this.mSrc, null);
            }
            if (dstBitmap != null) {
                int threadContext = ScannerEngine.initThreadContext();
                ScannerEngine.enhanceImage((int)threadContext, dstBitmap, (int)this.mMode);
                ScannerEngine.destroyThreadContext((int)threadContext);
            }
            return dstBitmap;
        }
    }

    private class TrimAnimTask
    extends AsyncTask<Void, Integer, Boolean> {
        private Bitmap[] mEnhanceModeBitmap = new Bitmap[7];

        private TrimAnimTask() {
        }

        protected void onPreExecute() {
            ImageScannerActivity.this.mImageProcessListener = new ImageProcessListener(ImageScannerActivity.this.mHandlerAnim);
            ImageScannerActivity.this.mIvEditView.setRegionVisibility(false);
            ImageScannerActivity.this.bt_toolbar_line.setVisibility(8);
            ImageScannerActivity.this.bt_process_line.setVisibility(0);
        }

        protected void onPostExecute(Boolean result) {
            Log.d((String)TAG, (String)"TrimAnimTask requestStoreImage after task");
            ImageScannerActivity.this.bt_toolbar_line.setVisibility(0);
            ImageScannerActivity.this.bt_process_line.setVisibility(8);
            ImageScannerActivity.this.startTtrim();
        }

        protected Boolean doInBackground(Void ... arg0) {
            Bitmap.Config config = ImageScannerActivity.this.mThumb.getConfig();
            if (config == null) {
                config = ImageScannerActivity.this.getDefaultConfig();
            }
            if (ImageScannerActivity.this.mIvEditView.isRegionAvailable()) {
                Bitmap trimSrc = ImageScannerActivity.this.copyBitmap(ImageScannerActivity.this.mThumb, config);
                ImageScannerActivity.this.mEnhanceSource = this.trimImage(trimSrc, ImageScannerActivity.this.mCurrentThumbBounds);
                ImageScannerActivity.this.recycleBitmap(trimSrc);
                ImageScannerActivity.this.mIsTrim = true;
            } else {
                ImageScannerActivity.this.mIsTrim = false;
            }
            if (ImageScannerActivity.this.mEnhanceSource == null) {
                ImageScannerActivity.this.mEnhanceSource = ImageScannerActivity.this.copyBitmap(ImageScannerActivity.this.mThumb, config);
            }
            if (ImageScannerActivity.this.mEnhanceSource == null) {
                ImageScannerActivity.this.releaseModeThumb();
                ImageScannerActivity.this.mHandlerAnim.sendMessage(ImageScannerActivity.this.mHandlerAnim.obtainMessage(1008, 0, 0, (Object)ImageScannerActivity.this.mThumb));
            } else {
                ImageScannerActivity.this.handleModeMenuThumb(ImageScannerActivity.this.mEnhanceSource);
            }
            return null;
        }

        public Bitmap dewarpImagePlane(int context, Bitmap image, int[] corner_xy, boolean bAntiAliasing) {
            Bitmap.Config config = image.getConfig();
            if (config == null) {
                config = Bitmap.Config.RGB_565;
            }
            Bitmap out = ImageScannerActivity.this.copyBitmap(image, config);
            try {
                int ret = ScannerEngine.trimBitmap((int)context, (Bitmap)image, (int[])corner_xy, (Bitmap)out, (int)1, (int)1);
                if (ret < 0 && out != null) {
                    out.recycle();
                    out = null;
                }
            }
            catch (OutOfMemoryError e) {
                Log.d((String)TAG, (String)e.getMessage());
                out = null;
            }
            return out;
        }

        private Bitmap trimImage(Bitmap src, int[] bounds) {
            if (src == null) {
                Log.d((String)TAG, (String)"skip trimImage");
                return ImageScannerActivity.this.mThumb;
            }
            ImageScannerActivity.this.mHandlerAnim.sendMessage(ImageScannerActivity.this.mHandlerAnim.obtainMessage(1007, R.string.step_trim, 0, (Object)ImageScannerActivity.this.mThumb));
            ImageScannerActivity.this.mScanRecordControl.setCurrentScanStep("dewarp_image_plane");
            Bitmap trimmed = this.dewarpImagePlane(ImageScannerActivity.this.mEngineContext, src, bounds, true);
            ImageScannerActivity.this.mImageProcessListener.setTrim(src);
            Log.d((String)TAG, (String)"dewarpImagePlane beign");
            long start = System.currentTimeMillis();
            ScannerEngine.setProcessListener((int)ImageScannerActivity.this.mEngineContext, (ScannerEngine.ScannerProcessListener)ImageScannerActivity.this.mImageProcessListener);
            ImageScannerActivity.this.mRawImageHandler.trimThumb(ImageScannerActivity.this.mCurrentThumbBounds);
            ScannerEngine.setProcessListener((int)ImageScannerActivity.this.mEngineContext, null);
            int cost = (int)(System.currentTimeMillis() - start);
            Log.d((String)TAG, (String)("dewarpImagePlane ok consume " + cost + ", finish at " + System.currentTimeMillis()));
            return trimmed;
        }
    }

    public class AnimationView
    extends View {
        public AnimationView(Context context) {
            super(context);
            ObjectAnimator objectAnimator = (ObjectAnimator)AnimatorInflater.loadAnimator((Context)ImageScannerActivity.this, (int)R.animator.coloranimation);
            objectAnimator.setEvaluator((TypeEvaluator)new ArgbEvaluator());
            objectAnimator.setTarget((Object)this);
            objectAnimator.start();
        }
    }

    private class ImageProcessListener
    implements ScannerEngine.ScannerProcessListener {
        private Handler mHandlerAnim;
        private Bitmap mSrc;
        private Bitmap mOut;
        private int[] mSmallTrimBounds;
        private int TrimGipTime;
        private long mLastProcessTime = 0L;

        public ImageProcessListener(Handler handler) {
            this.mHandlerAnim = handler;
            this.TrimGipTime = 100;
        }

        public void setTrim(Bitmap thumb) {
            this.mSrc = ImageScannerActivity.this.copySmallBitmap(thumb);
            this.mSmallTrimBounds = new int[ImageScannerActivity.this.mCurrentThumbBounds.length];
            for (int i = 0; i < this.mSmallTrimBounds.length; ++i) {
                this.mSmallTrimBounds[i] = (int)((double)ImageScannerActivity.this.mCurrentThumbBounds[i] * ImageScannerActivity.this.mTrimScale);
            }
        }

        public boolean onProcess(int sessionId, int progress) {
            int target;
            if (ImageScannerActivity.this.isFinishing()) {
                return false;
            }
            if (sessionId == 4 || sessionId == 0) {
                target = 1006;
                this.mHandlerAnim.sendMessage(Message.obtain((Handler)this.mHandlerAnim, (int)target, (int)progress, (int)0));
            }
            if (sessionId == 3) {
                target = 1005;
                if ((progress += 10) > 100) {
                    progress = 100;
                }
                long time = System.currentTimeMillis();
                this.mOut = ImageScannerActivity.this.copyBitmap(this.mSrc, null);
                int result = ScannerEngine.drawDewarpProgressImage((int)ImageScannerActivity.this.mEngineContext, (Bitmap)this.mSrc, (int[])this.mSmallTrimBounds, (Bitmap)this.mOut, (int)progress, (int)100);
                long sleepTime = (long)this.TrimGipTime - (System.currentTimeMillis() - this.mLastProcessTime);
                if (sleepTime > 0L) {
                    Log.d((String)TAG, (String)("trim anim sleep: " + sleepTime));
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        Log.d((String)TAG, (String)e.getMessage());
                    }
                }
                this.mHandlerAnim.sendMessage(this.mHandlerAnim.obtainMessage(target, progress, 0, (Object)this.mOut));
            }
            this.mLastProcessTime = System.currentTimeMillis();
            return true;
        }
    }

    private class MyCornerChangeListener
    implements ImageEditView.OnCornorChangeListener {
        private MyCornerChangeListener() {
        }

        public void onPreMove() {
        }

        public void onPostMove() {
            ImageScannerActivity.this.dismissMagnifierView();
        }

        public void onCornorChanged() {
            if (ImageScannerActivity.this.mIvEditView != null) {
                if (ImageScannerActivity.this.mIvEditView.isCanTrim(ImageScannerActivity.this.mEngineContext)) {
                    ImageScannerActivity.this.mIvEditView.setLinePaintColor(mNormalColor);
                } else {
                    ImageScannerActivity.this.mIvEditView.setLinePaintColor(mErrorColor);
                }
                ImageScannerActivity.access$2602(ImageScannerActivity.this, ImageScannerActivity.this.mIvEditView.getRegion(false));
                for (int i = 0; i < ImageScannerActivity.this.mBitmapDetectBound.length; ++i) {
                    ((ImageScannerActivity)ImageScannerActivity.this).mViewTtrimBound[i] = ImageScannerActivity.this.mBitmapDetectBound[i];
                }
                ImageScannerActivity.this.mIvEditView.invalidate();
            }
        }

        public void onClickPoint(float x, float y) {
            ImageScannerActivity.this.updateMagnifierView(x, y);
        }
    }

    class EnhanceTask
    extends AsyncTask<Void, Void, Void> {
        public EnhanceTask(int mode) {
            ImageScannerActivity.this.mEnhanceMode = mode;
        }

        protected void onPreExecute() {
            ImageScannerActivity.this.showProgressDialog();
        }

        protected Void doInBackground(Void ... params) {
            int threadContext = ImageScannerActivity.this.mScannerSDK.initThreadContext();
            int imageStruct = 0;
            imageStruct = ImageScannerActivity.this.mScannerSDK.decodeImageS(ImageScannerActivity.this.mOriTrimImageEnchancePath);
            if (ImageScannerActivity.this.mEnhanceBitmap != null && !ImageScannerActivity.this.mEnhanceBitmap.isRecycled()) {
                ImageScannerActivity.this.mEnhanceBitmap.recycle();
            }
            Log.d((String)TAG, (String)"mEnhanceBitmap");
            ImageScannerActivity.this.mScannerSDK.enhanceImage(threadContext, imageStruct, ImageScannerActivity.this.mEnhanceMode);
            Log.e((String)TAG, (String)("CS enhanceImage mEnhanceMode" + ImageScannerActivity.this.mEnhanceMode));
            if (ImageScannerActivity.this.mEnRotation != 0) {
                ImageScannerActivity.this.mScannerSDK.rotateAndScaleImageS(threadContext, imageStruct, ImageScannerActivity.this.mEnRotation);
            }
            ImageScannerActivity.this.mScannerSDK.saveImage(imageStruct, ImageScannerActivity.this.mOriTrimImagePathResult, TRIM_IMAGE_SAVELOCALSIDE);
            ImageScannerActivity.this.mScannerSDK.releaseImage(imageStruct);
            ImageScannerActivity.this.mScannerSDK.destroyContext(threadContext);
            ImageScannerActivity.this.changeBitmap(ImageScannerActivity.this.mOriTrimImagePathResult);
            ImageScannerActivity.this.mEnhanceBitmap = ImageScannerActivity.this.mOriginalEnhanceBitmap.copy(ImageScannerActivity.this.mOriginalEnhanceBitmap.getConfig(), true);
            return null;
        }

        protected void onPostExecute(Void result) {
            ImageScannerActivity.this.dismissProgressDialog();
            ImageScannerActivity.this.showIvEnhance(ImageScannerActivity.this.mEnhanceBitmap);
            Log.d((String)TAG, (String)"finish, EnhanceTask");
        }
    }

    class TrimTask
    extends AsyncTask<Void, Void, Boolean> {
        TranslateAnimation mTranslateAnimation;
        boolean boolIqa = false;
        private long mStartTime;
        private String mPath;
        private int grayInt = -1;

        public TrimTask(String path) {
            this.mPath = path;
        }

        protected void onPreExecute() {
            ImageScannerActivity.this.mMagnifierView.setVisibility(8);
            ImageScannerActivity.this.ocr_scan_rel.setVisibility(0);
            this.mTranslateAnimation = new TranslateAnimation(0, 0.0f, 0, 0.0f, 2, 0.0f, 2, 1.0f);
            this.mTranslateAnimation.setDuration(1000L);
            this.mTranslateAnimation.setInterpolator((Interpolator)new LinearInterpolator());
            ImageScannerActivity.this.ocr_scan_line.setAnimation((Animation)this.mTranslateAnimation);
        }

        protected Boolean doInBackground(Void ... params) {
            Log.d((String)TAG, (String)"TrimTask, doInBackground");
            long tempTime = 0L;
            boolean succeed = false;
            this.mStartTime = System.currentTimeMillis();
            int threadContext = ImageScannerActivity.this.mScannerSDK.initThreadContext();
            System.out.println("TrimTask, initThreadContext, cost time:" + (System.currentTimeMillis() - this.mStartTime));
            tempTime = System.currentTimeMillis();
            int imageStruct = ImageScannerActivity.this.mScannerSDK.decodeImageS(this.mPath);
            System.out.println("TrimTask, decodeImageS, cost time:" + (System.currentTimeMillis() - tempTime));
            if (imageStruct != 0) {
                tempTime = System.currentTimeMillis();
                int[] bound = ImageScannerActivity.this.mBitmapDetectBound;
                Log.d((String)TAG, (String)("bound=" + Arrays.toString(bound)));
                ImageScannerActivity.this.mScannerSDK.trimImage(threadContext, imageStruct, bound, TRIM_IMAGE_MAXSIDE);
                System.out.println("TrimTask, trimImage, cost time:" + (System.currentTimeMillis() - tempTime));
                tempTime = System.currentTimeMillis();
                ImageScannerActivity.this.mScannerSDK.rotateAndScaleImageS(threadContext, imageStruct, ImageScannerActivity.this.mRotation);
                if (ImageScannerActivity.this.boolJudgeGrayOrColor) {
                    this.grayInt = ImageScannerActivity.this.mScannerSDK.grayOrColorJudge(imageStruct);
                    this.boolIqa = ImageScannerActivity.this.mScannerSDK.RecognizeOneIqaSelect(imageStruct);
                }
                ImageScannerActivity.this.mScannerSDK.saveImage(imageStruct, ImageScannerActivity.this.mOriTrimImageEnchancePath, TRIM_IMAGE_SAVESIDE);
                System.out.println("TrimTask, saveImage, cost time:" + (System.currentTimeMillis() - tempTime));
                tempTime = System.currentTimeMillis();
                ImageScannerActivity.this.mScannerSDK.releaseImage(imageStruct);
                System.out.println("TrimTask, releaseImage, cost time:" + (System.currentTimeMillis() - tempTime));
                if (ImageScannerActivity.this.boolJudgeGrayOrColor) {
                    int imageStructGray = ImageScannerActivity.this.mScannerSDK.decodeImageS(ImageScannerActivity.this.mOriTrimImageEnchancePath);
                    System.out.println("mScannerSDK.grayOrColorJudge grayInt:" + this.grayInt);
                    ImageScannerActivity.this.mScannerSDK.releaseImage(imageStructGray);
                }
                ImageScannerActivity.this.changeBitmap(ImageScannerActivity.this.mOriTrimImageEnchancePath);
                succeed = true;
            }
            ImageScannerActivity.this.mScannerSDK.destroyContext(threadContext);
            System.out.println("TrimTask, cost time:" + (System.currentTimeMillis() - this.mStartTime));
            return succeed;
        }

        protected void onPostExecute(Boolean result) {
            ImageScannerActivity.this.dismissProgressDialog();
            Log.d((String)TAG, (String)("result=" + result));
            if (this.grayInt == 0) {
                ImageScannerActivity.this.gray_comment_idCrop.setText((CharSequence)("The current trimming picture is in color" + (this.boolIqa ? "-----Clear" : "-----Blur")));
            } else if (this.grayInt == 1) {
                ImageScannerActivity.this.gray_comment_idCrop.setText((CharSequence)("The current trimming picture is black and white" + (this.boolIqa ? "-----Clear " : " -----Blur")));
            }
            if (result.booleanValue()) {
                ImageScannerActivity.this.ocr_scan_rel.setVisibility(8);
                this.mTranslateAnimation.cancel();
                this.mTranslateAnimation = null;
                ImageScannerActivity.this.ocr_scan_line.clearAnimation();
                ImageScannerActivity.this.ocr_scan_line.setVisibility(8);
                ImageScannerActivity.this.enterEnhanceLayout();
                ImageScannerActivity.this.mEnhanceBitmap = ImageScannerActivity.this.mOriginalEnhanceBitmap.copy(ImageScannerActivity.this.mOriginalEnhanceBitmap.getConfig(), true);
                Log.d((String)TAG, (String)("mEnhanceModeIndexExtra=" + ImageScannerActivity.this.mEnhanceModeIndexExtra));
                if (ImageScannerActivity.this.mEnhanceModeIndexExtra != -1) {
                    if (ImageScannerActivity.this.mOriginalEnhanceBitmap != null) {
                        EnhanceTask enhanceTask = new EnhanceTask(ImageScannerActivity.this.getEnhanceMode(ImageScannerActivity.this.mEnhanceModeIndexExtra));
                        enhanceTask.execute(new Void[0]);
                    } else {
                        Log.d((String)TAG, (String)("mOriginalEnhanceBitmap=" + ImageScannerActivity.this.mOriginalEnhanceBitmap));
                    }
                } else {
                    ImageScannerActivity.this.mEnhanceModeIndex = 0;
                    ImageScannerActivity.this.initEnhanceBar();
                }
            } else {
                Log.d((String)TAG, (String)("result=" + result));
            }
        }
    }

    class DetectBorderTask
    extends AsyncTask<Void, Void, Boolean> {
        private long mStartTime;
        private String mPath;
        private float[] mOrginBounds = null;
        private int grayInt = -1;

        public DetectBorderTask(String path) {
            this.mPath = path;
        }

        protected void onPreExecute() {
            ImageScannerActivity.this.showProgressDialog();
        }

        protected Boolean doInBackground(Void ... params) {
            boolean succed = false;
            long tempTime = 0L;
            this.mStartTime = System.currentTimeMillis();
            int threadContext = ImageScannerActivity.this.mScannerSDK.initThreadContext();
            System.out.println("DetectBorderTask, initThreadContext, cost time:" + (System.currentTimeMillis() - this.mStartTime));
            tempTime = System.currentTimeMillis();
            int imageStruct = ImageScannerActivity.this.mScannerSDK.decodeImageS(this.mPath);
            System.out.println("DetectBorderTask, decodeImageS, cost time:" + (System.currentTimeMillis() - tempTime));
            ImageScannerActivity.access$2302(ImageScannerActivity.this, null);
            int[] imgBound = ImageScannerActivity.getImageSizeBound(this.mPath);
            if (imageStruct != 0) {
                tempTime = System.currentTimeMillis();
                ImageScannerActivity.access$2302(ImageScannerActivity.this, ImageScannerActivity.this.mScannerSDK.detectBorder(threadContext, imageStruct));
                System.out.println("DetectBorderTask, detectBorder, cost time:" + (System.currentTimeMillis() - tempTime));
                Log.d((String)TAG, (String)("detectAndTrimImageBorder, borders=" + Arrays.toString(ImageScannerActivity.this.mLastDetectBorder)));
                tempTime = System.currentTimeMillis();
                this.mOrginBounds = ImageScannerActivity.getScanBoundF(imgBound, ImageScannerActivity.this.mLastDetectBorder);
                float[] bound = ImageScannerActivity.getScanBoundF(imgBound, ImageScannerActivity.this.mLastDetectBorder);
                if (bound != null) {
                    for (int i = 0; i < bound.length; ++i) {
                        ((ImageScannerActivity)ImageScannerActivity.this).mBitmapDetectBound[i] = (int)bound[i];
                        ((ImageScannerActivity)ImageScannerActivity.this).mViewTtrimBound[i] = ImageScannerActivity.this.mBitmapDetectBound[i];
                    }
                }
                System.out.println("DetectBorderTask, fix border, cost time:" + (System.currentTimeMillis() - tempTime));
                tempTime = System.currentTimeMillis();
                ImageScannerActivity.this.mScannerSDK.releaseImage(imageStruct);
                System.out.println("DetectBorderTask, releaseImage, cost time:" + (System.currentTimeMillis() - tempTime));
                succed = true;
            } else {
                this.mOrginBounds = ImageScannerActivity.getScanBoundF(imgBound, null);
            }
            ImageScannerActivity.this.mScannerSDK.destroyContext(threadContext);
            System.out.println("DetectBorderTask, cost time:" + (System.currentTimeMillis() - this.mStartTime));
            return succed;
        }

        protected void onPostExecute(Boolean result) {
            ImageScannerActivity.this.dismissProgressDialog();
            Log.d((String)TAG, (String)("result=" + result));
            if (result.booleanValue()) {
                if ((double)ImageScannerActivity.this.mScale < 0.001 && (double)ImageScannerActivity.this.mScale > -0.001) {
                    ImageScannerActivity.this.mScale = 1.0f;
                }
                if (this.mOrginBounds != null) {
                    ImageScannerActivity.this.mIvEditView.setRegion(this.mOrginBounds, ImageScannerActivity.this.mScale);
                    ImageScannerActivity.this.mIvEditView.setRegionVisibility(true);
                }
                ImageScannerActivity.this.mBtnNext.setVisibility(0);
            } else {
                Log.d((String)TAG, (String)("result=" + result));
            }
        }
    }
}

