package com.gaadi.neon.activity;

import android.animation.AnimatorInflater;
import android.animation.ArgbEvaluator;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.provider.MediaStore;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.LinearInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.gaadi.neon.view.HorizontalListView;
import com.gaadi.neon.view.ISImageEnhanceHandler;
import com.gaadi.neon.view.ScanRecordControl;
import com.intsig.scanner.CommonUtil;
import com.intsig.scanner.ScannerEngine;
import com.intsig.scanner.ScannerEngine.ScannerProcessListener;
import com.intsig.scanner.ScannerSDK;
import com.intsig.view.DocumentUtil;
import com.intsig.view.ImageEditView;
import com.intsig.view.ImageEditView.OnCornorChangeListener;
import com.intsig.view.MagnifierView;
import com.intsig.view.RotateBitmap;
import com.intsig.view.Utils;
import com.scanlibrary.R;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * This interface mainly displays image trimming and enhancement. This view is used to show image's crop and enhance process
 */
public class ImageScannerActivity extends Activity implements
        OnItemSelectedListener, OnClickListener {
    public final static int IMPORT_FROM_CAMERA = 0;
    public final static int IMPORT_FROM_GALLERY = 1;
    public final static int IMPORT_FROM_FILEDIR = 2;// File absolute path
    public static final int ENHANCE_AUTO_MODE = 0;//automatic
    public static final int ENHANCE_RAW_MODE = 1;//Original image
    public static final int ENHANCE_LINER_FUTURE_MODE = 2;// Brighten
    public static final int ENHANCE_MAGIC_FUTURE_MODE = 3;//Enhance and sharpen
    public static final int ENHANCE_GRAY_FUTURE_MODE = 4;// Grayscale
    public static final int ENHANCE_BLACKWHITE_FUTURE_MODE = 5;// Black and white
    protected static final int PROGRESS_ENHANCE_INCREASE = 1006;
    protected static final int PROGRESS_TRIM_INCREASE = 1005;
    private static final String TAG = ImageScannerActivity.class
            .getSimpleName();
    private static final int REQ_CODE_GALLERY_IMPORT = 0;
    private static final int MSG_ROTATE_IMAGE = 1014;
    /**
     * Maximum number of times
     */
    private static final int MAX_COPY_TRY_TIME = 2;
    private static final int WIDTH = 100;
    private static final int HEIGHT = 100;
    public static int TRIM_IMAGE_MAXSIDE = 1600;
    /**
     * Return external authorization error code
     */
    public static String EXTRA_KEY_RESULT_ERROR_CODE = "EXTRA_KEY_RESULT_ERROR_CODE";
    public static String EXTRA_KEY_RESULT_ERROR_MSG = "EXTRA_KEY_RESULT_ERROR_MSG";
    /**
     * External input engine scaling parameters
     */
    public static String EXTRA_TRIM_IMAGE_MAXSIDE = "EXTRA_TRIM_IMAGE_MAXSIDE";
    /**
     * APPKEY:Identification and verification key
     */
    public static String EXTRA_KEY_APP_KEY = "EXTRA_KEY_APP_KEY";
    /**
     * EXTRA_TRIM_NORMAL_COLOR:Normal color of cut edges
     */
    public static String EXTRA_TRIM_NORMAL_COLOR = "EXTRA_TRIM_NORMAL_COLOR";
    /**
     * EXTRA_TRIM_ERROR_COLOR:Unusual color of cut edges
     */
    public static String EXTRA_TRIM_ERROR_COLOR = "EXTRA_TRIM_ERROR_COLOR";
    /**
     * EXTRA_KEY_RESULT_DATA_PATH:Picture after trimming
     */
    public static String EXTRA_KEY_RESULT_DATA_PATH = "EXTRA_KEY_RESULT_DATA_PATH";
    /**
     * EXTRA_IMPORT_IMG_TYPE:Import picture method 0 through camera 1 through image selection
     */
    public static String EXTRA_IMPORT_IMG_TYPE = "EXTRA_IMPORT_IMG_TYPE";
    /**
     * EXTRA_KEY_INPUTFILE_DATA_PATH :The absolute path of the trimming
     */
    public static String EXTRA_KEY_INPUTFILE_DATA_PATH = "EXTRA_KEY_INPUTFILE_DATA_PATH";
    /**
     * EXTRA_KEY_ENHANCE_MODE_INDEX
     */
    public static String EXTRA_KEY_ENHANCE_MODE_INDEX = "EXTRA_KEY_ENHANCE_MODE_INDEX";

    /**
     * Pass in parameters from the outside to control the appkey and color of the trimming enhancement, and return to the picture after saving
     */
    public static String EXTRA_KEY_JUDGE_GRAYORCOLOR = "EXTRA_KEY_JUDGE_GRAYORCOLOR";
    public static int MIN_SIDE_LENGTH = 800;
    public static int MAX_DISPLAY_WIDTH = 1280;
    private static int TRIM_IMAGE_SAVESIDE = 60;
    private static int TRIM_IMAGE_SAVELOCALSIDE = 60;
    private static SimpleDateFormat sPdfTime = new SimpleDateFormat(
            "yyyy-MM-dd_HH-mm-ss");
    /**
     * your app key
     */
    private static String APPKEY = "b68116bfdbcac018b4852bf851-vagfvt";
    private static int importImgType = 0;
    /**
     * Normal crop color
     */
    private static int mNormalColor = 0xff5F95F5;
    /**
     * Abnormal crop color
     */
    private static int mErrorColor = 0xffff9500;
    /**
     * When cutting edge animation, the largest edge of temp bitmap
     */
    private static double sTrimAnimThumbMaxSize;
    protected final int PROCESS_FINISH = 1008;
    protected final int PROGRESS_STEP_CHANGED = 1007;
    /**
     * 拍照
     */
    private final int REQUEST_CAPTURE_PIC = 100;
    RelativeLayout mTakePhotoLayout;
    String outPutFilePath = null;// The path where the file is saved can be imported from outside
    String inPutFilePath = null;// Enter the path where the file is saved, which can be imported from outside. Type is IMPORT_FROM_FILEDIR
    int mEnhanceModeIndexExtra = -1;
    MagnifierView mMagnifierView;
    RelativeLayout ocr_scan_rel;
    ImageView ocr_scan_line;
    LinearLayout bt_toolbar_line, bt_process_line;
    TextView bt_process_comment_id;
    ProgressBar progress_horizontal;
    View mEnhanceModeBar;
    String mOriTrimImageEnchancePath;
    boolean boolClick = true;
    boolean isFullRegion = false;
    RotateBitmap bitmapRotate = null;
    Bitmap oriBitmap = null;
    TextView bt_addButton, bt_add_from_camera, gray_comment_id,
            gray_comment_idCrop;
    Bitmap bmmIVEnhance;
    ISImageEnhanceHandler mRawImageHandler;
    ScanRecordControl mScanRecordControl;
    String sPreStoreThumbPath = null;
    boolean mIsTrim = false;
    ImageProcessListener mImageProcessListener;
    /**
     * 生成相关增强模式的缩略图
     *
     * @param src
     */
    boolean isSmallScreen = true;
    boolean mIs7Tablet = false;
    /**
     * Used to display enhanced results,This view is used to show image enhance result
     */
    private ImageView mIVEnhance;
    /**
     *This view is used to show image crop result
     */
    private ImageEditView mIvEditView;
    /**
     * Crop layout
     */
    private View mTrimView;
    /**
     *  Enhance layout
     */
    private View mEnhanceView;

    private LinearLayout mBtnNext;
    private String mRootPath;
    private String mOriTrimImagePath;
    private String mOriTrimImagePathResult;
    /**
     *used to show the enhance model set
     */
    private Spinner mSpinner;
    private ScannerSDK mScannerSDK;
    /**
     * Compress image/source image
     */
    private float mScale = 1.0f;
    /**
     * Original enhance image
     */
    private Bitmap mOriginalEnhanceBitmap;
    /**
     *  Enhancing image
     */
    private Bitmap mEnhanceBitmap;
    /**
     * Current input image path
     */
    private String mCurrentInputImagePath;
    /**
     * Last detected border by engine
     */
    private int[] mLastDetectBorder;
    /**
     * Used for engine pointer, used to assist in detecting whether the trimming area is legal
     */
    private int mEngineContext;
    private int mCurOrientation;
    /**
     * Enhanced mode corresponding to the current picture automatic mode
     */
    private int mAutoMode;
    private boolean boolJudgeGrayOrColor = false;
    private String[] mModeNames = {"Auto", "Original", "Brighten", "Enhance and Sharpen", "Gray Mode", "Black and White"};

    private Handler mHandler = new Handler() {

        @Override
        public void handleMessage(Message msg) {

            if (msg.what != 0) {
                Log.d(TAG, "handleMessage: error msg.what != 0 for "+inPutFilePath);
                String loginfoString = CommonUtil.getPkgSigKeyLog(
                        ImageScannerActivity.this, APPKEY);
                Log.e("Init MSG:", loginfoString);
                Toast.makeText(ImageScannerActivity.this,
                        "Authorization failed" + "-->" + msg.what + "\n" + loginfoString,
                        Toast.LENGTH_LONG).show();
                boolClick = false;
                Intent data = new Intent();
                data.putExtra(EXTRA_KEY_RESULT_ERROR_CODE, msg.what);
                data.putExtra(EXTRA_KEY_RESULT_ERROR_MSG,
                        CommonUtil.commentMsg(msg.what));

                setResult(RESULT_CANCELED, data);
                ImageScannerActivity.this.finish();
            } else {
                if (importImgType == IMPORT_FROM_CAMERA ||importImgType == IMPORT_FROM_GALLERY || importImgType == IMPORT_FROM_FILEDIR) {
                    mOriTrimImagePath = inPutFilePath;

                    File file = new File(mOriTrimImagePath);
                    if (file.exists()) {
                        loadTrimImageFile(mOriTrimImagePath);
                    } else {
                        Toast.makeText(ImageScannerActivity.this, "The path of the input cut edge graph is incorrect",
                                Toast.LENGTH_LONG).show();
                    }

                }
            }

            super.handleMessage(msg);
        }

    };
    /**
     *Edge detection result, on the picture
     */
    private int[] mBitmapDetectBound;
    /**
     * Edge detection result, on the picture --- the last trimming point
     */
    private int[] mBitmapDetectBoundLast;
    /**
     * Display the detected edge in the view
     */
    private float[] mViewTtrimBound;
    private int mEnhanceMode = ScannerSDK.ENHANCE_MODE_AUTO;
    private ProgressDialog mProgressDialog;
    // **********************************Trimming effect*****START******************************************
    private double mTrimScale;
    /**
     * Whether the current text direction is valid, one of two conditions is met:
     * the text direction has been recognized initially and the user has rotated it;
     */
    private boolean mIsTextRotationValid;
    private boolean mIsNameCardMode;
    private int mRotation = 0;
    private int mEnRotation = 0;
    private int[] mCurrentThumbBounds, mCurrentFileBounds;
    private Bitmap mThumb;
    private Bitmap mEnhanceSource;
    private RotateBitmap mRotateBitmap;

    private Handler mHandlerAnim = new Handler() {
        @Override
        public void dispatchMessage(Message msg) {
            switch (msg.what) {

                case PROGRESS_STEP_CHANGED:
                    mThumb = (Bitmap) msg.obj;
                    // mProcessStepText.setText(msg.arg1);
                    progress_horizontal.setProgress(0);
                    mRotateBitmap.setBitmap(mThumb);
                    mRotateBitmap.setRotation(mRotation);
                    mIvEditView.setImageRotateBitmapResetBase(mRotateBitmap, false);
                    // RectF imgbound = new RectF(0, 0, mThumb.getWidth(),
                    // mThumb.getHeight());
                    // mIvEditView.getImageMatrix().mapRect(imgbound);
                    // mMagnifierView.setImage(mThumb, imgbound);
                    break;
                case PROGRESS_TRIM_INCREASE:
                    mThumb = (Bitmap) msg.obj;
                    progress_horizontal.setProgress(msg.arg1);
                    if (msg.arg1 > 70) {
                        bt_process_comment_id.setText(getResources().getString(
                                R.string.begin_enhance));

                        // "Enhancing...");

                    } else {
                        bt_process_comment_id.setText(getResources().getString(
                                R.string.begin_trim));

                    }
                    mRotateBitmap.setBitmap(mThumb);
                    mRotateBitmap.setRotation(mRotation);
                    mIvEditView.setImageRotateBitmapResetBase(mRotateBitmap, false);
                    // imgbound = new RectF(0, 0, mThumb.getWidth(),
                    // mThumb.getHeight());
                    // mIvEditView.getImageMatrix().mapRect(imgbound);
                    // mMagnifierView.setImage(mThumb, imgbound);
                    break;
                case PROGRESS_ENHANCE_INCREASE:
                    // mProgressBar.setProgress(msg.arg1);
                    // mIvEditView.setEnhanceProcess(msg.arg1);
                    break;

                default:
                    break;

            }
            super.dispatchMessage(msg);

        }
    };
    private ExecutorService mFixedThreadPool = null;
    /**
     * [Auto, original image, brighten, enhance and sharpen, grayscale, black and white, ink saving]
     */
    private Bitmap[] mEnhanceModeBitmap = new Bitmap[7];
    /**
     * true means ready to enhance the menu thumbnail, false means not ready to enhance the menu thumbnail
     */
    private boolean mFinishPrepareEnhanceMenuThumb = true;
    private int mEnhanceModeIndex = 0;

    /**
     * Get image size
     *
     * @param pathName
     * @param pathName
     * @return image size
     */
    private static int[] getImageSizeBound(String pathName) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        options.inSampleSize = 1;
        BitmapFactory.decodeFile(pathName, options);
        int[] wh = null;
        if (options.mCancel || options.outWidth == -1
                || options.outHeight == -1) {
            Log.d(TAG, "getImageBound error " + pathName);
        } else {
            wh = new int[2];
            wh[0] = options.outWidth;
            wh[1] = options.outHeight;
        }
        return wh;
    }

    /**
     * Adjust the trimming area to ensure that the trimming area is inside the picture
     *
     * @param size    Original image width and height
     * @param borders Detection boundary
     * @param size    : source image wide and high
     * @param borders : it's an int array of the 4 corner points
     * @return the new crop image area after the adjustment
     */
    private static float[] getScanBoundF(int[] size, int[] borders) {
        float[] bound = null;
        if (size != null) {
            if ((borders == null)) {
                Log.d(TAG, "did not found bound");
                bound = new float[]{0, 0, size[0], 0, size[0], size[1], 0,
                        size[1]};
            } else {
                bound = new float[8];
                for (int j = 0; j < bound.length; j++) {
                    bound[j] = borders[j];
                }
                for (int i = 0; i < 4; i++) {
                    if (bound[i * 2] < 0)// x
                        bound[i * 2] = 0;
                    if (bound[i * 2 + 1] < 0)// y
                        bound[i * 2 + 1] = 0;
                    if (bound[i * 2] > size[0])// x
                        bound[i * 2] = size[0];
                    if (bound[i * 2 + 1] > size[1])// y
                        bound[i * 2 + 1] = size[1];
                }
            }
        }
        return bound;
    }

    /**
     * Reclaim the image memory occupied by ImageView;
     *
     * @param view
     */
    public static void recycleImageView(View view) {
        if (view == null)
            return;
        if (view instanceof ImageView) {
            Drawable drawable = ((ImageView) view).getDrawable();
            if (drawable instanceof BitmapDrawable) {
                Bitmap bmp = ((BitmapDrawable) drawable).getBitmap();
                if (bmp != null && !bmp.isRecycled()) {
                    ((ImageView) view).setImageBitmap(null);
                    bmp.recycle();
                    bmp = null;
                }
            }
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);

        // getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
        // WindowManager.LayoutParams.FLAG_FULLSCREEN);

        setContentView(R.layout.ac_scanner);

        // Get external parameters

        Intent intent = getIntent();
        String appkeyString = intent.getStringExtra(EXTRA_KEY_APP_KEY);
        if (!TextUtils.isEmpty(appkeyString)) {
            APPKEY = appkeyString;
        }
        mNormalColor = intent
                .getIntExtra(EXTRA_TRIM_NORMAL_COLOR, mNormalColor);
        mErrorColor = intent.getIntExtra(EXTRA_TRIM_ERROR_COLOR, mErrorColor);

        importImgType = intent.getIntExtra(EXTRA_IMPORT_IMG_TYPE,
                IMPORT_FROM_CAMERA);// IMPORT_FROM_CAMERA 0

        outPutFilePath = intent.getStringExtra(EXTRA_KEY_RESULT_DATA_PATH);// Get the path of the returned image

        inPutFilePath = intent.getStringExtra(EXTRA_KEY_INPUTFILE_DATA_PATH);// Get the path of the trimmed image

        TRIM_IMAGE_MAXSIDE = intent.getIntExtra(EXTRA_TRIM_IMAGE_MAXSIDE,
                TRIM_IMAGE_MAXSIDE);
        boolJudgeGrayOrColor = intent.getBooleanExtra(
                EXTRA_KEY_JUDGE_GRAYORCOLOR, false);
        mEnhanceModeIndexExtra = intent.getIntExtra(
                EXTRA_KEY_ENHANCE_MODE_INDEX, -1);// Enhanced mode

        mRootPath = Environment.getExternalStorageDirectory().getAbsolutePath();
        mRootPath += File.separator + "intsig" + File.separator
                + "demo_imagescanner";
        mOriTrimImagePath = mRootPath + File.separator + "oriTrim.jpg";
        mOriTrimImageEnchancePath = mRootPath + File.separator
                + "oriTrimWaitEn.jpg";

        mOriTrimImagePathResult = outPutFilePath; //Set output processed file path

        File dir = new File(mRootPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        mScannerSDK = new ScannerSDK();

        new Thread(new Runnable() {

            @Override
            public void run() {
                int code = mScannerSDK.initSDK(ImageScannerActivity.this,
                        APPKEY);
                mEngineContext = mScannerSDK.initThreadContext();
                mHandler.sendEmptyMessage(code);
                Log.d(TAG, "code=" + code);
            }
        }).start();

        mBitmapDetectBound = new int[8];
        mViewTtrimBound = new float[8];
        mBitmapDetectBoundLast = new int[8];
        mCurOrientation = getResources().getConfiguration().orientation;
        mModeNames = getResources().getStringArray(R.array.arrays_enhance);

        initView();

    }


    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.cui_trim_rotate_right) {// Cut edge ---rotate right

            mRotation = (mRotation + 90);

            bitmapRotate = new RotateBitmap(oriBitmap, mRotation);

            mIvEditView.rotate(bitmapRotate, true);

            mBitmapDetectBound = mIvEditView.getRegion(false);
            for (int i = 0; i < mBitmapDetectBound.length; i++) {

                mViewTtrimBound[i] = mBitmapDetectBound[i];
            }

        } else if (viewId == R.id.cui_trim_totate_left) {// Cut edge ---rotate left
            if (mRotation == 0)
                mRotation = 360;
            mRotation = (mRotation - 90);
            bitmapRotate = new RotateBitmap(oriBitmap, mRotation);

            mIvEditView.rotate(bitmapRotate, true);
            mBitmapDetectBound = mIvEditView.getRegion(false);
            for (int i = 0; i < mBitmapDetectBound.length; i++) {

                mViewTtrimBound[i] = mBitmapDetectBound[i];
            }

        } else if (viewId == R.id.cui_trim_selectall) {//Edge trimming---select all trimming points/real trimming

            if (!isFullRegion) {
                mBitmapDetectBoundLast = mIvEditView.getRegion(false);

                mIvEditView.setFullRegion(mScale, null);
                isFullRegion = true;
            } else {
                isFullRegion = false;

                if (mBitmapDetectBoundLast != null) {
                    for (int i = 0; i < mBitmapDetectBoundLast.length; i++) {

                        mViewTtrimBound[i] = mBitmapDetectBoundLast[i];
                    }

                    mIvEditView.setRegion(mViewTtrimBound, mScale);

                }
            }
            mBitmapDetectBound = mIvEditView.getRegion(false);
            for (int i = 0; i < mBitmapDetectBound.length; i++) {

                mViewTtrimBound[i] = mBitmapDetectBound[i];
            }

        } else if (viewId == R.id.cui_enhance_left_line) {// Enhanced page---rotation

            mEnRotation = mEnRotation + 90;

            if (mEnRotation > 360)
                mEnRotation = 90;

            Log.d("mEnRotation", mEnRotation + "");
            // mOriginalEnhanceBitmap = reviewPicRotate(mOriginalEnhanceBitmap,
            // mEnRotation);
            //
            // mEnhanceBitmap = reviewPicRotate(mEnhanceBitmap, mEnRotation);
            // showIvEnhance(mEnhanceBitmap);
            EnhanceTask enhanceTask = new EnhanceTask(
                    getEnhanceMode(mEnhanceModeIndex));
            enhanceTask.execute();
        } else if (viewId == R.id.bt_back_add_line) {
            // enterAddImageLayout();
            setResult(RESULT_CANCELED);
            finish();

        } else if (viewId == R.id.bt_enhance) {
            // click 'next' button, and start trim
            if (mIvEditView.isCanTrim(mEngineContext)) {
                // startTtrim();
                startProcess();
            } else {
                Toast.makeText(ImageScannerActivity.this,
                        R.string.bound_trim_error, Toast.LENGTH_SHORT).show();
            }

        } else if (viewId == R.id.bt_back_trim_line) {// Return to the trimming view page
            // Bitmap bitmap = BitmapFactory.decodeFile(mOriTrimImagePath);

            int[] imgBound = getImageSizeBound(mOriTrimImagePath);

            mIvEditView.setRawImageBounds(imgBound);
            mIvEditView.loadDrawBitmap(oriBitmap);

            mIvEditView.setRegion(mViewTtrimBound, mScale);

            // set the crop are to be shown
            mIvEditView.setRegionVisibility(true);

            bitmapRotate = new RotateBitmap(oriBitmap, mRotation);

            mIvEditView.rotate(bitmapRotate, true);
            // Load the image
            enterTrimLayout();
            mMagnifierView.setVisibility(View.VISIBLE);

        } else if (viewId == R.id.cui_enhance_save_line) {

            mEnhanceView.setVisibility(View.GONE);
            mTrimView.setVisibility(View.VISIBLE);
            mMagnifierView.setVisibility(View.GONE);
            mMagnifierView.recycleAllBitmap();
            mMagnifierView.recycleBGBitmap();

            final String outputPath = saveBitmap2File(mEnhanceBitmap);

            Intent data = new Intent();
            data.putExtra(EXTRA_KEY_RESULT_DATA_PATH, outputPath);

            setResult(RESULT_OK, data);
            finish();

        }
    }

    @Override
    public void onItemSelected(AdapterView<?> parent, View view, int position,
                               long id) {
        Log.d(TAG, "position=" + position);
        if (mOriginalEnhanceBitmap != null) {
            EnhanceTask enhanceTask = new EnhanceTask(getEnhanceMode(position));
            enhanceTask.execute();
        } else {
            Log.d(TAG, "mOriginalEnhanceBitmap=" + mOriginalEnhanceBitmap);
        }
    }

    @Override
    public void onNothingSelected(AdapterView<?> parent) {
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == RESULT_OK) {
            if (requestCode == REQ_CODE_GALLERY_IMPORT) {

                // hide the previous result
                mIvEditView.setRegionVisibility(false);

                progressExportImage(data);
            }
            if (requestCode == REQUEST_CAPTURE_PIC) {// Taken back

                loadTrimImageFile(mOriTrimImagePath);

            }
        } else {
            setResult(RESULT_CANCELED);
            finish();
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();

        if (mEngineContext != 0 && mScannerSDK != null) {
            mScannerSDK.destroyContext(mEngineContext);
        }
        if (mOriginalEnhanceBitmap != null
                && !mOriginalEnhanceBitmap.isRecycled()) {
            mOriginalEnhanceBitmap.recycle();
            mOriginalEnhanceBitmap = null;
        }
        if (mEnhanceBitmap != null && !mEnhanceBitmap.isRecycled()) {
            mEnhanceBitmap.recycle();
            mEnhanceBitmap = null;
        }
        if (mThumb != null && !mThumb.isRecycled()) {
            mThumb.recycle();
            mThumb = null;
        }
        if (mEnhanceSource != null && !mEnhanceSource.isRecycled()) {
            mEnhanceSource.recycle();
            mEnhanceSource = null;
        }
        releaseModeThumb();
        if (mRawImageHandler != null) {

            mRawImageHandler.setEngineContext(0);
            mRawImageHandler = null;
            ISImageEnhanceHandler.releaseInstace();
        }
        if (mFixedThreadPool != null) {
            mFixedThreadPool.shutdown();
            mFixedThreadPool = null;
        }
        if (oriBitmap != null) {
            oriBitmap.recycle();
            oriBitmap = null;
        }
        if (mProgressDialog != null) {
            mProgressDialog.dismiss();
            mProgressDialog = null;
        }
        if (mRotateBitmap != null) {
            mRotateBitmap.recycle();
            mRotateBitmap = null;
        }
        if (bitmapRotate != null) {
            bitmapRotate.recycle();
            bitmapRotate = null;
        }

        if (mIvEditView != null) {

            mIvEditView = null;
        }
        if (mMagnifierView != null) {
            mMagnifierView.setVisibility(View.GONE);
            mMagnifierView.recycleAllBitmap();

            mMagnifierView = null;
        }

        if (mIVEnhance != null) {

            recycleImageView(mIVEnhance);

        }
        if (bmmIVEnhance != null && !bmmIVEnhance.isRecycled()) {
            bmmIVEnhance.recycle();
            bmmIVEnhance = null;
        }
        mHandler = null;
        bt_addButton = null;
        bt_add_from_camera = null;

        mBitmapDetectBound = null;
        mBitmapDetectBoundLast = null;
        mViewTtrimBound = null;
        mRawImageHandler = null;
        mScanRecordControl = null;
        mThumb = null;
        mEnhanceSource = null;
        mImageProcessListener = null;
        mIVEnhance = null;
        mTrimView = null;
        mEnhanceView = null;
        mBtnNext = null;
        mSpinner = null;

        System.gc();

    }

    private void initView() {

        mTrimView = findViewById(R.id.rl_trim);
        mEnhanceView = findViewById(R.id.ll_enhance);
        mIvEditView = findViewById(R.id.iv_trim);
        gray_comment_id = findViewById(R.id.gray_comment_id);
        gray_comment_idCrop = findViewById(R.id.gray_comment_id2);
        if (boolJudgeGrayOrColor) {
            gray_comment_id.setVisibility(View.VISIBLE);
            gray_comment_idCrop.setVisibility(View.VISIBLE);

        } else {
            gray_comment_id.setVisibility(View.GONE);
            gray_comment_idCrop.setVisibility(View.GONE);

        }

        mIvEditView.setDrapPoint(R.drawable.dragpoint);
        mIvEditView.setRegionVisibility(false);
        mIvEditView.setOnCornorChangeListener(new MyCornerChangeListener());
        mIvEditView.setOffset(getResources().getDimension(
                R.dimen.highlight_point_diameter));

        // findViewById(R.id.bt_back_add).setOnClickListener(this);
        findViewById(R.id.take_photo_id).setOnClickListener(this);
        findViewById(R.id.close_photo_id).setOnClickListener(this);
        findViewById(R.id.bt_back_add_line).setOnClickListener(this);

        mBtnNext = findViewById(R.id.bt_enhance);
        mBtnNext.setOnClickListener(this);

        findViewById(R.id.cui_trim_rotate_right).setOnClickListener(this);
        findViewById(R.id.cui_trim_totate_left).setOnClickListener(this);
        findViewById(R.id.cui_trim_selectall).setOnClickListener(this);

        // findViewById(R.id.bt_back_trim).setOnClickListener(this);
        findViewById(R.id.bt_back_trim_line).setOnClickListener(this);

        findViewById(R.id.cui_enhance_save_line).setOnClickListener(this);

        findViewById(R.id.cui_enhance_left_line).setOnClickListener(this);

        bt_toolbar_line = findViewById(R.id.bt_toolbar_line);
        bt_process_line = findViewById(R.id.bt_process_line);
        progress_horizontal = findViewById(R.id.progress_horizontal);
        bt_process_comment_id = findViewById(R.id.bt_process_comment_id);

        mIVEnhance = findViewById(R.id.iv_enhance);

        mEnhanceModeBar = findViewById(R.id.iv_enhance_groupbar);

        ocr_scan_rel = findViewById(R.id.ocr_scan_rel);

        ocr_scan_line = findViewById(R.id.ocr_scan_line);
        mMagnifierView = findViewById(R.id.magnifier_view);

    }


    /**
     * Enter the crop image layout
     */
    public void enterTrimLayout() {
       runOnUiThread(new Runnable() {
           @Override
           public void run() {
               mEnhanceView.setVisibility(View.GONE);
               mTrimView.setVisibility(View.VISIBLE);
           }
       });
    }

    /**
     * Enter the enhance image layout
     */
    public void enterEnhanceLayout() {
        if (mSpinner == null) {
            mSpinner = findViewById(R.id.sp_enhance_mode);
            ArrayAdapter<CharSequence> adapter = ArrayAdapter
                    .createFromResource(ImageScannerActivity.this,
                            R.array.arrays_enhance,
                            R.layout.spinner_checked_text);
            adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
            mSpinner.setAdapter(adapter);
            mSpinner.setOnItemSelectedListener(ImageScannerActivity.this);
        }

        mEnhanceView.setVisibility(View.VISIBLE);
        mTrimView.setVisibility(View.GONE);

        showIvEnhance(mOriginalEnhanceBitmap);
    }

    public void showIvEnhance(Bitmap morBitmap) {

        Matrix matrix = new Matrix();
        float scaleFloat = 0.5f;
        int w = morBitmap.getWidth();
        int h = morBitmap.getHeight();

        float maxwh = w > h ? w : h;
        scaleFloat = 1200 / maxwh;
        Log.d("test", maxwh + ",scaleFloat:" + scaleFloat);
        scaleFloat = scaleFloat > 1 ? 1 : scaleFloat;

        matrix.setScale(scaleFloat, scaleFloat);
        bmmIVEnhance = Bitmap.createBitmap(morBitmap, 0, 0,
                morBitmap.getWidth(), morBitmap.getHeight(), matrix, true);
        Log.i("bmmIVEnhance",
                "Image size after compression"
                        + (bmmIVEnhance.getAllocationByteCount() / 1024 / 1024)
                        + "MWidth is" + bmmIVEnhance.getWidth() + "Height is"
                        + bmmIVEnhance.getHeight());

        mIVEnhance.setImageBitmap(bmmIVEnhance);

    }

    public void changeBitmap(String mOriTrimImagePathResult) {
        File file = new File(mOriTrimImagePathResult);
        Log.i("mOriTrimImagePathResult", "The map's address：" + file.length());
        if (file.exists()) {
            Bitmap trimBitmap = null;
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile(mOriTrimImagePathResult, options);
            int bitmapWidth = options.outWidth;
            int bitmapHeight = options.outHeight;
            Log.d(TAG, "bitmapWidth=" + bitmapWidth + " bitmapHeight="
                    + bitmapHeight);
            if (bitmapWidth > 0 && bitmapHeight > 0) {
                int viewWidth = mIvEditView.getWidth();
                int viewHeight = mIvEditView.getHeight();
                float scaleX = 1.0f * viewWidth / bitmapWidth;
                float scaleY = 1.0f * viewHeight / bitmapHeight;

                Log.i("testBitmap", "viewWidth:" + viewWidth + "viewHeight"
                        + viewHeight + "bitmapWidth" + bitmapWidth
                        + "bitmapHeight：" + bitmapHeight);
                float scale = scaleX > scaleY ? scaleY : scaleX;
                if (scale >= 0.5 && scale < 1)
                    scale = 0.5f;

                int inSampleSize = (int) (1 / scale);
                if (inSampleSize == 0) {
                    inSampleSize = 1;
                }
                options.inJustDecodeBounds = false;

                // if (bitmapHeight >=2400 || bitmapWidth >= 2400) {
                options.inSampleSize = inSampleSize;
                options.inPreferredConfig = Config.RGB_565;
                // }else if(bitmapHeight >= 1600 || bitmapWidth >= 1600){
                // options.inPreferredConfig = Bitmap.Config.ARGB_8888;
                // }
                // options.inPreferredConfig = Bitmap.Config.RGB_565;
                trimBitmap = BitmapFactory.decodeFile(mOriTrimImagePathResult,
                        options);

                Log.i("changeBitmap",
                        "The size of the compressed image"
                                + (trimBitmap.getAllocationByteCount() / 1024 / 1024)
                                + "M width is" + trimBitmap.getWidth() + "Height is"
                                + trimBitmap.getHeight() + "inSampleSize："
                                + inSampleSize);
            }
            // Generate enhanced pictures before recycling
            if (mOriginalEnhanceBitmap != null
                    && !mOriginalEnhanceBitmap.isRecycled()) {
                mOriginalEnhanceBitmap.recycle();
            }
            // trimBitmap = reviewPicRotate(trimBitmap, mRotation);

            mOriginalEnhanceBitmap = trimBitmap;
        }
    }

    public Bitmap reviewPicRotate(Bitmap bitmap, int degree) {
        if (degree != 0) {
            Matrix m = new Matrix();
            int width = bitmap.getWidth();
            int height = bitmap.getHeight();
            m.setRotate(degree); //Rotation angle degree
            bitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height, m, true);// Regenerate image
        }
        return bitmap;
    }

    /**
     *  Start to crop the image
     */
    private void startTtrim() {
        if (TextUtils.isEmpty(mOriTrimImagePath)) {
            return;
        }

        if (!TextUtils.isEmpty(mCurrentInputImagePath)) {
            TrimTask trimTask = new TrimTask(mCurrentInputImagePath);
            trimTask.execute();
        }
    }

    /**
     * Start trimming thread
     */
    private void startProcess() {
        getTrimRegions();
        TrimAnimTask task = new TrimAnimTask();
        task.execute();
    }

    /**
     * get enhance mode
     *
     * @param which
     *              get enhance mode
     *              <p>
     *              <pre>
     *                  0: Auto
     *                  1：No enhance
     *                  2：Enhance
     *                  3：Enhance and Magic
     *                  4：Gray
     *                  5：Black-and-White
     *              </pre>
     */
    public int getEnhanceMode(int which) {
        int mode = ScannerSDK.ENHANCE_MODE_AUTO;
        switch (which) {
            case 1:
                // Auto
                mode = ScannerSDK.ENHANCE_MODE_AUTO;
                break;
            case 0:
                // No Enhance
                mode = ScannerSDK.ENHANCE_MODE_NO_ENHANCE;
                break;
            case 2:
                // Enhance
                mode = ScannerSDK.ENHANCE_MODE_LINEAR;
                break;
            case 3:
                // Enhance and Magic
                mode = ScannerSDK.ENHANCE_MODE_MAGIC;
                break;
            case 4:
                // Gray
                mode = ScannerSDK.ENHANCE_MODE_GRAY;
                break;
            case 5:
                // Black-and-White
                mode = ScannerSDK.ENHANCE_MODE_BLACK_WHITE;
                break;
            default:
                mode = ScannerSDK.ENHANCE_MODE_NO_ENHANCE;
        }
        return mode;
    }

    @Override
    public void onBackPressed() {
        // TODO Auto-generated method stub
        super.onBackPressed();

    }

    private void showProgressDialog() {
        if (mProgressDialog == null) {
            mProgressDialog = new ProgressDialog(ImageScannerActivity.this);
            mProgressDialog.setProgress(ProgressDialog.STYLE_SPINNER);
            mProgressDialog.setMessage(getResources().getString(
                    R.string.a_msg_working));
        }
        mProgressDialog.show();
    }

    public void dismissProgressDialog() {
        if (mProgressDialog != null) {
            mProgressDialog.dismiss();
        }
    }

    /**
     * save Picture
     *
     * @param src Save the result image--cropped and enhanced
     */
    public String saveBitmap2File(Bitmap src) {

        // if (TextUtils.isEmpty(outPutFilePath)) {
        // outPutFilePath = mRootPath + File.separator
        // + sPdfTime.format(new Date()) + ".jpg";
        // } else {
        // Utils.createFile(outPutFilePath);
        // }
        // FileOutputStream outPutStream = null;
        // try {
        // outPutStream = new FileOutputStream(outPutFilePath);
        // src.compress(Bitmap.CompressFormat.JPEG, TRIM_IMAGE_SAVELOCALSIDE,
        // outPutStream);
        // } catch (FileNotFoundException e) {
        // Log.e(TAG, "FileNotFoundException", e);
        //
        // } finally {
        // if (outPutStream != null) {
        // try {
        // outPutStream.close();
        // } catch (IOException e) {
        // Log.e(TAG, "IOException", e);
        // }
        // }
        // if (src != null && !src.isRecycled()) {
        // src.recycle();
        // src = null;
        // }
        // }
        Log.d(TAG, "saveBitmap2File, outPutFilePath=" + outPutFilePath);
        return mOriTrimImagePathResult;
    }

    /**
     * Determine whether the picture is legal, png or jpg is a legal picture
     *
     * @param path image path
     * @return true image is valid
     * <p>
     * Whether the image is valid or not, only support .png and .jpg
     */
    public boolean isValidImage(String path) {
        return !TextUtils.isEmpty(path)
                && (path.endsWith("png") || path.endsWith("jpg"));
    }

    /**
     * Process imported pictures
     *
     * @param data Process the input image
     */
    private void progressExportImage(Intent data) {
        if (data != null) {
            Uri u = data.getData();
            Log.d(TAG, "data.getData()=" + u);
            if (u != null) {
                String path = DocumentUtil.getInstance().getPath(this, u);
                if (isValidImage(path)) {
                    loadTrimImageFile(path);

                    // mOriTrimImagePath=path;
                    // oriBitmap= loadBitmap(mOriTrimImagePath);
                    //
                    // loadTrimImageBitmap(oriBitmap);
                } else {
                    Toast.makeText(this, R.string.a_msg_illegal,
                            Toast.LENGTH_SHORT).show();
                }
            }
        } else {
            Log.d(TAG, "data==null");
        }
    }

    private void loadTrimImageFile(final String imageFilePath) {
        Log.d(TAG, "loadTrimImageFile: trim intit");
        if (TextUtils.isEmpty(imageFilePath)) {
            Log.d(TAG, "imageFilePath is empty");
            return;
        }
        File file = new File(imageFilePath);
        if (!file.exists()) {
            Log.d(TAG, "imageFilePath is not exist");
            return;
        }

        Log.d(TAG, "loadTrimImageFile, imageFilePath=" + imageFilePath);
        enterTrimLayout();
        mIvEditView.post(new Runnable() {

            @Override
            public void run() {

                // to prevent out of memory error when the image is too large,
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile(imageFilePath, options);
                int bitmapWidth = options.outWidth;
                int bitmapHeight = options.outHeight;
                Log.d(TAG, "bitmapWidth=" + bitmapWidth + " bitmapHeight="
                        + bitmapHeight);
                if (bitmapWidth > 0 && bitmapHeight > 0) {
                    int viewWidth = mIvEditView.getWidth();
                    int viewHeight = mIvEditView.getHeight();

                    if (viewHeight == 0 || viewWidth == 0) {
                        viewWidth = 1080;
                        viewHeight = 1920;
                    }
                    if (viewWidth > 0 && viewHeight > 0) {
                        float scaleX = 1.0f * viewWidth / bitmapWidth;
                        float scaleY = 1.0f * viewHeight / bitmapHeight;
                        float scale = scaleX > scaleY ? scaleY : scaleX;
                        int inSampleSize = (int) (1 / scale);
                        if (inSampleSize == 0) {
                            inSampleSize = 1;
                        }
                        options.inSampleSize = inSampleSize;
                        // inSampleSizeAll = inSampleSize;

                        Log.d("inSampleSize:", inSampleSize + "");
                        options.inJustDecodeBounds = false;
                        Bitmap testBitmap = BitmapFactory.decodeFile(
                                imageFilePath, options);

                        mScale = 1.0f * testBitmap.getWidth() / bitmapWidth;
                        Log.i("testBitmap",
                                "Image size after compression"
                                        + (testBitmap.getAllocationByteCount() / 1024 / 1024)
                                        + "MWidth is" + testBitmap.getWidth()
                                        + "Height is" + testBitmap.getHeight()
                                        + "mScale:" + mScale);
                        int[] imgBound = new int[]{bitmapWidth, bitmapHeight};//The width and height of the original image
                        // Set the source image wide and high
                        mIvEditView.setRawImageBounds(imgBound);//Set the width and height of the original image

                        // Load the image
                        mIvEditView.loadDrawBitmap(testBitmap);// Set the size of the displayed picture

                        RectF imgbound = new RectF(0, 0, testBitmap.getWidth(),
                                testBitmap.getHeight());

                        oriBitmap = testBitmap;
                        mIvEditView.getImageMatrix().mapRect(imgbound);
                        setMagnifierView(testBitmap, imgbound);

                        mCurrentInputImagePath = imageFilePath;
                        DetectBorderTask detectTask = new DetectBorderTask(
                                imageFilePath);
                        detectTask.execute();
                    }

                } else {
                    Log.d(TAG, "bitmapWidth=" + bitmapWidth + " bitmapHeight="
                            + bitmapHeight);
                }

            }
        });
    }

    public void setMagnifierView(Bitmap testBitmap, RectF imgbound) {
        Bitmap mBg = BitmapFactory.decodeResource(getResources(),
                R.drawable.ic_done);

        float RADIUS = getResources().getDimension(R.dimen.magnifier_radius);
        float BOTTOM_HEIGHT = getResources().getDimension(
                R.dimen.dock_bar_height);

        mMagnifierView.setImage(testBitmap, imgbound, RADIUS, BOTTOM_HEIGHT,
                mBg);
    }

    public void updateMagnifierView(float x, float y) {
        mMagnifierView.setVisibility(View.VISIBLE);

        mMagnifierView.update(x, y, mRotation, mIvEditView.getImageMatrix());

    }

    public void dismissMagnifierView() {
        if (mMagnifierView != null) {
            mMagnifierView.setVisibility(View.GONE);
            mMagnifierView.dismiss();
            mMagnifierView.recycleBGBitmap();
        }
    }

    public void changeDisplayAndSide() {
        StringBuffer sb = new StringBuffer(1024);
        DisplayMetrics outMetrics = new DisplayMetrics();
        WindowManager wm = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
        wm.getDefaultDisplay().getMetrics(outMetrics);
        int minLen = Math.min(outMetrics.heightPixels, outMetrics.widthPixels);
        int maxLen = Math.max(outMetrics.heightPixels, outMetrics.widthPixels);
        minLen = Math.max(minLen, 960);
        maxLen = Math.max(maxLen, 1280);
        float ratio = maxLen * maxLen * 4 * 3 * 100.0f
                / Runtime.getRuntime().maxMemory();
        sb.append("\nRatio(New):").append(String.format("%.3f%%", ratio));
        if (ratio > 25) {
            final int offset = 50;
            if (ratio > 35) {
                maxLen -= (offset * (outMetrics.density + 2));
            } else if (ratio > 30) {
                maxLen -= (offset * (outMetrics.density + 1));
            } else if (ratio > 25) {
                maxLen -= (offset * outMetrics.density);
            }
            ratio = maxLen * maxLen * 4 * 3 * 100.0f
                    / Runtime.getRuntime().maxMemory();
        }
        ratio = 1280 * 960 * 4 * 3 * 100.0f / Runtime.getRuntime().maxMemory();
        MIN_SIDE_LENGTH = minLen;// Take the smallest side of the screen, the largest does not exceed 960
        MAX_DISPLAY_WIDTH = maxLen;//Take the largest side of the screen, the maximum does not exceed 1280

    }

    private void getTrimRegions() {
        if (mIvEditView.isRegionVisible()) {
            mCurrentThumbBounds = mIvEditView.getRegion(true);
            mCurrentFileBounds = mIvEditView.getRegion(false);
        } else {
            Log.d(TAG,
                    "getTrimRegions while mImageView.isRegionAvailable() = false");
        }
        changeDisplayAndSide();
        Config config = null;
        if (config == null) {
            config = getDefaultConfig();
        }
        mThumb = Utils.loadBitmap(mCurrentInputImagePath, MIN_SIDE_LENGTH,
                MIN_SIDE_LENGTH * MAX_DISPLAY_WIDTH, config, false,
                mCurrentFileBounds);


        for (int i = 0; i < mCurrentThumbBounds.length; i++) {
            mCurrentThumbBounds[i] = mCurrentFileBounds[i];

        }

        mRotateBitmap = new RotateBitmap(mThumb, mRotation);

        sTrimAnimThumbMaxSize = mThumb.getWidth() / 2;
        if (sTrimAnimThumbMaxSize < 400) {
            sTrimAnimThumbMaxSize = 400;
        }

        mRawImageHandler = ISImageEnhanceHandler.newInstance(
                getApplicationContext(), mHandlerAnim, mScannerSDK);
        //Save thumb
        sPreStoreThumbPath = mRootPath + File.separator + "pretempthumb.jpg";

        storeThumbToFile(sPreStoreThumbPath);

        //Set image, thumb path
        mRawImageHandler.setImagePath(mCurrentInputImagePath,
                sPreStoreThumbPath);
        mRawImageHandler.setEngineContext(mEngineContext);

        mScanRecordControl = ScanRecordControl
                .getInstance(getApplicationContext());
        if (!mScanRecordControl.isScannFinishNormal()
                && (new File(mScanRecordControl.getImageRawPath()).exists())) {
            mScanRecordControl.setCrashedImageFound(true);
        }

    }

    /**
     * Save {@link ImageScannerActivity#mThumb} to the path
     *
     * @param path thumb saved path
     */
    private void storeThumbToFile(String path) {
        try {
            FileOutputStream out = new FileOutputStream(path);
            mThumb.compress(Bitmap.CompressFormat.JPEG, 100, out);
            out.close();
        } catch (Exception e) {
            Log.d(TAG, e.getMessage());
        }
        Log.d(TAG, "storeThumbToFile： " + path);
    }

    /**
     * Copy the bitmap and scale it so that the maximum width and height does not exceed
     * {@link ImageScannerActivity#sTrimAnimThumbMaxSize}
     * <p>
     * <p>
     * For creating animations-small pictures
     *
     * @param src small picture, bitmap currently displayed on the screen
     * @return small picture, used for trimming animation
     */
    private Bitmap copySmallBitmap(Bitmap src) {
        Bitmap dst = null;
        if (src != null) {
            Config config = src.getConfig();
            if (config == null) {
                config = getDefaultConfig();
            }
            try {
                double scale = Math.min(sTrimAnimThumbMaxSize / src.getWidth(),
                        sTrimAnimThumbMaxSize / src.getHeight());
                mTrimScale = scale;
                dst = Bitmap.createScaledBitmap(src,
                        (int) (src.getWidth() * scale),
                        (int) (src.getHeight() * scale), true);
                Log.d(TAG,
                        "ori w,h = " + src.getWidth() + ", " + src.getHeight()
                                + "; dst w,h = "
                                + (int) (src.getWidth() * scale) + ", "
                                + (int) (src.getHeight() * scale)
                                + ", mTrimScale = " + mTrimScale);
                // dst = src.copy(config, true);
            } catch (OutOfMemoryError e) {
                Log.d(TAG, "copyBitmap", e);
                System.gc();
            }
        }
        return dst;
    }

    public Config getDefaultConfig() {
        ActivityManager am = (ActivityManager) getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo memInfo = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(memInfo);
        Runtime runtime = Runtime.getRuntime();

        long PROCESS_MEMORY_LIMIT = runtime.maxMemory();
        Config DEFAULT_BITMAP_CONFIG;
        boolean boolavailMem = memInfo.availMem >= (48 * 1024 * 1024);
        boolean boollimit = PROCESS_MEMORY_LIMIT >= 48 * 1024 * 1024;

        if (boolavailMem && boollimit) {
            DEFAULT_BITMAP_CONFIG = Config.ARGB_8888;
        } else {
            DEFAULT_BITMAP_CONFIG = Config.RGB_565;
        }
        return DEFAULT_BITMAP_CONFIG;
    }

    public Bitmap copyBitmap(Bitmap src, Config config) {
        Bitmap dst = null;
        if (src != null) {

            try {
                if (config == null) {
                    config = src.getConfig();
                }
                if (config == null) {
                    config = getDefaultConfig();
                }

                dst = src.copy(config, true);

            } catch (OutOfMemoryError e) {
                Log.d(TAG, "copyBitmap", e);
                System.gc();
            }
        }
        return dst;
    }
    // ********************************Enhanced map*******************

    public void recycleBitmap(Bitmap bitmapRec) {
        if (bitmapRec != null && !bitmapRec.isRecycled()) {
            bitmapRec.recycle();
        }
    }

    private void releaseModeThumb() {
        if (mEnhanceModeBitmap != null) {
            for (int index = 0; index < mEnhanceModeBitmap.length; index++) {
                if (mEnhanceModeBitmap[index] != null
                        && !mEnhanceModeBitmap[index].isRecycled()) {
                    mEnhanceModeBitmap[index].recycle();
                    mEnhanceModeBitmap[index] = null;
                }
            }
        }
    }

    private Bitmap getEnhanceSourceCopyBitmap(Config config) {
        Bitmap result = null;
        result = copyBitmap(mEnhanceSource, config);
        return result;
    }

    /**
     * Get the item thumbnail size of the enhanced mode menu
     *
     * @param thumbWidth
     * @param thumbHeight
     * @param rotation
     * @return
     */
    private int[] getEnhanceMenuThumbSize(int thumbWidth, int thumbHeight,
                                          int rotation) {
        int[] size = new int[2];
        if (thumbWidth <= 0) {
            thumbWidth = WIDTH;
        }
        if (thumbHeight <= 0) {
            thumbHeight = HEIGHT;
        }
        if (rotation == 90 || rotation == 270) {
            int temp = thumbWidth;
            thumbWidth = thumbHeight;
            thumbHeight = temp;
        }
        size[0] = thumbWidth;
        size[1] = thumbHeight;
        return size;
    }

    /**
     * The size of each mode menu item of the phone
     *
     * @return [width, height]
     */
    private int[] getPhoneEnhanceMenuSize() {
        int[] size = new int[2];
        size[0] = (int) (mIvEditView.getWidth() / 4.5f);
        size[1] = getResources().getDimensionPixelSize(
                R.dimen.enhance_menu_height);
        return size;
    }

    /**
     * 7 inch size of each mode menu item
     * @return [width, height]
     */
    private int[] get7TabletEnhanceMenuSize() {
        int[] size = new int[2];
        size[0] = mIvEditView.getWidth() / 6;
        if (mCurOrientation == Configuration.ORIENTATION_LANDSCAPE) {
            size[1] = getResources().getDimensionPixelSize(
                    R.dimen.enhance_menu_height);
        } else if (mCurOrientation == Configuration.ORIENTATION_PORTRAIT) {
            size[1] = getResources().getDimensionPixelSize(
                    R.dimen.enhance_menu_height_7tablet_portrait);
        }
        return size;
    }

    /**
     * 10 inch size of each mode menu item
     *
     * @return[width, height]
     */
    private int[] get10TabletEnhanceMenuSize() {
        int[] size = new int[2];
        if (mCurOrientation == Configuration.ORIENTATION_LANDSCAPE) {
            size[0] = getResources().getDimensionPixelSize(
                    R.dimen.pad_image_scan_gridview_item_width);
            size[1] = mIvEditView.getHeight() / 6;
        } else if (mCurOrientation == Configuration.ORIENTATION_PORTRAIT) {
            size[0] = mIvEditView.getWidth() / 6;
            size[1] = getResources().getDimensionPixelSize(
                    R.dimen.pad_image_scan_gridview_item_height);
        }
        return size;
    }

    /**
     * For a 7-inch tablet, the height of the mode menu in portrait mode is higher than in landscape mode
     */
    private void adust7TabletEnhanceMenuHeight() {
        int[] size = get7TabletEnhanceMenuSize();
        if (size[1] > 0) {
            ViewGroup.LayoutParams params = mEnhanceModeBar.getLayoutParams();
            params.height = size[1];
            mEnhanceModeBar.setLayoutParams(params);
        }
    }

    private void handleModeMenuThumb(Bitmap src) {
        mFinishPrepareEnhanceMenuThumb = false;
        if (mFixedThreadPool == null) {
            int numberProcessors = 1;
            if (Runtime.getRuntime().availableProcessors() > 2) {
                // Limit no more than 2 threads to prevent processing multiple images at the same time
                numberProcessors = 2;
            }
            mFixedThreadPool = Executors.newFixedThreadPool(numberProcessors);
        }
        int engineContext = ScannerEngine.initThreadContext();
        int[] size = ScannerEngine.nativeDewarpImagePlaneForSize(engineContext,
                src.getWidth(), src.getHeight(), mCurrentThumbBounds);
        ScannerEngine.destroyThreadContext(engineContext);
        int[] menuSize = null;
        int[] thumbSize = null;
        // int margin=10;
        int margin = getResources().getDimensionPixelSize(
                R.dimen.enhance_menu_margin);
        if ((isSmallScreen && !mIs7Tablet)) {
            // Cell phone
            menuSize = getPhoneEnhanceMenuSize();
            menuSize[0] = menuSize[0] - margin - margin;
            thumbSize = getEnhanceMenuThumbSize(menuSize[0], menuSize[1],
                    mRotation);
        } else if (mIs7Tablet) {
            // 7 inch tablet
            menuSize = get7TabletEnhanceMenuSize();
            menuSize[0] = menuSize[0] - margin - margin;
            menuSize[1] = menuSize[1] - margin - margin;
            thumbSize = getEnhanceMenuThumbSize(menuSize[0], menuSize[1],
                    mRotation);
        } else {
            menuSize = get10TabletEnhanceMenuSize();
            menuSize[0] = menuSize[0] - margin - margin;
            menuSize[1] = menuSize[1] - margin - margin;
            thumbSize = getEnhanceMenuThumbSize(menuSize[0], menuSize[1],
                    mRotation);
        }

        final Bitmap rawThumb = getCentreCropScaleBitmap(src, thumbSize[0],
                thumbSize[1], size);
        // new Thread(new Runnable() {
        // @Override
        // public void run() {
        long startTime = System.currentTimeMillis();
        Future<Bitmap> autoFuture = mFixedThreadPool
                .submit(new EnhanceCallable(rawThumb, mAutoMode));
        Future<Bitmap> linerFuture = mFixedThreadPool
                .submit(new EnhanceCallable(rawThumb,
                        ScannerSDK.ENHANCE_MODE_LINEAR));
        Future<Bitmap> magicFuture = mFixedThreadPool
                .submit(new EnhanceCallable(rawThumb,
                        ScannerSDK.ENHANCE_MODE_MAGIC));
        Future<Bitmap> grayFuture = mFixedThreadPool
                .submit(new EnhanceCallable(rawThumb,
                        ScannerSDK.ENHANCE_MODE_GRAY));
        Future<Bitmap> blackWhiteFuture = mFixedThreadPool
                .submit(new EnhanceCallable(rawThumb,
                        ScannerSDK.ENHANCE_MODE_BLACK_WHITE));
        // Future<Bitmap> whiteBlackFuture = mFixedThreadPool.submit(new
        // EnhanceCallable(rawThumb, ScannerSDK.ENHANCE_MODE_WHITE_BLACK ));
        try {
            // Future's get() method is blocking
            mEnhanceModeBitmap[1] = autoFuture.get();// automatic
            mEnhanceModeBitmap[0] = rawThumb;// Original image
            mEnhanceModeBitmap[2] = linerFuture.get();// Brighten
            mEnhanceModeBitmap[3] = magicFuture.get();// Enhance and sharpen
            mEnhanceModeBitmap[4] = grayFuture.get();// Grayscale
            mEnhanceModeBitmap[5] = blackWhiteFuture.get();// Black and white
            // mEnhanceModeBitmap[6] = whiteBlackFuture.get();/Save ink
        } catch (InterruptedException e) {
            Log.d(TAG, "InterruptedException msg=" + e.getMessage());
        } catch (ExecutionException e) {
            Log.d(TAG, "ExecutionException msg=" + e.getMessage());
        }
        boolean findNumThumb = false;
        for (int index = 0; index < mEnhanceModeBitmap.length; index++) {
            if (mEnhanceModeBitmap[index] == null) {
                findNumThumb = true;
                break;
            }
        }
        if (!findNumThumb) {
            mFinishPrepareEnhanceMenuThumb = true;
        }
        Log.d(TAG, "handleModeMenuThumb Time="
                + (System.currentTimeMillis() - startTime));
    }

    private Bitmap getCentreCropScaleBitmap(Bitmap src, int viewWidth,
                                            int viewHeight, int[] trimSize) {
        Bitmap dstBitmap = null;
        if (src != null && viewWidth > 0 && viewHeight > 0) {
            int left = 0;
            int top = 0;
            int cropWidth = 0;
            int cropHeght = 0;
            float imageScale;
            float srcScale = 1.0f * src.getWidth() / src.getHeight();
            if (trimSize != null && trimSize[0] > 0 && trimSize[1] > 0) {
                imageScale = 1.0f * trimSize[0] / trimSize[1];
                if (srcScale > imageScale) {
                    cropHeght = src.getHeight();
                    cropWidth = (int) (imageScale * cropHeght);
                } else {
                    cropWidth = src.getWidth();
                    cropHeght = (int) (cropWidth / imageScale);
                }
            } else {
                imageScale = srcScale;
                cropHeght = src.getHeight();
                cropWidth = src.getWidth();
            }

            float viewScale = 1.0f * viewWidth / viewHeight;
            float scale = 1.0f;
            if (Math.abs(viewScale - imageScale) > 0.001) {
                if (viewScale > imageScale) {
                    scale = viewWidth / (float) cropWidth;
                    cropHeght = (int) (cropWidth / viewScale);
                } else {
                    scale = viewHeight / (float) cropHeght;
                    cropWidth = (int) (cropHeght * viewScale);
                }
            } else {
                scale = viewWidth / (float) cropWidth;
            }
            top = (src.getHeight() - cropHeght) / 2;
            left = (src.getWidth() - cropWidth) / 2;
            if (left >= 0 && left <= src.getWidth() && top >= 0
                    && top <= src.getHeight() && cropWidth > 0
                    && cropWidth <= src.getWidth() && cropHeght > 0
                    && cropHeght <= src.getHeight()) {
                Matrix m = null;
                if (scale < 1.0f) {
                    m = new Matrix();
                    m.postScale(scale, scale);
                }
                if (mRotation != 0) {
                    if (m == null) {
                        m = new Matrix();
                    }
                    m.postRotate(mRotation);
                }
                try {
                    dstBitmap = Bitmap.createBitmap(src, left, top, cropWidth,
                            cropHeght, m, true);
                    if (dstBitmap == src) {
                        Log.d(TAG, "dstBitmap == src");
                        dstBitmap = copyBitmap(src, null);
                    }
                } catch (OutOfMemoryError e) {
                    Log.d(TAG, e.getMessage());
                }
            }
        }
        return dstBitmap;
    }

    /**
     * Initialize the enhanced mode work bar
     */
    private void initEnhanceBar() {
        if (isSmallScreen && !mIs7Tablet
                && mEnhanceModeBar instanceof HorizontalListView) {
            int[] size = getPhoneEnhanceMenuSize();
            if (size[0] <= 0) {
                DisplayMetrics metrics = new DisplayMetrics();
                WindowManager wm = (WindowManager) getSystemService(Context.WINDOW_SERVICE);
                wm.getDefaultDisplay().getMetrics(metrics);
                size[0] = (int) ((metrics.widthPixels) / 4.5f);
            }
            final int oneItemWidth = size[0];
            Log.d(TAG, " oneItemWidth=" + oneItemWidth);
            final HorizontalListView list = (HorizontalListView) mEnhanceModeBar;
            int margin = getResources().getDimensionPixelSize(
                    R.dimen.enhance_menu_margin);
            final int thumbWidth = oneItemWidth - margin - margin;
            final BaseAdapter adapter = new BaseAdapter() {

                @SuppressWarnings("deprecation")
                @Override
                public View getView(int position, View convertView,
                                    ViewGroup parent) {
                    View view = convertView;
                    ImageView iv = null;
                    TextView tv = null;
                    RelativeLayout item_rel;
                    // View selectView = null;
                    if (view == null) {
                        view = View.inflate(ImageScannerActivity.this,
                                R.layout.horizontal_list_item, null);
                        view.setMinimumWidth(oneItemWidth);
                        iv = view.findViewById(R.id.item_image);
                        tv = view.findViewById(R.id.item_text);
                        tv.setMinimumWidth(thumbWidth);
                        ViewGroup.LayoutParams params = iv.getLayoutParams();
                        params.width = thumbWidth;
                        params.height = thumbWidth;
                        iv.setLayoutParams(params);
                    } else {
                        iv = view.findViewById(R.id.item_image);
                        tv = view.findViewById(R.id.item_text);
                    }
                    // selectView = view.findViewById(R.id.item_v_mask);
                    item_rel = view
                            .findViewById(R.id.item_rel);

                    try {
                        if (mEnhanceModeBitmap[position] != null
                                && !mEnhanceModeBitmap[position].isRecycled()) {
                            iv.setImageBitmap(mEnhanceModeBitmap[position]);
                        } else {
                            iv.setImageBitmap(null);
                        }
                        if (mEnhanceModeIndex == position) {
                            // selectView.setVisibility(View.VISIBLE);
                            item_rel.setBackgroundDrawable(getResources()
                                    .getDrawable(R.drawable.rounded_choose));
                        } else {
                            item_rel.setBackgroundDrawable(getResources()
                                    .getDrawable(R.drawable.rounded_unchoose));

                            // selectView.setVisibility(View.GONE);
                        }
                    } catch (OutOfMemoryError e) {// LGE OS 2.3
                        Log.d(TAG, e.getMessage());
                    }
                    Log.d(TAG, "getView mEnhanceModeIndex=" + mEnhanceModeIndex
                            + " pos=" + position);
                    tv.setText(mModeNames[position]);
                    return view;
                }

                @Override
                public long getItemId(int position) {
                    return position;
                }

                @Override
                public Object getItem(int position) {
                    return position;
                }

                @Override
                public int getCount() {
                    return mModeNames.length;
                }
            };
            list.setAdapter(adapter);
            list.setOnItemClickListener(new OnItemClickListener() {

                @Override
                public void onItemClick(AdapterView<?> parent, View view,
                                        int pos, long id) {

                    mEnhanceModeIndex = pos;

                    Log.d(TAG, "mEnhanceModeIndex=" + mEnhanceModeIndex);
                    if (mOriginalEnhanceBitmap != null) {
//						mEnRotation = 0;
                        EnhanceTask enhanceTask = new EnhanceTask(
                                getEnhanceMode(pos));
                        enhanceTask.execute();
                    } else {
                        Log.d(TAG, "mOriginalEnhanceBitmap="
                                + mOriginalEnhanceBitmap);
                    }
                    // previewOneMode(pos);
                    // Click on the incomplete icon and scroll to make it appear completely
                    int firstViewPos = list.getFirstVisiblePosition();
                    //
                    int offset = 0;
                    int childpos = mEnhanceModeIndex - firstViewPos;
                    if (mEnhanceModeIndex > 0
                            && mEnhanceModeIndex < mModeNames.length - 1) { // Not the first and last two modes, need to display offset
                        offset = oneItemWidth / 2;
                    }
                    adapter.notifyDataSetChanged();
                    // list.makeChildAtVisable(childpos, offset);
                    // // Util.LOGE(TAG,
                    // "list.setOnItemClickListener(new OnItemClickListener() {");
                    // //
                    // mRawImageHandler.requestStoreImage(createRawStoreRequest());
                    // mBigImageDirty = true;
                }
            });
            if (mEnhanceModeIndex > 3) {
                float offset = (mEnhanceModeIndex - 3.5f) * oneItemWidth;
                list.scrollTo((int) offset);
            }
        } else {
            // loadTabletEnhanceMenu();
            // selectEnhanceMenu(mEnhanceModeIndex);
        }
    }

    /**
     * detect image border
     */
    class DetectBorderTask extends AsyncTask<Void, Void, Boolean> {
        private long mStartTime;
        /**
         * it's a absolute path of the source image
         */
        private String mPath;
        private float[] mOrginBounds = null;

        private int grayInt = -1;

        public DetectBorderTask(String path) {
            mPath = path;
        }

        @Override
        protected void onPreExecute() {
            showProgressDialog();

        }

        @Override
        protected Boolean doInBackground(Void... params) {
            boolean succed = false;
            long tempTime = 0;
            mStartTime = System.currentTimeMillis();
            int threadContext = mScannerSDK.initThreadContext();
            System.out
                    .println("DetectBorderTask, initThreadContext, cost time:"
                            + (System.currentTimeMillis() - mStartTime));
            tempTime = System.currentTimeMillis();
            int imageStruct = mScannerSDK.decodeImageS(mPath);
            System.out.println("DetectBorderTask, decodeImageS, cost time:"
                    + (System.currentTimeMillis() - tempTime));

            mLastDetectBorder = null;
            int[] imgBound = getImageSizeBound(mPath);
            if (imageStruct != 0) {
                // Detect the border of the image
                tempTime = System.currentTimeMillis();
                mLastDetectBorder = mScannerSDK.detectBorder(threadContext,
                        imageStruct);

//                 if(boolJudgeGrayOrColor)
//                 grayInt = mScannerSDK.grayOrColorJudge(imageStruct);

                System.out.println("DetectBorderTask, detectBorder, cost time:"
                        + (System.currentTimeMillis() - tempTime));
                Log.d(TAG,
                        "detectAndTrimImageBorder, borders="
                                + Arrays.toString(mLastDetectBorder));
                tempTime = System.currentTimeMillis();
                mOrginBounds = getScanBoundF(imgBound, mLastDetectBorder);

                float[] bound = getScanBoundF(imgBound, mLastDetectBorder);
                if (bound != null) {
                    for (int i = 0; i < bound.length; i++) {
                        mBitmapDetectBound[i] = (int) (bound[i]);
                        mViewTtrimBound[i] = mBitmapDetectBound[i];
                    }

                }

                System.out.println("DetectBorderTask, fix border, cost time:"
                        + (System.currentTimeMillis() - tempTime));
                tempTime = System.currentTimeMillis();
                mScannerSDK.releaseImage(imageStruct);
                System.out.println("DetectBorderTask, releaseImage, cost time:"
                        + (System.currentTimeMillis() - tempTime));
                succed = true;
            } else {
                mOrginBounds = getScanBoundF(imgBound, null);
            }
            mScannerSDK.destroyContext(threadContext);
            System.out.println("DetectBorderTask, cost time:"
                    + (System.currentTimeMillis() - mStartTime));
            return succed;
        }

        protected void onPostExecute(Boolean result) {
            dismissProgressDialog();
            Log.d(TAG, "result=" + result);
            if (result) {

                // remark the cropped area
                if (mScale < 0.001 && mScale > -0.001) {
                    mScale = 1.0f;
                }
                if (mOrginBounds != null) {
                    // Load in the trimming area of the original image
                    // mScale=1f;
                    // load the source image crop area
                    mIvEditView.setRegion(mOrginBounds, mScale);
                    // set the crop are to be shown
                    mIvEditView.setRegionVisibility(true);
                    // Set to display the trimming area, but not display the anchor point and cannot manually change the area
                    // mIvEditView.showDrawPoints(false);
                    // mIvEditView.enableMovePoints(false);
                }
                mBtnNext.setVisibility(View.VISIBLE);

//                if (grayInt == 0) {
//                    gray_comment_id.setText("The current picture is in color");
//
//                } else if (grayInt == 1) {
//                    gray_comment_id.setText("The current picture is black and white");
//                }

                // getTrimRegions();
            } else {
                Log.d(TAG, "result=" + result);
            }
        }

    }

    /**
     * deal with the cropping asynchronous
     */
    class TrimTask extends AsyncTask<Void, Void, Boolean> {
        TranslateAnimation mTranslateAnimation;
        boolean boolIqa = false;
        private long mStartTime;
        /**
         * The absolute path of the image going to be cropped
         */
        private String mPath;
        private int grayInt = -1;
        public TrimTask(String path) {
            mPath = path;
        }

        @Override
        protected void onPreExecute() {
            //No display when memory is insufficient--Fox

            mMagnifierView.setVisibility(View.GONE);

            ocr_scan_rel.setVisibility(View.VISIBLE);

            mTranslateAnimation = new TranslateAnimation(
                    TranslateAnimation.ABSOLUTE, 0f,
                    TranslateAnimation.ABSOLUTE, 0f,
                    TranslateAnimation.RELATIVE_TO_PARENT, 0f,
                    TranslateAnimation.RELATIVE_TO_PARENT, 1f);

            mTranslateAnimation.setDuration(1000);
            mTranslateAnimation.setInterpolator(new LinearInterpolator());
            ocr_scan_line.setAnimation(mTranslateAnimation);
        }

        @Override
        protected Boolean doInBackground(Void... params) {
            Log.d(TAG, "TrimTask, doInBackground");
            long tempTime = 0;
            boolean succeed = false;
            mStartTime = System.currentTimeMillis();
            // Used for multi-threaded image processing. This function returns a memory pointer. When performing image operations on this thread, it is passed in as the first parameter
            int threadContext = mScannerSDK.initThreadContext();
            System.out.println("TrimTask, initThreadContext, cost time:"
                    + (System.currentTimeMillis() - mStartTime));

            tempTime = System.currentTimeMillis();
            int imageStruct = mScannerSDK.decodeImageS(mPath);
            System.out.println("TrimTask, decodeImageS, cost time:"
                    + (System.currentTimeMillis() - tempTime));

            if (imageStruct != 0) {
                // Detect the border and crop it
                tempTime = System.currentTimeMillis();
                // Get the edge of the image on the control
                // int[] bound = mIvEditView.getRegion(false);
                int[] bound = mBitmapDetectBound;
                // for (int i = 0; i < bound.length; i++) {
                // bound[i] = (int) (bound[i] );
                // }

                Log.d(TAG, "bound=" + Arrays.toString(bound));
                mScannerSDK.trimImage(threadContext, imageStruct, bound,
                        TRIM_IMAGE_MAXSIDE);
                System.out.println("TrimTask, trimImage, cost time:"
                        + (System.currentTimeMillis() - tempTime));

                tempTime = System.currentTimeMillis();
                mScannerSDK.rotateAndScaleImageS(threadContext, imageStruct,
                        mRotation);// Rotate after cutting edge


                if (boolJudgeGrayOrColor) {
                    grayInt = mScannerSDK.grayOrColorJudge(imageStruct);

                    boolIqa = mScannerSDK.RecognizeOneIqaSelect(imageStruct);
                }
                mScannerSDK.saveImage(imageStruct, mOriTrimImageEnchancePath,
                        TRIM_IMAGE_SAVESIDE);
                System.out.println("TrimTask, saveImage, cost time:"
                        + (System.currentTimeMillis() - tempTime));

                tempTime = System.currentTimeMillis();
                mScannerSDK.releaseImage(imageStruct);
                System.out.println("TrimTask, releaseImage, cost time:"
                        + (System.currentTimeMillis() - tempTime));

                // Try to judge the black and white of the trimmed image
                if (boolJudgeGrayOrColor) {
                    int imageStructGray = mScannerSDK
                            .decodeImageS(mOriTrimImageEnchancePath);

                    // grayInt = mScannerSDK.grayOrColorJudge(imageStructGray);
                    System.out.println("mScannerSDK.grayOrColorJudge grayInt:"
                            + grayInt);
                    mScannerSDK.releaseImage(imageStructGray);

                }

                changeBitmap(mOriTrimImageEnchancePath);
                succeed = true;
            }
            mScannerSDK.destroyContext(threadContext);
            System.out.println("TrimTask, cost time:"
                    + (System.currentTimeMillis() - mStartTime));
            return succeed;
        }


        protected void onPostExecute(Boolean result) {
            dismissProgressDialog();
            Log.d(TAG, "result=" + result);
            if (grayInt == 0) {
                gray_comment_idCrop.setText("The current trimming picture is in color" + (boolIqa ? "-----Clear": "-----Blur"));

            } else if (grayInt == 1) {
                gray_comment_idCrop.setText("The current trimming picture is black and white" + (boolIqa ? "-----Clear ":" -----Blur"));
            }
            if (result) {

                ocr_scan_rel.setVisibility(View.GONE);
                mTranslateAnimation.cancel();
                mTranslateAnimation = null;
                ocr_scan_line.clearAnimation();
                ocr_scan_line.setVisibility(View.GONE);
                enterEnhanceLayout();
                mEnhanceBitmap = mOriginalEnhanceBitmap.copy(
                        mOriginalEnhanceBitmap.getConfig(), true);

                /**************************** Enhanced mode specified by default ********************************/
                Log.d(TAG, "mEnhanceModeIndexExtra=" + mEnhanceModeIndexExtra);
                if (mEnhanceModeIndexExtra != -1) {
                    if (mOriginalEnhanceBitmap != null) {
                        EnhanceTask enhanceTask = new EnhanceTask(
                                getEnhanceMode(mEnhanceModeIndexExtra));
                        enhanceTask.execute();
                    } else {
                        Log.d(TAG, "mOriginalEnhanceBitmap="
                                + mOriginalEnhanceBitmap);
                    }
                } else {
                    mEnhanceModeIndex = 0;
                    initEnhanceBar();
                }
            } else {
                Log.d(TAG, "result=" + result);
            }
        }
    }

    /**
     *  Enhance the image asynchronous
     */
    class EnhanceTask extends AsyncTask<Void, Void, Void> {

        public EnhanceTask(int mode) {
            mEnhanceMode = mode;
        }

        @Override
        protected void onPreExecute() {
            showProgressDialog();
        }

        @Override
        protected Void doInBackground(Void... params) {
            int threadContext = mScannerSDK.initThreadContext();
            int imageStruct = 0;
            imageStruct = mScannerSDK
                    .decodeImageS(mOriTrimImageEnchancePath);
            // Recycle the previous enhanced image
            if (mEnhanceBitmap != null && !mEnhanceBitmap.isRecycled()) {
                mEnhanceBitmap.recycle();
            }

            // Copy a piece
            // mEnhanceBitmap = mOriginalEnhanceBitmap.copy(
            // mOriginalEnhanceBitmap.getConfig(), true);
            Log.d(TAG, "mEnhanceBitmap");
            mScannerSDK.enhanceImage(threadContext, imageStruct, mEnhanceMode);//Enhanced by pointer
            Log.e(TAG, "CS enhanceImage mEnhanceMode" + mEnhanceMode);

            if (mEnRotation != 0) {
                mScannerSDK.rotateAndScaleImageS(threadContext, imageStruct,
                        mEnRotation);

            }
            mScannerSDK.saveImage(imageStruct, mOriTrimImagePathResult,
                    TRIM_IMAGE_SAVELOCALSIDE);

            mScannerSDK.releaseImage(imageStruct);

            mScannerSDK.destroyContext(threadContext);
            changeBitmap(mOriTrimImagePathResult);
            mEnhanceBitmap = mOriginalEnhanceBitmap.copy(
                    mOriginalEnhanceBitmap.getConfig(), true);
            return null;
        }

        @Override
        protected void onPostExecute(Void result) {
            dismissProgressDialog();

            // Enhanced displayed picture

            showIvEnhance(mEnhanceBitmap);
            Log.d(TAG, "finish, EnhanceTask");
        }
    }

    /**
     * Monitor the adjustment event of the trimming area
     *
     * @author Manish listen the event of crop area adjustment
     */
    private class MyCornerChangeListener implements OnCornorChangeListener {
        /**
         *  Start to move the frame or the point
         */
        @Override
        public void onPreMove() {
        }

        /**
         *  Moving finished
         */
        @Override
        public void onPostMove() {
            dismissMagnifierView();
        }

        @Override
        public void onCornorChanged() {
            if (mIvEditView != null) {
                if (mIvEditView.isCanTrim(mEngineContext)) {
                    mIvEditView.setLinePaintColor(mNormalColor);
                } else {
                    mIvEditView.setLinePaintColor(mErrorColor);
                }

                mBitmapDetectBound = mIvEditView.getRegion(false);
                for (int i = 0; i < mBitmapDetectBound.length; i++) {

                    mViewTtrimBound[i] = mBitmapDetectBound[i];
                }
                mIvEditView.invalidate();
            }
        }

        @Override
        public void onClickPoint(float x, float y) {
            // TODO Auto-generated method stub
            updateMagnifierView(x, y);
        }
    }

    /**
     * Edge trimming/enhancement animation time frame response to the listener
     *
     * @author Ben & Manish
     */
    private class ImageProcessListener implements ScannerProcessListener {
        // private int[] connerPoints;
        // private Bitmap thumb, b_out;
        private Handler mHandlerAnim;

        private Bitmap mSrc; // Small picture
        private Bitmap mOut;
        private int[] mSmallTrimBounds;

        private int TrimGipTime;
        private long mLastProcessTime = 0;

        public ImageProcessListener(Handler handler) {
            super();
            mHandlerAnim = handler;
            TrimGipTime = 100;
        }

        public void setTrim(Bitmap thumb) {
            mSrc = copySmallBitmap(thumb);
            mSmallTrimBounds = new int[mCurrentThumbBounds.length];
            for (int i = 0; i < mSmallTrimBounds.length; i++) {
                mSmallTrimBounds[i] = (int) (mCurrentThumbBounds[i] * mTrimScale);
            }
        }

        public boolean onProcess(int sessionId, int progress) {
            if (isFinishing())
                return false;
            // if(mLastProcessTime != 0){
            // Log.d(TAG, "onProcess interval at " + progress + " = " +
            // (System.currentTimeMillis() - mLastProcessTime));
            // }
            // mLastProcessTime = System.currentTimeMillis();
            int target;
            if (sessionId == ScannerEngine.IN_PROGRESS_ENHANCE
                    || sessionId == 0) {
                // step enhance
                target = PROGRESS_ENHANCE_INCREASE;
                mHandlerAnim.sendMessage(Message.obtain(mHandlerAnim, target,
                        progress, 0));
            }
            if (sessionId == ScannerEngine.IN_PROGRESS_DEWARP) { // trim
                target = PROGRESS_TRIM_INCREASE;
                progress += 10;
                if (progress > 100) {
                    progress = 100;
                }
                long time = System.currentTimeMillis();

                // mOut = BitmapUtils.copyBitmap(mSrc);
                mOut = copyBitmap(mSrc, null);// fox修改

                int result = ScannerEngine.drawDewarpProgressImage(
                        mEngineContext, mSrc, mSmallTrimBounds, mOut, progress,
                        100);
                // poolFinish[index] = true;
                // Log.d(TAG, "trimTemp " + progress + " comsume = " +
                // (System.currentTimeMillis() - time) + ", result = " +
                // result);

                // 100ms 1 frame

                long sleepTime = TrimGipTime
                        - (System.currentTimeMillis() - mLastProcessTime);
                if (sleepTime > 0) {
                    Log.d(TAG, "trim anim sleep: " + sleepTime);
                    try {
                        Thread.sleep(sleepTime);
                    } catch (InterruptedException e) {
                        Log.d(TAG, e.getMessage());
                    }
                }

                mHandlerAnim.sendMessage(mHandlerAnim.obtainMessage(target,
                        progress, 0, mOut));
            }
            // Log.d(TAG, "onProcess cosume = " + (System.currentTimeMillis() -
            // mLastProcessTime));
            mLastProcessTime = System.currentTimeMillis();
            return true;
        }

    }

    /**
     * Trimming animation class
     *
     * @author Ben & Manish
     */
    public class AnimationView extends View {
        public AnimationView(Context context) {
            super(context);
            ObjectAnimator objectAnimator = (ObjectAnimator) AnimatorInflater
                    .loadAnimator(ImageScannerActivity.this,
                            R.animator.coloranimation);
            objectAnimator.setEvaluator(new ArgbEvaluator());
            objectAnimator.setTarget(this);
            objectAnimator.start();
        }

    }

    private class TrimAnimTask extends AsyncTask<Void, Integer, Boolean> {

        /**
         *[Auto, original image, brighten, enhance and sharpen, grayscale, black and white, ink saving]
         */
        private Bitmap[] mEnhanceModeBitmap = new Bitmap[7];

        @Override
        protected void onPreExecute() {
            mImageProcessListener = new ImageProcessListener(mHandlerAnim);

            mIvEditView.setRegionVisibility(false);
            bt_toolbar_line.setVisibility(View.GONE);
            bt_process_line.setVisibility(View.VISIBLE);
        }

        @Override
        protected void onPostExecute(Boolean result) {
            Log.d(TAG, "TrimAnimTask requestStoreImage after task");
            // mRawImageHandler.setPrepared(true);
            /**
             * In version 3.5, only do a pre-save once the picture is trimmed
             */

            bt_toolbar_line.setVisibility(View.VISIBLE);
            bt_process_line.setVisibility(View.GONE);
            startTtrim();
        }

        @Override
        protected Boolean doInBackground(Void... arg0) {

            Config config = mThumb.getConfig();
            if (config == null) {
                config = getDefaultConfig();
            }

            /*
             * copy mThumb to trimSrc, trimSrc will be the source bitmap in
             * trimming animation,while mThumb as the output
             */

            if (mIvEditView.isRegionAvailable()) { //Need to trim
                Bitmap trimSrc = copyBitmap(mThumb, config);
                mEnhanceSource = trimImage(trimSrc, mCurrentThumbBounds);
                recycleBitmap(trimSrc);
                mIsTrim = true;
            } else {
                mIsTrim = false;
                // mRawImageHandler.restoreThumb(); // No edge trimming, need to re-analyze the small image
            }
            // Edge trimming failed or trimming is not required
            if (mEnhanceSource == null) {
                mEnhanceSource = copyBitmap(mThumb, config);
            }
            // Unable to copy original image needed for enhancement
            if (mEnhanceSource == null) {
                // End the process without updating the image of ImageView-mThumb
                releaseModeThumb();
                mHandlerAnim.sendMessage(mHandlerAnim.obtainMessage(
                        PROCESS_FINISH, 0, 0, mThumb));
                // mHandler.sendMessage(mHandler.obtainMessage(PROCESS_FINISH,
                // 0, 0, mThumb));
            } else {
                handleModeMenuThumb(mEnhanceSource);
            }
            // enhanceImage(config, mIsTrim);
            // TimeLogger.endTrimAnim();

            return null;
        }

        public Bitmap dewarpImagePlane(int context, Bitmap image,
                                       int[] corner_xy, boolean bAntiAliasing) {
            Config config = image.getConfig();
            if (config == null) {
                config = Config.RGB_565;
            }
            Bitmap out = copyBitmap(image, config);
            try {
                int ret = ScannerEngine.trimBitmap(context, image, corner_xy,
                        out, 1, 1);
                if (ret < 0) {
                    if (out != null) {
                        out.recycle();
                        out = null;
                    }
                }
            } catch (OutOfMemoryError e) {
                Log.d(TAG, e.getMessage());
                out = null;
            }
            return out;
        }

        /**
         * @param src
         * @param bounds
         * @return an Bitmap after trim and scale,while mThumb is the output of
         * trim progress
         */
        private Bitmap trimImage(Bitmap src, int[] bounds) {
            if (src == null) {
                Log.d(TAG, "skip trimImage");
                return mThumb;
            }
            // send msg of starting trim
            mHandlerAnim.sendMessage(mHandlerAnim.obtainMessage(
                    PROGRESS_STEP_CHANGED, R.string.step_trim, 0, mThumb));
            mScanRecordControl
                    .setCurrentScanStep(ScanRecordControl.DEWARP_IMAGE_PLANE);
            Bitmap trimmed = dewarpImagePlane(mEngineContext, src, bounds, true);

            // mLastCropBounds = mCurrentFileBoundsF;

            mImageProcessListener.setTrim(src);

            Log.d(TAG, "dewarpImagePlane beign");
            long start = System.currentTimeMillis();
            ScannerEngine.setProcessListener(mEngineContext,
                    mImageProcessListener);

            mRawImageHandler.trimThumb(mCurrentThumbBounds);
            ScannerEngine.setProcessListener(mEngineContext, null);
            int cost = (int) (System.currentTimeMillis() - start);
            Log.d(TAG, "dewarpImagePlane ok consume " + cost + ", finish at "
                    + System.currentTimeMillis());

            return trimmed;
        }

    }

    private class EnhanceCallable implements Callable<Bitmap> {
        private Bitmap mSrc;
        private int mMode;

        public EnhanceCallable(Bitmap src, int enhanceMode) {
            mSrc = src;
            mMode = enhanceMode;
        }

        @Override
        public Bitmap call() throws Exception {
            Bitmap dstBitmap = null;
            int repeat = 0;
            while (dstBitmap == null && repeat < MAX_COPY_TRY_TIME) {
                // Retry mechanism, if a copy is unsuccessful.
                dstBitmap = copyBitmap(mSrc, null);
                repeat++;
            }
            if (dstBitmap != null) {
                int threadContext = ScannerEngine.initThreadContext();
                ScannerEngine.enhanceImage(threadContext, dstBitmap, mMode);
                ScannerEngine.destroyThreadContext(threadContext);
            }
            return dstBitmap;
        }
    }
}
