/*
 * Decompiled with CFR 0.152.
 */
package com.intsig.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public class Utils {
    public static boolean createFile(String string) {
        block7: {
            Serializable serializable = new File(string);
            if (((File)serializable).exists()) {
                Log.d((String)"createFile", (String)("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + string + "\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u5df2\u5b58\u5728\uff01"));
                return false;
            }
            if (string.endsWith(File.separator)) {
                Log.d((String)"createFile", (String)("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + string + "\u5931\u8d25\uff0c\u76ee\u6807\u6587\u4ef6\u4e0d\u80fd\u4e3a\u76ee\u5f55\uff01"));
                return false;
            }
            if (!((File)serializable).getParentFile().exists()) {
                Log.d((String)"createFile", (String)"\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u4e0d\u5b58\u5728\uff0c\u51c6\u5907\u521b\u5efa\u5b83\uff01");
                if (!((File)serializable).getParentFile().mkdirs()) {
                    Log.d((String)"createFile", (String)"\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
                    return false;
                }
            }
            try {
                if (!((File)serializable).createNewFile()) break block7;
                Log.d((String)"createFile", (String)("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + string + "\u6210\u529f\uff01"));
                return true;
            }
            catch (IOException iOException) {
                serializable = iOException;
                iOException.printStackTrace();
                Log.d((String)"createFile", (String)("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + string + "\u5931\u8d25\uff01" + ((Throwable)serializable).getMessage()));
                return false;
            }
        }
        Log.d((String)"createFile", (String)("\u521b\u5efa\u5355\u4e2a\u6587\u4ef6" + string + "\u5931\u8d25\uff01"));
        return false;
    }

    public static Bitmap loadBitmap(String string, int n, int n2, Bitmap.Config config, int[] nArray) {
        return Utils.loadBitmap(string, n, n2, config, true, nArray);
    }

    /*
     * Unable to fully structure code
     */
    public static int computeSampleSize(BitmapFactory.Options var0, int var1_2, int var2_3) {
        var8_4 = var0.outWidth;
        var10_5 = var0.outHeight;
        var0_1 = var2_3 == -1 ? 1 : (int)Math.ceil(Math.sqrt(var8_4 * var10_5 / (double)var2_3));
        var3_6 = var1_2 == -1 ? 128 : (int)Math.min(Math.floor(var8_4 / (double)var1_2), Math.floor(var10_5 / (double)var1_2));
        if (var3_6 != 0) ** GOTO lbl-1000
        var4_7 = (float)Math.sqrt(var8_4 * var10_5 / (double)var2_3);
        var5_8 = (float)Math.min(var8_4 / (double)var1_2, var10_5 / (double)var1_2);
        if (var4_7 >= 0.5f && var5_8 <= 0.5f) {
            v0 = 2;
        } else lbl-1000:
        // 2 sources

        {
            v0 = var3_6 < var0_1 ? var0_1 : (var2_3 == -1 && var1_2 == -1 ? 1 : (var0_1 = var1_2 == -1 ? var0_1 : var3_6));
        }
        if (v0 <= 8) {
            var1_2 = 1;
            while (var1_2 < var0_1) {
                var1_2 <<= 1;
            }
        } else {
            var1_2 = (var0_1 + 7) / 8 << 3;
        }
        return var1_2;
    }

    public static Bitmap loadBitmap(String string, int n, int n2, Bitmap.Config config, boolean bl, int[] nArray) {
        Object object;
        block9: {
            BitmapFactory.Options options;
            block8: {
                options = new BitmapFactory.Options();
                object = null;
                System.gc();
                options.inSampleSize = 1;
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
                if (!options.mCancel && options.outWidth != -1 && options.outHeight != -1) break block8;
                return null;
            }
            Log.d((String)"loadBitmap", (String)("loadBitmap(orginal) path:" + string + " " + options.outWidth + "x" + options.outHeight));
            options.inSampleSize = n = Utils.computeSampleSize(options, n, n2);
            n2 = 0;
            while (n2 < nArray.length) {
                nArray[n2] = nArray[n2] / n;
                ++n2;
            }
            options.inJustDecodeBounds = false;
            options.inDither = false;
            options.inPreferredConfig = config;
            object = BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            if (object != null) break block9;
            return null;
        }
        try {
            if (bl && (n2 = Utils.getOrientation(string)) != 1) {
                string = new Matrix();
                string.postRotate((float)Utils.getRotation(n2));
                string = Bitmap.createBitmap((Bitmap)object, (int)0, (int)0, (int)object.getWidth(), (int)object.getHeight(), (Matrix)string, (boolean)true);
                if (string != null && !string.equals(object)) {
                    object.recycle();
                    object = string;
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.d((String)"loadBitmap", (String)"loadBitmap OOM:", (Throwable)outOfMemoryError);
            System.gc();
        }
        catch (Exception exception) {
            Log.d((String)"loadBitmap", (String)("image read error:" + exception));
        }
        return object;
    }

    public static int getRotation(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 8: {
                return 270;
            }
            case 3: {
                return 180;
            }
            case 6: {
                return 90;
            }
        }
        return 0;
    }

    public static int getImageRotation(String string) {
        int n = Utils.getOrientation(string);
        return Utils.getRotation(n);
    }

    public static int getOrientation(String string) {
        int n = 1;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            try {
                string = new ExifInterface(string);
                n = string.getAttributeInt("Orientation", 1);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                Log.d((String)"getOrientation", (String)("image read error:" + noClassDefFoundError));
            }
            catch (IOException iOException) {
                Log.d((String)"getOrientation", (String)("image read error:" + iOException));
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                Log.d((String)"getOrientation", (String)("image read error:" + exceptionInInitializerError));
            }
            catch (NullPointerException nullPointerException) {
                Log.d((String)"getOrientation", (String)("image read error:" + nullPointerException));
            }
            catch (RuntimeException runtimeException) {
                Log.d((String)"getOrientation", (String)("image read error:" + runtimeException));
            }
            catch (StackOverflowError stackOverflowError) {
                Log.d((String)"getOrientation", (String)("image read error:" + stackOverflowError));
            }
        }
        return n;
    }

    public static int getOrientation(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 270: {
                return 8;
            }
            case 180: {
                return 3;
            }
            case 90: {
                return 6;
            }
        }
        return 1;
    }

    public static void recycleBitmap(Bitmap bitmap) {
        if (bitmap != null && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
    }

    public static DisplayMetrics getScreenWH(Context context) {
        new DisplayMetrics();
        context = context.getResources().getDisplayMetrics();
        return context;
    }

    public static Rect calculateTapArea(int n, int n2, float f2, float f3, float f4, int n3, int n4, int n5, int n6) {
        n = (int)((float)n * f2);
        n2 = (int)((float)n2 * f2);
        int n7 = (n3 + n4) / 2;
        int n8 = (n5 + n6) / 2;
        double d2 = ((double)n4 - (double)n3) / 2000.0;
        double d3 = ((double)n6 - (double)n5) / 2000.0;
        n7 = Utils.clamp((int)((double)(f3 - (float)(n / 2) - (float)n7) / d2), -1000, 1000);
        int n9 = Utils.clamp((int)((double)(f4 - (float)(n2 / 2) - (float)n8) / d3), -1000, 1000);
        n = Utils.clamp((int)((double)n7 + (double)n / d2), -1000, 1000);
        n2 = Utils.clamp((int)((double)n9 + (double)n2 / d3), -1000, 1000);
        return new Rect(n7, n9, n, n2);
    }

    public static int clamp(int n, int n2, int n3) {
        if (n > n3) {
            return n3;
        }
        if (n < n2) {
            return n2;
        }
        return n;
    }

    public static boolean checkCameraHardware(Context context) {
        return context != null && context.getPackageManager().hasSystemFeature("android.hardware.camera");
    }

    public static String getDBDir(Context context) {
        File file;
        String string = null;
        if ("mounted".equals(Environment.getExternalStorageState())) {
            string = String.valueOf(Environment.getExternalStorageDirectory().getAbsolutePath()) + File.separator + "bbk" + File.separator + "cloudteacher" + File.separator + "db";
            file = context.getExternalCacheDir();
            if (file != null) {
                string = file.getPath();
            }
        }
        if (string == null && (file = context.getCacheDir()) != null && file.exists()) {
            string = file.getPath();
        }
        return string;
    }

    public static Bitmap rotate(Bitmap bitmap, int n) {
        if (n != 0 && bitmap != null) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)n, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            try {
                Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                if (bitmap != bitmap2) {
                    bitmap.recycle();
                    bitmap = bitmap2;
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {}
        }
        return bitmap;
    }

    public static final int getHeightInPx(Context context) {
        int n = context.getResources().getDisplayMetrics().heightPixels;
        return n;
    }

    public static final int getWidthInPx(Context context) {
        int n = context.getResources().getDisplayMetrics().widthPixels;
        return n;
    }
}

