/*
 * Decompiled with CFR 0.152.
 */
package com.intsig.view;

import android.graphics.Bitmap;
import android.graphics.Matrix;

public class RotateBitmap {
    private Bitmap a;
    private int b;

    public RotateBitmap(Bitmap bitmap) {
        this.a = bitmap;
        this.b = 0;
    }

    public RotateBitmap(Bitmap bitmap, int n) {
        this.a = bitmap;
        this.b = n % 360;
    }

    public void setRotation(int n) {
        this.b = n;
    }

    public int getRotation() {
        return this.b;
    }

    public Bitmap getBitmap() {
        return this.a;
    }

    public void setBitmap(Bitmap bitmap) {
        this.a = bitmap;
    }

    public Matrix getRotateMatrix() {
        Matrix matrix = new Matrix();
        if (this.b != 0) {
            int n = this.a.getWidth() / 2;
            int n2 = this.a.getHeight() / 2;
            matrix.preTranslate((float)(-n), (float)(-n2));
            matrix.postRotate((float)this.b);
            matrix.postTranslate((float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        }
        return matrix;
    }

    public boolean isOrientationChanged() {
        return this.b / 90 % 2 != 0;
    }

    public int getHeight() {
        if (this.isOrientationChanged()) {
            return this.a.getWidth();
        }
        return this.a.getHeight();
    }

    public int getWidth() {
        if (this.isOrientationChanged()) {
            return this.a.getHeight();
        }
        return this.a.getWidth();
    }

    public void recycle() {
        if (this.a != null) {
            this.a.recycle();
            this.a = null;
        }
    }
}

