/*
 * Decompiled with CFR 0.152.
 */
package com.intsig.scanner;

import android.content.Context;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import com.intsig.scanner.ScannerEngine;
import com.intsig.view.b;
import java.security.MessageDigest;

public class ScannerSDK
extends b {
    public static final int ENHANCE_MODE_AUTO = 17;
    public static final int ENHANCE_MODE_NO_ENHANCE = -1;
    public static final int ENHANCE_MODE_LINEAR = 15;
    public static final int ENHANCE_MODE_MAGIC = 17;
    public static final int ENHANCE_MODE_GRAY = 10;
    public static final int ENHANCE_MODE_BLACK_WHITE = 16;
    private static final int ERROR_APP_INFO = -2;
    public static final int ERROR_APP_KEY_ERROR = 101;
    public static final int ERROR_APP_ID_ERROR = 102;
    public static final int ERROR_EXPIRED = 103;
    public static final int ERROR_DEVICE_NUM_LIMITED = 104;
    public static final int ERROR_NUMBER_LIMIT_ERROR = 105;
    private static final int ENGINE_ERROR_EXPIRED = -3;
    private static final int ENGINE_ERROR_APP_INFO = -2;
    public static final int ERROR_ILLEGAL_KEY = -1;
    private static final int ERROR_UNKOWN = -6;
    public static final int ERROR_INNER_FAILED = -7;
    public static final int ERROR_INTERNET = -8;
    public static final int ERROR_SERVER = -9;
    public static final int SUCCESS = 0;
    private int mDetectMode = 0;

    public int[] detectBorderYuv(int n, byte[] byArray, int n2, int n3, int n4) {
        int[] nArray = new int[8];
        if ((n = ScannerEngine.detectYuvImage(n, byArray, n2, n3, n4, nArray)) < 0) {
            nArray = null;
        }
        return nArray;
    }

    public int initSDK(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new RuntimeException("appKey is empty");
        }
        int n = super.initIDCardScan(context, string);
        return n;
    }

    public int initSDKJY(Context context, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new RuntimeException("appKey is empty");
        }
        Log.e((String)"initSDKjy", (String)"start");
        int n = super.initIDCardScanJy(context, string);
        return n;
    }

    public int initThreadContext() {
        return ScannerEngine.initThreadContext();
    }

    public void destroyContext(int n) {
        ScannerEngine.destroyThreadContext(n);
    }

    public int decodeImageS(String string) {
        int n = ScannerEngine.decodeImageS(string);
        Log.d((String)"decodeImageS", (String)("code=" + n));
        if (n <= 0 && n > -5) {
            n = 0;
        }
        return n;
    }

    public int decodeImageSData(byte[] byArray) {
        int n = ScannerEngine.decodeImageData(byArray);
        Log.d((String)"decodeImageS", (String)("code=" + n));
        if (n <= 0 && n > -5) {
            n = 0;
        }
        return n;
    }

    public void releaseImage(int n) {
        ScannerEngine.releaseImageS(n);
    }

    public int[] detectBorder(int n, int n2) {
        int[] nArray = new int[8];
        if ((n = ScannerEngine.detectImageS(n, n2, nArray, this.mDetectMode)) < 0) {
            nArray = null;
        }
        return nArray;
    }

    public boolean trimImage(int n, int n2, int[] nArray, int n3) {
        return ScannerEngine.trimImageS(n, n2, nArray, this.mDetectMode, n3) >= 0;
    }

    public boolean enhanceImage(int n, Bitmap bitmap, int n2) {
        if (n2 == -1) {
            return true;
        }
        return ScannerEngine.enhanceImage(n, bitmap, n2);
    }

    public int grayOrColorJudge(int n) {
        return ScannerEngine.grayOrColorJudge(n);
    }

    public boolean RecognizeOneIqaSelect(int n) {
        return ScannerEngine.RecognizeOneIqaSelect(n);
    }

    public boolean enhanceImage(int n, int n2, int n3) {
        if (n3 == -1) {
            return true;
        }
        if (n3 == 17) {
            n3 = ScannerEngine.detectColorImageMode(n, n2);
        }
        return ScannerEngine.enhanceImageS(n, n2, n3) >= 0;
    }

    private boolean trimAndRotateImage(int n, int n2, int[] nArray, int n3) {
        boolean bl = false;
        if (ScannerEngine.trimImageS(n, n2, nArray, this.mDetectMode, 0) >= 0) {
            bl = ScannerEngine.rotateAndScaleImageS(n2, n3, 1.0f) >= 0;
        }
        return bl;
    }

    public boolean rotateAndScaleImageS(int n, int n2, int n3) {
        return ScannerEngine.rotateAndScaleImageS(n2, n3, 1.0f) >= 0;
    }

    public void saveImage(int n, String string, int n2) {
        ScannerEngine.encodeImageS(n, string, n2, false);
    }

    public byte[] saveImageToByte(int n, int n2) {
        return ScannerEngine.encodeImageToMemory(n, n2);
    }

    private int dumpImage(int n, String string) {
        return ScannerEngine.dumpImageS(n, string);
    }

    private String getSignature(Context signature, String string) {
        try {
            signature = signature.getPackageManager().getPackageInfo(string, 64);
            signature = signature.signatures;
            if (((Signature[])signature).length != 0) {
                signature = signature[0];
                return ScannerSDK.stringMD5(signature.toByteArray());
            }
        }
        catch (Exception exception) {
            signature = exception;
            exception.printStackTrace();
        }
        return null;
    }

    private static String stringMD5(byte[] object) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update((byte[])object);
            object = messageDigest.digest();
            String string = ScannerSDK.byteArrayToHex(object);
            object = string;
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String byteArrayToHex(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        StringBuilder stringBuilder = new StringBuilder();
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            stringBuilder.append(cArray[by >> 4 & 0xF]);
            stringBuilder.append(cArray[by & 0xF]);
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static class IllegalAppException
    extends Exception {
        private String mMsg;

        public IllegalAppException(String string) {
            this.mMsg = string;
        }

        @Override
        public String getMessage() {
            return this.mMsg;
        }

        @Override
        public String toString() {
            return this.mMsg;
        }
    }
}

