/*
 * Decompiled with CFR 0.152.
 */
package com.intsig.scanner;

import android.content.Context;
import android.graphics.Bitmap;
import java.util.HashMap;

public class ScannerEngine {
    public static final int DEFAULT_JPG_QUALITY = 80;
    public static final int ENHANCE_MODE_LINEAR = 0;
    public static final int ENHANCE_MODE_MAGIC = 1;
    public static final int ENHANCE_MODE_ECONOMY = 2;
    public static final int ENHANCE_MODE_NOTE = 3;
    public static final int ENHANCE_MODE_GRAY = 10;
    public static final int ENHANCE_MODE_BW = 11;
    public static final int ENHANCE_MODE_BLACKBOARD = 12;
    public static final int ENHANCE_MODE_COLOR = 13;
    public static final int ENHANCE_MODE_MAGIC_LITE = 14;
    public static final int ENHANCE_MODE_COLOR_2 = 15;
    public static final int ENHANCE_MODE_BW_2 = 16;
    public static final int ENHANCE_MODE_MAGIC_2 = 17;
    public static final int ENHANCE_MODE_GRAY_2 = 18;
    public static final int ENHANCE_MODE_BLACKWHITE = 19;
    public static final int ENHANCE_MODE_MAGIC_WEAK = 20;
    public static final int PREGRESS_DOWNSCALE = 1;
    public static final int PREGRESS_DETECT = 2;
    public static final int PREGRESS_TRIM = 3;
    public static final int PREGRESS_ENHANCE = 4;
    public static final int PREGRESS_SHARP = 5;
    public static final int PREGRESS_ADJUST = 6;
    public static final int IN_PROGRESS_DEWARP = 3;
    public static final int IN_PROGRESS_ENHANCE = 4;
    public static final int IN_PROGRESS_DETECT_RECT = 2;
    public static final int DETECT_MODE_ANY = 0;
    public static final int DETECT_MODE_BIZ_CARD = 1;
    public static final int DETECT_MODE_PROJECTOR = 2;
    public static final int DETECT_MODE_CREDIT_CARD = 3;
    public static final int DETECT_MODE_BIZ_CARD_ANY = 4;
    public static final int DETECT_MODE_EXPRESS_BILL = 5;
    public static final int DETECT_MODE_NORMAL = 0;
    public static final int COLOR_RGB = 2;
    public static final int COLOR_RGBA_8888 = 3;
    public static final int COLOR_FORMAT_YUV_Y = 5;
    public static final int COLOR_FORMAT_YUV420SP12 = 6;
    public static final int COLOR_FORMAT_YUV420SP21 = 7;
    private static final String TAG = "ScannerEngine";
    static HashMap mCallbacks = new HashMap();
    static int step = 10;
    public static final int ACTIVE_CODE_LEN = 20;

    static {
        try {
            System.loadLibrary("scanner");
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
    }

    static boolean onProcess(int n, int n2, int n3) {
        Progress progress = (Progress)mCallbacks.get(n);
        if (progress == null) {
            return true;
        }
        int n4 = n3 / step;
        if (n4 == progress.progress && n3 != 100) {
            return true;
        }
        progress.progress = n4;
        return progress.listener.onProcess(n2, n3);
    }

    public static native int initEngine(Context var0, String var1);

    public static native int detectBorder(int var0, String var1, int[] var2, int var3);

    public static native int calculateNewSize(int var0, int var1, int var2, int[] var3, int[] var4);

    public static native int isValidRect(int[] var0, int var1, int var2);

    public static native int trimFile(int var0, String var1, int[] var2, int var3, String var4, int var5, int var6);

    public static int trimFile(int n, String string, int[] nArray, String string2, int n2) {
        return ScannerEngine.trimFile(n, string, nArray, 0, string2, n2, 0);
    }

    public static native int trimBitmap(int var0, Bitmap var1, int[] var2, Bitmap var3, int var4, int var5);

    public static int trimFile(int n, Bitmap bitmap, int[] nArray, Bitmap bitmap2, int n2, int n3) {
        return ScannerEngine.trimBitmap(n, bitmap, nArray, bitmap2, n2, n3);
    }

    public static native int enhanceFile(int var0, String var1, int var2, String var3, int var4);

    public static native int enhanceBitmap(int var0, Bitmap var1, int var2);

    public static native int setLogLevel(int var0);

    public static int setProcessListener(int n, ScannerProcessListener scannerProcessListener) {
        if (scannerProcessListener != null) {
            mCallbacks.put(n, new Progress(scannerProcessListener));
        } else {
            mCallbacks.remove(n);
        }
        return ScannerEngine.setProgress(n, scannerProcessListener != null);
    }

    public static native int setProgress(int var0, boolean var1);

    public static native int scaleImage(String var0, int var1, float var2, int var3, String var4);

    private static native boolean verifySN(String var0, String var1, String var2, int var3);

    public static native int adjustImage(int var0, String var1, int var2, int var3, int var4, String var5, int var6);

    public static synchronized native int adjustBitmap(int var0, Bitmap var1, int var2, int var3, int var4);

    public static native int adjustBound(int[] var0, int[] var1, int[] var2, int var3);

    public static native int decodeImageS(String var0, int var1);

    public static int decodeImageS(String string) {
        return ScannerEngine.decodeImageS(string, 2);
    }

    public static native int decodeYUVImageS(byte[] var0, int var1, int var2, int var3);

    public static int decodeYUVImageS(byte[] byArray, int n, int n2) {
        return ScannerEngine.decodeYUVImageS(byArray, n, n2, 2);
    }

    public static native int encodeImageS(int var0, String var1, int var2, boolean var3);

    public static native byte[] encodeImageToMemory(int var0, int var1, boolean var2);

    public static native int grayOrColorJudge(int var0);

    public static native boolean RecognizeOneIqaSelect(int var0);

    public static byte[] encodeImageToMemory(int n, int n2) {
        return ScannerEngine.encodeImageToMemory(n, n2, true);
    }

    public static native int releaseImageS(int var0);

    public static native int dumpImageS(int var0, String var1);

    public static native byte[] getImageSPixels(int var0);

    public static native int detectImageS(int var0, int var1, int[] var2, int var3);

    public static int detectImageS(int n, int n2, int[] nArray) {
        return ScannerEngine.detectImageS(n, n2, nArray, 0);
    }

    public static native int detectYuvImage(int var0, byte[] var1, int var2, int var3, int var4, int[] var5, int var6);

    public static int detectYuvImage(int n, byte[] byArray, int n2, int n3, int n4, int[] nArray) {
        return ScannerEngine.detectYuvImage(n, byArray, n2, n3, n4, nArray, 0);
    }

    public static byte[] trimYuvImage(int n, byte[] byArray, int n2, int n3, int[] nArray, int n4, int n5, int n6) {
        if (byArray == null || nArray == null) {
            return null;
        }
        int n7 = ScannerEngine.decodeYUVImageS(byArray, n2, n3, 2);
        ScannerEngine.trimImageS(n, n7, nArray, n4, n5);
        byte[] byArray2 = ScannerEngine.encodeImageToMemory(n7, n6, true);
        return byArray2;
    }

    public static native int trimImageS(int var0, int var1, int[] var2, int var3, int var4);

    public static int trimImageS(int n, int n2, int[] nArray) {
        return ScannerEngine.trimImageS(n, n2, nArray, 0, 0);
    }

    public static native int enhanceImageS(int var0, int var1, int var2);

    public static native int adjustImageS(int var0, int var1, int var2, int var3, int var4);

    public static native int rotateAndScaleImageS(int var0, int var1, float var2);

    public static native int initThreadContext();

    public static native int destroyThreadContext(int var0);

    public static native int getImageStructPointer(int var0);

    public static native String GetVersion();

    public static int encodeImageS(int n, String string, int n2) {
        return ScannerEngine.encodeImageS(n, string, n2, true);
    }

    public static boolean trimImageFile(int n, String string) {
        return ScannerEngine.trimFile(n, string, null, null, 80) >= 0;
    }

    public static boolean trimImageFile(int n, String string, int[] nArray) {
        return ScannerEngine.trimFile(n, string, nArray, null, 80) >= 0;
    }

    public static boolean enhanceImageFile(int n, String string, int n2) {
        return ScannerEngine.enhanceFile(n, string, n2, null, 80) >= 0;
    }

    public static boolean enhanceImage(int n, Bitmap bitmap, int n2) {
        return ScannerEngine.enhanceBitmap(n, bitmap, n2) >= 0;
    }

    public static int drawDewarpProgressImage(int n, Bitmap bitmap, int[] nArray, Bitmap bitmap2, int n2, int n3) {
        return ScannerEngine.trimBitmap(n, bitmap, nArray, bitmap2, n2, n3);
    }

    public static int[] nativeDewarpImagePlaneForSize(int n, int n2, int n3, int[] nArray) {
        int[] nArray2 = new int[2];
        if ((n = ScannerEngine.calculateNewSize(n, n2, n3, nArray, nArray2)) < 0) {
            return null;
        }
        return nArray2;
    }

    public static int[] detectBoundLinesFromImageFile3(int n, String string) {
        int[] nArray = new int[8];
        if ((n = ScannerEngine.detectBorder(n, string, nArray, 0)) < 0) {
            return null;
        }
        return nArray;
    }

    public static boolean verifySN(String string, String string2, String string3) {
        if (string3 == null || string3.length() < 20) {
            return false;
        }
        try {
            return ScannerEngine.verifySN(string, string2, string3, 3);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return false;
        }
    }

    public static int scaleImage(String string, String string2, float f2, int n, int n2) {
        return ScannerEngine.scaleImage(string, n, f2, n2, string2);
    }

    public static void setProcessDelay(int n) {
        step = n;
    }

    public static native int detectColorImageMode(int var0, int var1);

    public static native int EnableMultiCoreSpeedUp(int var0, int var1);

    public static native int decodeImageData(byte[] var0, int var1);

    public static int decodeImageData(byte[] byArray) {
        return ScannerEngine.decodeImageData(byArray, 2);
    }

    static class Progress {
        ScannerProcessListener listener;
        int progress;

        public Progress(ScannerProcessListener scannerProcessListener) {
            this.listener = scannerProcessListener;
            this.progress = 0;
        }
    }

    public static interface ScannerProcessListener {
        public boolean onProcess(int var1, int var2);
    }
}

