/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.neutral;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.TextView;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.neutral.NeonBaseNeutralActivity;
import com.gaadi.neon.enumerations.CameraFacing;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.enumerations.CameraType;
import com.gaadi.neon.enumerations.GalleryType;
import com.gaadi.neon.fragment.ImageShowFragment;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.CustomParameters;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import java.util.ArrayList;
import java.util.List;

public class NeonNeutralActivity
extends NeonBaseNeutralActivity
implements View.OnClickListener {
    ArrayAdapter<String> adapter;
    private TextView txtTagTitle;
    private TextView showMinCount;
    private ListView tabList;
    private LinearLayout addPhotoCamera;
    private LinearLayout addPhotoGallary;
    private FrameLayout imageShowFragmentContainer;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getLayoutInflater().inflate(R.layout.neutral_activity_layout, (ViewGroup)this.frameLayout);
        this.txtTagTitle = (TextView)this.findViewById(R.id.txtTagTitle);
        this.tabList = (ListView)this.findViewById(R.id.tabList);
        this.imageShowFragmentContainer = (FrameLayout)this.findViewById(R.id.imageShowFragmentContainer);
        this.addPhotoCamera = (LinearLayout)this.findViewById(R.id.addPhotoCamera);
        this.showMinCount = (TextView)this.findViewById(R.id.show_min_count);
        this.addPhotoGallary = (LinearLayout)this.findViewById(R.id.addPhotoGallary);
        this.addPhotoGallary.setOnClickListener((View.OnClickListener)this);
        this.addPhotoCamera.setOnClickListener((View.OnClickListener)this);
        this.bindXml();
    }

    public void onPostResume() {
        super.onPostResume();
        if (NeonImagesHandler.getSingletonInstance().getImagesCollection() == null || NeonImagesHandler.getSingletonInstance().getImagesCollection().size() <= 0) {
            if (NeonImagesHandler.getSingletonInstance() != null && NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getTitleName() != null) {
                this.setTitle(NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getTitleName());
            } else {
                this.setTitle(R.string.photos);
            }
            this.tabList.setVisibility(0);
            if (this.adapter == null) {
                List<ImageTagModel> tagModels = new ArrayList<ImageTagModel>();
                if (NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getClickMinimumNumberOfImages() != 0 && !NeonImagesHandler.getSingletonInstance().getNeutralParam().getTagEnabled()) {
                    this.showMinCount.setVisibility(0);
                    this.txtTagTitle.setVisibility(8);
                    this.showMinCount.setText((CharSequence)String.format("Minimum number of images required is %s", String.valueOf(NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getClickMinimumNumberOfImages())));
                } else {
                    this.showMinCount.setVisibility(8);
                }
                if (NeonImagesHandler.getSingletonInstance().getNeutralParam() != null && NeonImagesHandler.getSingletonInstance().getNeutralParam().getImageTagsModel() != null) {
                    tagModels = NeonImagesHandler.getSingletonInstance().getNeutralParam().getImageTagsModel();
                }
                if (tagModels == null || tagModels.size() <= 0) {
                    return;
                }
                if ((tagModels = this.getMandetoryTags(tagModels)) == null || tagModels.size() <= 0) {
                    this.txtTagTitle.setVisibility(8);
                } else {
                    this.txtTagTitle.setVisibility(0);
                }
                Object[] tags = new String[tagModels.size()];
                for (int i = 0; i < tagModels.size(); ++i) {
                    tags[i] = " \u2022 " + tagModels.get(i).getTagName();
                }
                this.adapter = new ArrayAdapter((Context)this, R.layout.single_textview, R.id.tagText, tags);
            }
            this.tabList.setAdapter(this.adapter);
        } else {
            this.tabList.setVisibility(8);
            this.showMinCount.setVisibility(8);
            this.imageShowFragmentContainer.setVisibility(0);
            if (NeonImagesHandler.getSingletonInstance() != null && NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getTitleName() != null) {
                this.setTitle(NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getTitleName() + " (" + NeonImagesHandler.getSingletonInstance().getImagesCollection().size() + ")");
            } else {
                this.setTitle(this.getString(R.string.photos_count, new Object[]{NeonImagesHandler.getSingletonInstance().getImagesCollection().size()}));
            }
        }
    }

    private List<ImageTagModel> getMandetoryTags(List<ImageTagModel> tagModels) {
        ArrayList<ImageTagModel> fileterdList = new ArrayList<ImageTagModel>();
        for (ImageTagModel singleModel : tagModels) {
            if (!singleModel.isMandatory()) continue;
            fileterdList.add(singleModel);
        }
        return fileterdList;
    }

    private void bindXml() {
        if (NeonImagesHandler.getSingletonInstance().getNeutralParam() != null && NeonImagesHandler.getSingletonInstance().getNeutralParam().getCustomParameters() != null) {
            this.addPhotoCamera.setVisibility(NeonImagesHandler.getSingletonInstance().getNeutralParam().getCustomParameters().gethideCameraButtonInNeutral() ? 8 : 0);
            this.addPhotoGallary.setVisibility(NeonImagesHandler.getSingletonInstance().getNeutralParam().getCustomParameters().getHideGalleryButtonInNeutral() ? 8 : 0);
        }
        ImageShowFragment imageShowFragment = new ImageShowFragment();
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.beginTransaction().add(R.id.imageShowFragmentContainer, (Fragment)imageShowFragment).commit();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.addPhotoCamera) {
            try {
                PhotosLibrary.collectPhotos(NeonImagesHandler.getSingletonInstance().getRequestCode(), (Context)this, NeonImagesHandler.getSingletonInstance().getLibraryMode(), PhotosMode.setCameraMode().setParams(new ICameraParam(){

                    @Override
                    public CameraFacing getCameraFacing() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getCameraFacing();
                    }

                    @Override
                    public CameraOrientation getCameraOrientation() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getCameraOrientation();
                    }

                    @Override
                    public boolean getFlashEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getFlashEnabled();
                    }

                    @Override
                    public boolean getCameraSwitchingEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getCameraSwitchingEnabled();
                    }

                    @Override
                    public boolean getVideoCaptureEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getVideoCaptureEnabled();
                    }

                    @Override
                    public CameraType getCameraViewType() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getCameraViewType();
                    }

                    @Override
                    public boolean cameraToGallerySwitchEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().cameraToGallerySwitchEnabled();
                    }

                    @Override
                    public int getNumberOfPhotos() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getNumberOfPhotos();
                    }

                    @Override
                    public boolean getTagEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam() != null && NeonImagesHandler.getSingletonInstance().getNeutralParam().getTagEnabled();
                    }

                    @Override
                    public List<ImageTagModel> getImageTagsModel() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getImageTagsModel();
                    }

                    @Override
                    public List<FileInfo> getAlreadyAddedImages() {
                        return null;
                    }

                    @Override
                    public boolean enableImageEditing() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().enableImageEditing();
                    }

                    @Override
                    public CustomParameters getCustomParameters() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getCustomParameters();
                    }
                }), NeonImagesHandler.getSingletonInstance().getImageResultListener());
            }
            catch (NeonException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (id2 == R.id.addPhotoGallary) {
            try {
                PhotosLibrary.collectPhotos(NeonImagesHandler.getSingletonInstance().getRequestCode(), (Context)this, NeonImagesHandler.getSingletonInstance().getLibraryMode(), PhotosMode.setGalleryMode().setParams(new IGalleryParam(){

                    @Override
                    public boolean selectVideos() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().selectVideos();
                    }

                    @Override
                    public GalleryType getGalleryViewType() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getGalleryViewType();
                    }

                    @Override
                    public boolean enableFolderStructure() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().enableFolderStructure();
                    }

                    @Override
                    public boolean galleryToCameraSwitchEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().galleryToCameraSwitchEnabled();
                    }

                    @Override
                    public boolean isRestrictedExtensionJpgPngEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().isRestrictedExtensionJpgPngEnabled();
                    }

                    @Override
                    public int getNumberOfPhotos() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getNumberOfPhotos();
                    }

                    @Override
                    public boolean getTagEnabled() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam() != null && NeonImagesHandler.getSingletonInstance().getNeutralParam().getTagEnabled();
                    }

                    @Override
                    public List<ImageTagModel> getImageTagsModel() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getImageTagsModel();
                    }

                    @Override
                    public List<FileInfo> getAlreadyAddedImages() {
                        return null;
                    }

                    @Override
                    public boolean enableImageEditing() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().enableImageEditing();
                    }

                    @Override
                    public CustomParameters getCustomParameters() {
                        return NeonImagesHandler.getSingletonInstance().getNeutralParam().getCustomParameters();
                    }
                }), NeonImagesHandler.getSingletonInstance().getImageResultListener());
            }
            catch (NeonException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (id2 == 16908332) {
            this.onBackPressed();
        }
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        NeonImagesHandler.getSingletonInstance().showBackOperationAlertIfNeeded((Activity)this);
    }
}

