/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.app.Activity;
import android.content.Context;
import android.location.Location;
import android.os.Build;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.widget.Toast;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.location.SettingsClient;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;

public class FindLocations {
    private LocationRequest mLocationRequest;
    private static final int CONNECTION_FAILURE_RESOLUTION_REQUEST = 9000;
    private static final int REQUEST_CHECK_SETTINGS = 2000;
    private static final int ACCESS_FINE_LOCATION_INTENT_ID = 3;
    private static FindLocations self;
    private Activity activity;
    private long UPDATE_INTERVAL = 6000L;
    private long FASTEST_INTERVAL = 5000L;
    private Location location;
    private ILocation callBack;
    private FusedLocationProviderClient mFusedLocationClient;

    public static FindLocations getInstance() {
        if (self == null) {
            self = new FindLocations();
        }
        return self;
    }

    public Location getLocation() {
        return this.location;
    }

    public void init(Activity activity) {
        this.activity = activity;
        this.callBack = (ILocation)activity;
        this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)activity);
        this.connectClient();
    }

    private void connectClient() {
        if (this.isGooglePlayServicesAvailable() && this.mFusedLocationClient != null) {
            this.mLocationRequest = new LocationRequest();
            this.mLocationRequest.setPriority(100);
            this.mLocationRequest.setInterval(this.UPDATE_INTERVAL);
            this.mLocationRequest.setFastestInterval(this.FASTEST_INTERVAL);
            LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder();
            builder.addLocationRequest(this.mLocationRequest);
            LocationSettingsRequest locationSettingsRequest = builder.build();
            SettingsClient settingsClient = LocationServices.getSettingsClient((Activity)this.activity);
            settingsClient.checkLocationSettings(locationSettingsRequest);
            this.onConnected();
        } else {
            Toast.makeText((Context)this.activity, (CharSequence)"Please update the google play services.", (int)0).show();
        }
    }

    public void onConnected() {
        boolean permissionGranted;
        boolean bl = permissionGranted = ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        if (permissionGranted && null != this.mFusedLocationClient) {
            this.mFusedLocationClient.getLastLocation().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Location>(){

                public void onSuccess(Location location) {
                    if (location != null) {
                        FindLocations.this.callBack.getLocation(location);
                    }
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    Log.d((String)"NeonLocation", (String)"Error trying to get last GPS location");
                    e.printStackTrace();
                }
            });
            this.startLocationUpdates();
        } else {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)200);
        }
    }

    protected void startLocationUpdates() {
        boolean permissionGranted;
        boolean bl = permissionGranted = ActivityCompat.checkSelfPermission((Context)this.activity, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        if (permissionGranted && null != this.mFusedLocationClient) {
            this.mFusedLocationClient.requestLocationUpdates(this.mLocationRequest, new LocationCallback(){

                public void onLocationResult(LocationResult locationResult) {
                    FindLocations.this.onLocationChanged(locationResult.getLastLocation());
                }
            }, Looper.myLooper());
        } else {
            ActivityCompat.requestPermissions((Activity)this.activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)200);
        }
    }

    public void onLocationChanged(Location location) {
        this.location = location;
        this.callBack.getLocation(location);
    }

    private boolean isGooglePlayServicesAvailable() {
        GoogleApiAvailability googleAPI = GoogleApiAvailability.getInstance();
        int result = googleAPI.isGooglePlayServicesAvailable((Context)this.activity);
        if (result != 0) {
            if (googleAPI.isUserResolvableError(result)) {
                googleAPI.getErrorDialog(this.activity, result, 9000).show();
            }
            return false;
        }
        return true;
    }

    public boolean checkPermissions(Activity activity) {
        this.callBack = (ILocation)activity;
        return this.checkPermissions(activity, this.callBack);
    }

    public boolean checkPermissions(Activity activity, ILocation callBack) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                this.requestLocationPermission(activity);
                return false;
            }
            this.showSettingDialog(activity, callBack);
            return true;
        }
        this.showSettingDialog(activity, callBack);
        return true;
    }

    private void requestLocationPermission(Activity activity) {
        if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.ACCESS_FINE_LOCATION")) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)3);
        } else {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)3);
        }
    }

    private void showSettingDialog(Activity activity, final ILocation callBack) {
        LocationRequest locationRequest = new LocationRequest();
        locationRequest.setInterval(30000L);
        locationRequest.setFastestInterval(5000L);
        locationRequest.setPriority(100);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        builder.setAlwaysShow(true);
        SettingsClient client = LocationServices.getSettingsClient((Activity)activity);
        Task task = client.checkLocationSettings(builder.build());
        task.addOnSuccessListener(activity, (OnSuccessListener)new OnSuccessListener<LocationSettingsResponse>(){

            public void onSuccess(LocationSettingsResponse locationSettingsResponse) {
                FindLocations.this.startLocationUpdates();
                callBack.getPermissionStatus(true);
            }
        });
        task.addOnFailureListener(activity, new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                callBack.getPermissionStatus(false);
            }
        });
    }

    public static interface ILocation {
        public void getLocation(Location var1);

        public void getAddress(String var1);

        public void getPermissionStatus(Boolean var1);
    }
}

