/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.gaadi.neon.activity.ImageReviewActivity;
import com.gaadi.neon.adapter.ImageShowAdapter;
import com.gaadi.neon.dynamicgrid.DynamicGridView;
import com.gaadi.neon.enumerations.ResponseCode;
import com.gaadi.neon.interfaces.INeutralParam;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;

public class ImageShowFragment
extends Fragment {
    ImageShowAdapter adapter;
    private boolean isProfileTagOnly;
    private DynamicGridView imageShowGrid;
    View.OnClickListener doneListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (NeonImagesHandler.getSingletonInstance().validateNeonExit((Activity)ImageShowFragment.this.getActivity())) {
                NeonImagesHandler.getSingletonInstance().sendImageCollectionAndFinish((Activity)ImageShowFragment.this.getActivity(), ResponseCode.Success);
            }
        }
    };

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        INeutralParam iNeutralParam = NeonImagesHandler.getSingletonInstance().getNeutralParam();
        if (iNeutralParam != null) {
            this.isProfileTagOnly = iNeutralParam.hasOnlyProfileTag();
        }
        ViewGroup rootView = (ViewGroup)inflater.inflate(R.layout.image_show_layout, container, false);
        rootView.findViewById(R.id.btnDone).setOnClickListener(this.doneListener);
        this.imageShowGrid = (DynamicGridView)rootView.findViewById(R.id.image_show_grid);
        this.imageShowGrid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
                if (NeonImagesHandler.getSingletonInstance() != null && NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getImageTagsModel() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getImageTagsModel().size() > 0) {
                    Intent viewPagerIntent = new Intent((Context)ImageShowFragment.this.getActivity(), ImageReviewActivity.class);
                    viewPagerIntent.putExtra("imageReviewPosition", position);
                    ImageShowFragment.this.getActivity().startActivity(viewPagerIntent);
                }
            }
        });
        this.imageShowGrid.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> adapterView, View view, int position, long l) {
                ImageShowFragment.this.imageShowGrid.startEditMode(position);
                return true;
            }
        });
        this.imageShowGrid.setOnDropListener(new DynamicGridView.OnDropListener(){

            @Override
            public void onActionDrop() {
                ImageShowFragment.this.imageShowGrid.stopEditMode();
            }
        });
        this.imageShowGrid.setOnDragListener(new DynamicGridView.OnDragListener(){

            @Override
            public void onDragStarted(int position) {
            }

            @Override
            public void onDragPositionsChanged(int oldPosition, int newPosition) {
                if (NeonImagesHandler.getSingletonInstance().getImagesCollection() == null || NeonImagesHandler.getSingletonInstance().getImagesCollection().size() <= 0) {
                    return;
                }
                NeonImagesHandler.getSingletonInstance().getImagesCollection().add(newPosition, NeonImagesHandler.getSingletonInstance().getImagesCollection().remove(oldPosition));
            }
        });
        return rootView;
    }

    public void onResume() {
        super.onResume();
        if (NeonImagesHandler.getSingletonInstance().getImagesCollection() == null || NeonImagesHandler.getSingletonInstance().getImagesCollection().size() < 0) {
            return;
        }
        this.adapter = new ImageShowAdapter((Context)this.getActivity(), this.isProfileTagOnly);
        this.imageShowGrid.setAdapter((ListAdapter)this.adapter);
    }
}

