/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;
import com.gaadi.neon.activity.NeonBaseActivity;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.NeonUtils;
import com.scanlibrary.R;

public class SingleImageReviewActivity
extends NeonBaseActivity {
    private ImageView ivReview;
    private String path;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        try {
            if (NeonImagesHandler.getSingletonInstance().getCameraParam() != null && NeonImagesHandler.getSingletonInstance().getCameraParam().getCameraOrientation() == CameraOrientation.landscape) {
                this.setRequestedOrientation(0);
            } else {
                this.setRequestedOrientation(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_single_image_review);
        this.toolbar = (Toolbar)this.findViewById(R.id.tool_bar);
        this.ivReview = (ImageView)this.findViewById(R.id.iv_review);
        if (this.toolbar != null) {
            this.setSupportActionBar(this.toolbar);
            this.toolbar.setNavigationIcon(R.drawable.ic_left_arrow);
        }
        if (this.getSupportActionBar() != null) {
            this.getSupportActionBar().setHomeAsUpIndicator(R.drawable.ic_left_arrow);
            this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.setTitle(R.string.image_review);
        Intent intent = this.getIntent();
        this.path = intent.getStringExtra("singleImagePath");
        String title = intent.getStringExtra("reviewTitle");
        if (title != null && !TextUtils.isEmpty((CharSequence)title)) {
            this.setTitle(title);
        }
        if (this.path == null || TextUtils.isEmpty((CharSequence)this.path)) {
            this.finish();
        }
        RequestOptions options = new RequestOptions().diskCacheStrategy(DiskCacheStrategy.NONE).skipMemoryCache(true).placeholder(R.drawable.default_placeholder);
        Glide.with((FragmentActivity)this).load(this.path).apply(options).into(this.ivReview);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_view_pager, menu2);
        menu2.findItem(R.id.menu_done).setVisible(false);
        menu2.findItem(R.id.menu_retry).setVisible(true);
        menu2.findItem(R.id.menu_apply).setVisible(true);
        return super.onCreateOptionsMenu(menu2);
    }

    public void onBackPressed() {
        NeonUtils.deleteFile((Context)this, this.path);
        super.onBackPressed();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        if (item.getItemId() == R.id.menu_apply) {
            this.setResult(-1, new Intent().putExtra("singleImagePath", this.path));
            this.finish();
            return true;
        }
        if (item.getItemId() == R.id.menu_retry) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}

