/*
 * Decompiled with CFR 0.152.
 */
package com.intsig.csopen.sdk;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import com.intsig.csopen.sdk.CSOpenAPI;
import com.intsig.csopen.sdk.CSOpenAPIParam;
import com.intsig.csopen.sdk.CSOpenApiHandler;
import com.intsig.csopen.util.Log;
import java.io.File;

final class CSOpenApiV1
implements CSOpenAPI {
    private static final String TAG = "CSOpenApi";
    private Context mContext;
    private String mAppKey;
    private String mUserId;
    private int mLastRequestCode;

    protected CSOpenApiV1(Context context, String appKey, String userId) {
        this.mContext = context;
        this.mAppKey = appKey;
        this.mUserId = userId;
    }

    @Override
    public boolean isCamScannerAvailable() {
        float version = this.getOpenApiVersion();
        return version >= 0.0f;
    }

    @Override
    public float getOpenApiVersion() {
        float version = -1.0f;
        Uri uri = Uri.withAppendedPath((Uri)Uri.parse((String)"content://com.intsig.provider.CSOpenApi"), (String)"version");
        Cursor cursor = this.mContext.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                version = cursor.getFloat(0);
            }
            cursor.close();
        }
        return version;
    }

    @Override
    public boolean isCamScannerInstalled() {
        boolean res = false;
        try {
            PackageInfo pack = this.mContext.getPackageManager().getPackageInfo("com.intsig.camscanner", 64);
            if (pack != null) {
                res = true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "CamScanner is not installed.");
        }
        return res;
    }

    @Override
    public boolean handleResult(int requestCode, int resultCode, Intent data, CSOpenApiHandler handler) {
        boolean res = false;
        if (this.mLastRequestCode == requestCode) {
            res = true;
            if (data != null) {
                int responseCode = data.getIntExtra("RESPONSE_CODE", -1);
                if (handler != null) {
                    if (resultCode == -1) {
                        handler.onSuccess();
                    } else if (resultCode == 1) {
                        handler.onError(responseCode);
                    } else if (resultCode == 0) {
                        handler.onCancel();
                    }
                }
            }
        }
        return res;
    }

    @Override
    public boolean scanImage(Activity activity, int requestCode, CSOpenAPIParam param) {
        if (param == null || !param.checkLegal()) {
            Log.d(TAG, "param is illegal");
            return false;
        }
        File imgSrc = new File(param.mSourcePath);
        if (!imgSrc.exists() || imgSrc.length() < 1L) {
            Log.d(TAG, "file of imagePath not exist");
            return false;
        }
        if (!this.isCamScannerInstalled()) {
            return false;
        }
        boolean res = false;
        Uri u = Uri.fromFile((File)imgSrc);
        Intent i = new Intent("com.intsig.camscanner.ACTION_SCAN");
        i.putExtra("android.intent.extra.STREAM", (Parcelable)u);
        i.putExtra("app_key", this.mAppKey);
        if (!TextUtils.isEmpty((CharSequence)this.mUserId)) {
            i.putExtra("sub_app_key", this.mUserId);
        }
        if (param.mMinRequiredApiVersion > 0.0f) {
            i.putExtra("api_version", param.mMinRequiredApiVersion);
        }
        if (!TextUtils.isEmpty((CharSequence)param.mResultImgPath)) {
            i.putExtra("scanned_image", param.mResultImgPath);
        }
        if (!TextUtils.isEmpty((CharSequence)param.mResultPDFPath)) {
            i.putExtra("pdf_path", param.mResultPDFPath);
        }
        if (!TextUtils.isEmpty((CharSequence)param.mOriginalImagePath)) {
            i.putExtra("org_image", param.mOriginalImagePath);
        }
        try {
            this.mLastRequestCode = requestCode;
            activity.startActivityForResult(i, requestCode);
            res = true;
        }
        catch (ActivityNotFoundException e) {
            Log.e(TAG, "CamScanner is not Installed");
        }
        return res;
    }

    @Override
    public String getDownloadLink() {
        return "http://s.intsig.net/output/CamScanner_Lite_OpenAPI.apk";
    }
}

