/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.RequestOptions;
import com.gaadi.neon.util.FileInfo;
import com.scanlibrary.R;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;

public class CapturedImagesAdapter
extends BaseAdapter
implements View.OnClickListener {
    Context mContext;
    ArrayList<FileInfo> imageInfoArrayList;
    private ImageDeleted imageDeletedListener = null;

    public CapturedImagesAdapter(Context context, ArrayList<FileInfo> list) {
        this.mContext = context;
        this.imageInfoArrayList = list;
    }

    public CapturedImagesAdapter(Context context, ArrayList<FileInfo> list, ImageDeleted imageDeletedListener) {
        this.mContext = context;
        this.imageInfoArrayList = list;
        this.imageDeletedListener = imageDeletedListener;
    }

    public ArrayList<FileInfo> getImageInfoArrayList() {
        return this.imageInfoArrayList;
    }

    public void setImageInfoArrayList(ArrayList<FileInfo> imageInfoArrayList) {
        this.imageInfoArrayList = imageInfoArrayList;
    }

    public void setImageDeletedListener(ImageDeleted listener) {
        this.imageDeletedListener = listener;
    }

    public void onClick(View v) {
        int position = (Integer)v.getTag();
        if (v.getId() == R.id.ivRemoveImage) {
            Log.e((String)"On Click Remove", (String)(position + ""));
            File file = new File(this.imageInfoArrayList.get(position).getFilePath());
            file.delete();
            this.imageInfoArrayList.remove(position);
            this.notifyDataSetChanged();
        }
    }

    public int getCount() {
        return this.imageInfoArrayList.size();
    }

    public Object getItem(int position) {
        return this.imageInfoArrayList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ImagesHolder holder;
        if (convertView == null) {
            LayoutInflater inflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
            convertView = inflater.inflate(R.layout.captured_images_overlay, null);
            holder = new ImagesHolder();
            holder.capturedImage = (ImageView)convertView.findViewById(R.id.ivCaptured);
            holder.ivRemoveImage = (ImageView)convertView.findViewById(R.id.ivRemoveImage);
            Log.e((String)"Position getView", (String)(position + ""));
            holder.ivRemoveImage.setTag((Object)position);
            convertView.setTag((Object)holder);
        } else {
            holder = (ImagesHolder)convertView.getTag();
        }
        holder.ivRemoveImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Log.e((String)"On Click Remove", (String)(position + ""));
                File file = new File(CapturedImagesAdapter.this.imageInfoArrayList.get(position).getFilePath());
                file.delete();
                CapturedImagesAdapter.this.imageInfoArrayList.remove(position);
                if (CapturedImagesAdapter.this.imageDeletedListener != null) {
                    CapturedImagesAdapter.this.imageDeletedListener.onImageDeleted(CapturedImagesAdapter.this.imageInfoArrayList.size());
                }
                CapturedImagesAdapter.this.notifyDataSetChanged();
            }
        });
        RequestOptions options = new RequestOptions().placeholder(R.drawable.image_load_default_small).diskCacheStrategy(DiskCacheStrategy.ALL);
        Glide.with((Context)this.mContext).load("file://" + this.imageInfoArrayList.get(position).getFilePath()).apply(options).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).into(holder.capturedImage);
        return convertView;
    }

    public class ImagesHolder
    implements Serializable {
        ImageView ivRemoveImage;
        ImageView capturedImage;
    }

    public static interface ImageDeleted {
        public void onImageDeleted(int var1);
    }
}

