/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.finance;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.pdf.PdfRenderer;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.graphics.drawable.RoundedBitmapDrawable;
import android.support.v4.graphics.drawable.RoundedBitmapDrawableFactory;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.BitmapImageViewTarget;
import com.bumptech.glide.request.target.Target;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.adapter.FlashModeAdapter;
import com.gaadi.neon.enumerations.CameraFacing;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.enumerations.CameraType;
import com.gaadi.neon.enumerations.GalleryType;
import com.gaadi.neon.enumerations.LibraryMode;
import com.gaadi.neon.enumerations.ResponseCode;
import com.gaadi.neon.fragment.CameraFragment1;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.interfaces.OnImageCollectionListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.NeonResponse;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.CustomParameters;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.GetFilePath;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.NeonUtils;
import com.gaadi.neon.util.OneStepImageHandler;
import com.intsig.csopen.sdk.CSOpenAPI;
import com.intsig.csopen.sdk.CSOpenApiFactory;
import com.intsig.csopen.sdk.CSOpenApiHandler;
import com.scanlibrary.R;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class OneStepActivity
extends AppCompatActivity
implements CameraFragment1.SetOnPictureTaken,
OnImageCollectionListener {
    private final int REQ_CODE_CALL_CAMSCANNER = 168;
    private ImageView ivGallery;
    private ImageView ivClickPicture;
    private ImageView ivFlash;
    private ImageView ivPdf;
    private RecyclerView rvFlash;
    private List<String> listOfFlashModes = new ArrayList<String>();
    private HashSet<String> mSelectedImages = new HashSet();
    private int count;
    private TextView tvImageCount;
    private TextView tvNext;
    private ICameraParam cameraParam;
    private IGalleryParam galleryParam;
    private int PICKFILE_RESULT_CODE = 119;
    private ParcelFileDescriptor mFileDescriptor;
    private PdfRenderer mPdfRenderer;
    private PdfRenderer.Page mCurrentPage;
    private String path;
    private String docCat;
    private String docSubCat;
    private CSOpenAPI camScannerApi;
    private String camScannerApiKey;
    private String mOutputImagePath;
    private String mInputImagePath;

    private CameraFragment1 getCameraFragmentInstance() {
        return (CameraFragment1)this.getSupportFragmentManager().findFragmentById(R.id.content_frame);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_finance_one_step_upload);
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        this.ivPdf = (ImageView)this.findViewById(R.id.ivPdf);
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.CAMERA"}, (int)1);
        }
        if (Build.VERSION.SDK_INT < 21) {
            this.ivPdf.setVisibility(4);
        }
        this.extractData();
        this.setUpCamera();
        this.createFlashModes();
        if (this.camScannerApiKey != null && !this.camScannerApiKey.equals("")) {
            this.camScannerApi = CSOpenApiFactory.createCSOpenApi((Context)this, (String)this.camScannerApiKey, null);
        }
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                CameraFragment1 fragment = CameraFragment1.getInstance(false);
                FragmentManager manager = OneStepActivity.this.getSupportFragmentManager();
                manager.beginTransaction().replace(R.id.content_frame, (Fragment)fragment).commit();
            }
        });
        this.ivGallery = (ImageView)this.findViewById(R.id.ivGallery);
        this.rvFlash = (RecyclerView)this.findViewById(R.id.rvFlash);
        this.tvImageCount = (TextView)this.findViewById(R.id.tvImageCount);
        this.tvNext = (TextView)this.findViewById(R.id.tvNext);
        this.tvNext.setVisibility(8);
        this.ivPdf.setOnClickListener(new View.OnClickListener(){

            @RequiresApi(api=19)
            public void onClick(View view) {
                OneStepActivity.this.showFileChooser();
            }
        });
        this.tvNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OneStepActivity.this.sendResponse();
            }
        });
        TextView tvDocName = (TextView)this.findViewById(R.id.tvDocType);
        tvDocName.setText((CharSequence)this.docCat);
        TextView tvSubDocName = (TextView)this.findViewById(R.id.tvSubDocType);
        tvSubDocName.setText((CharSequence)this.docSubCat);
        ImageView ivBackBtn = (ImageView)this.findViewById(R.id.ivBackBtn);
        ivBackBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OneStepActivity.this.onBackPressed();
            }
        });
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this, 0, false);
        this.rvFlash.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.ivGallery.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                OneStepActivity.this.openGallery();
            }
        });
        this.ivClickPicture = (ImageView)this.findViewById(R.id.ivClick);
        this.ivClickPicture.setOnClickListener(new View.OnClickListener(){

            @SuppressLint(value={"NewApi"})
            public void onClick(View v) {
                OneStepActivity.this.tvNext.setClickable(false);
                OneStepActivity.this.ivClickPicture.setClickable(false);
                OneStepActivity.this.getCameraFragmentInstance().clickPicture();
            }
        });
        this.ivFlash = (ImageView)this.findViewById(R.id.ivFlash);
        this.ivFlash.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OneStepActivity.this.rvFlash.getVisibility() == 8) {
                    FlashModeAdapter flashModeAdapter = new FlashModeAdapter((Context)OneStepActivity.this, OneStepActivity.this.listOfFlashModes);
                    OneStepActivity.this.rvFlash.setAdapter((RecyclerView.Adapter)flashModeAdapter);
                    OneStepActivity.this.rvFlash.setVisibility(0);
                    flashModeAdapter.setOnItemClickListener(new FlashModeAdapter.OnItemClickListener(){

                        @Override
                        public void onItemClick(View view, int position) {
                            OneStepActivity.this.rvFlash.setVisibility(8);
                            switch (position) {
                                case 0: {
                                    OneStepActivity.this.ivFlash.setBackgroundResource(R.drawable.flash_off_circle);
                                    OneStepActivity.this.getCameraFragmentInstance().setFlash("off");
                                    break;
                                }
                                case 1: {
                                    OneStepActivity.this.ivFlash.setBackgroundResource(R.drawable.flash_circle);
                                    OneStepActivity.this.getCameraFragmentInstance().setFlash("on");
                                    break;
                                }
                                case 2: {
                                    OneStepActivity.this.ivFlash.setBackgroundResource(R.drawable.flash_auto_circle);
                                    OneStepActivity.this.getCameraFragmentInstance().setFlash("auto");
                                }
                            }
                        }
                    });
                } else {
                    OneStepActivity.this.rvFlash.setVisibility(8);
                }
            }
        });
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        switch (requestCode) {
            case 1: {
                if (grantResults.length <= 0 || grantResults[0] != 0) break;
                this.setupLatestPictureInGallery();
            }
        }
    }

    private void setupLatestPictureInGallery() {
        String CAMERA_IMAGE_BUCKET_NAME = Environment.getExternalStorageDirectory().toString() + "/DCIM/Camera";
        String CAMERA_IMAGE_BUCKET_ID = String.valueOf(CAMERA_IMAGE_BUCKET_NAME.toLowerCase().hashCode());
        String[] projection = new String[]{"_data"};
        String selection = "bucket_id = ?";
        String[] selectionArgs = new String[]{CAMERA_IMAGE_BUCKET_ID};
        Cursor cursor = this.getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, projection, "bucket_id = ?", selectionArgs, "datetaken DESC");
        if (cursor != null && cursor.moveToFirst()) {
            int dataColumn = cursor.getColumnIndexOrThrow("_data");
            String data = cursor.getString(dataColumn);
            cursor.close();
            Glide.with((FragmentActivity)this).load("file://" + data).asBitmap().centerCrop().into((Target)new BitmapImageViewTarget(this.ivGallery){

                protected void setResource(Bitmap resource) {
                    RoundedBitmapDrawable circularBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)OneStepActivity.this.getResources(), (Bitmap)resource);
                    circularBitmapDrawable.setCircular(true);
                    OneStepActivity.this.ivGallery.setImageDrawable((Drawable)circularBitmapDrawable);
                }
            });
        }
    }

    private void createFlashModes() {
        this.listOfFlashModes.add("off");
        this.listOfFlashModes.add("on");
        this.listOfFlashModes.add("auto");
    }

    private void extractData() {
        this.docCat = this.getIntent().getStringExtra("category");
        this.docSubCat = this.getIntent().getStringExtra("subCategory");
        this.camScannerApiKey = this.getIntent().getStringExtra("camScannerApiKey");
        Log.d((String)"Rajeev", (String)("extractData: " + this.camScannerApiKey));
    }

    private void openGallery() {
        try {
            NeonImagesHandler.getSingletonInstance().scheduleSingletonClearance();
            this.galleryParam = NeonImagesHandler.getSingletonInstance().getGalleryParam();
            if (this.galleryParam == null) {
                this.galleryParam = new IGalleryParam(){

                    @Override
                    public boolean selectVideos() {
                        return false;
                    }

                    @Override
                    public CustomParameters getCustomParameters() {
                        return null;
                    }

                    @Override
                    public GalleryType getGalleryViewType() {
                        return GalleryType.Grid_Structure;
                    }

                    @Override
                    public boolean enableFolderStructure() {
                        return false;
                    }

                    @Override
                    public boolean galleryToCameraSwitchEnabled() {
                        return false;
                    }

                    @Override
                    public boolean isRestrictedExtensionJpgPngEnabled() {
                        return true;
                    }

                    @Override
                    public int getNumberOfPhotos() {
                        return 0;
                    }

                    @Override
                    public boolean getTagEnabled() {
                        return false;
                    }

                    @Override
                    public List<ImageTagModel> getImageTagsModel() {
                        return null;
                    }

                    @Override
                    public List<FileInfo> getAlreadyAddedImages() {
                        ArrayList<FileInfo> selectedFileList = new ArrayList<FileInfo>();
                        if (OneStepActivity.this.mSelectedImages != null && OneStepActivity.this.mSelectedImages.size() > 0) {
                            for (String s : OneStepActivity.this.mSelectedImages) {
                                FileInfo fileInfo = new FileInfo();
                                fileInfo.setFilePath(s);
                                selectedFileList.add(fileInfo);
                            }
                            return selectedFileList;
                        }
                        return null;
                    }

                    @Override
                    public boolean enableImageEditing() {
                        return false;
                    }
                };
            }
            PhotosLibrary.collectPhotos(0, (Context)this, LibraryMode.Relax, PhotosMode.setGalleryMode().setParams(this.galleryParam), new OnImageCollectionListener(){

                @Override
                public void imageCollection(NeonResponse neonResponse) {
                    List<FileInfo> imageCollection = neonResponse.getImageCollection();
                    if (imageCollection != null && imageCollection.size() > 0 && neonResponse.getResponseCode() == ResponseCode.Success) {
                        OneStepActivity.this.mSelectedImages.clear();
                        for (FileInfo file : imageCollection) {
                            OneStepActivity.this.mSelectedImages.add(file.getFilePath());
                        }
                        OneStepActivity.this.count = OneStepActivity.this.mSelectedImages.size();
                        if (OneStepActivity.this.count > 0) {
                            OneStepActivity.this.tvNext.setVisibility(0);
                            OneStepActivity.this.tvImageCount.setVisibility(0);
                            OneStepActivity.this.tvImageCount.setText((CharSequence)String.valueOf(OneStepActivity.this.count));
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onResume() {
        super.onResume();
        if (NeonImagesHandler.getSingletonInstance().getCameraParam() == null) {
            NeonImagesHandler.getSingletonInstance().setCameraParam(this.cameraParam);
        }
        if (NeonImagesHandler.getSingletonInstance().getGalleryParam() == null) {
            NeonImagesHandler.getSingletonInstance().setGalleryParam(this.galleryParam);
        }
    }

    private void setUpCamera() {
        try {
            this.cameraParam = new ICameraParam(){

                @Override
                public CameraFacing getCameraFacing() {
                    return CameraFacing.back;
                }

                @Override
                public CustomParameters getCustomParameters() {
                    return null;
                }

                @Override
                public CameraOrientation getCameraOrientation() {
                    return CameraOrientation.portrait;
                }

                @Override
                public boolean getFlashEnabled() {
                    return false;
                }

                @Override
                public boolean getCameraSwitchingEnabled() {
                    return false;
                }

                @Override
                public boolean getVideoCaptureEnabled() {
                    return false;
                }

                @Override
                public CameraType getCameraViewType() {
                    return CameraType.normal_camera;
                }

                @Override
                public boolean cameraToGallerySwitchEnabled() {
                    return false;
                }

                @Override
                public int getNumberOfPhotos() {
                    return 0;
                }

                @Override
                public boolean getTagEnabled() {
                    return false;
                }

                @Override
                public List<ImageTagModel> getImageTagsModel() {
                    return null;
                }

                @Override
                public List<FileInfo> getAlreadyAddedImages() {
                    return null;
                }

                @Override
                public boolean enableImageEditing() {
                    return false;
                }
            };
            NeonImagesHandler.getSingletonInstance().setCameraParam(this.cameraParam);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onPictureTaken(String filePath) {
        this.ivClickPicture.setClickable(true);
        this.mInputImagePath = filePath;
        if (this.camScannerApi != null && this.camScannerApi.isCamScannerInstalled()) {
            String appName = this.getResources().getString(R.string.app_name).replace(" ", "");
            String path = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + appName;
            this.checkDir(path);
            this.mOutputImagePath = path + File.separator + "IMG_" + System.currentTimeMillis() + "_scanned.jpg";
            boolean req = PhotosLibrary.go2CamScanner((Activity)this, filePath, this.mOutputImagePath, 168, this.camScannerApi);
            Log.d((String)"Rajeev", (String)("onPictureTaken: " + req));
            if (!req) {
                this.afterPictureTaken(filePath);
            }
        } else {
            this.afterPictureTaken(filePath);
        }
    }

    private void afterPictureTaken(String filePath) {
        ++this.count;
        this.tvImageCount.setVisibility(0);
        this.tvImageCount.setText((CharSequence)String.valueOf(this.count));
        this.tvNext.setVisibility(0);
        this.tvNext.setClickable(true);
        FileInfo fileInfo = new FileInfo();
        fileInfo.setFilePath(filePath);
        fileInfo.setFileName(filePath.substring(filePath.lastIndexOf("/") + 1));
        fileInfo.setSource(FileInfo.SOURCE.PHONE_CAMERA);
        if (this.cameraParam == null) {
            return;
        }
        NeonImagesHandler.getSingletonInstance().setCameraParam(this.cameraParam);
        NeonImagesHandler.getSingletonInstance().putInImageCollection(fileInfo, (Context)this);
        Glide.with((FragmentActivity)this).load("file://" + fileInfo.getFilePath()).asBitmap().centerCrop().into((Target)new BitmapImageViewTarget(this.ivGallery){

            protected void setResource(Bitmap resource) {
                RoundedBitmapDrawable circularBitmapDrawable = RoundedBitmapDrawableFactory.create((Resources)OneStepActivity.this.getResources(), (Bitmap)resource);
                circularBitmapDrawable.setCircular(true);
                OneStepActivity.this.ivGallery.setImageDrawable((Drawable)circularBitmapDrawable);
            }
        });
        this.mSelectedImages.add(filePath);
    }

    private boolean checkDir(String path) {
        boolean result = true;
        File f = new File(path);
        if (!f.exists()) {
            result = f.mkdirs();
        } else if (f.isFile()) {
            f.delete();
            result = f.mkdirs();
        }
        return result;
    }

    public void onBackPressed() {
        if (this.mSelectedImages.size() > 0) {
            new AlertDialog.Builder((Context)this).setTitle(R.string.please_confirm).setMessage(R.string.would_you_like_to_save_captured_images).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    OneStepActivity.this.sendResponse();
                }
            }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    OneStepActivity.this.finish();
                }
            }).create().show();
        } else {
            super.onBackPressed();
        }
    }

    private boolean isServiceRunning() {
        ActivityManager manager = (ActivityManager)this.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!"com.gcloud.gaadi.service.FinanceImagesUploadService".equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1 && requestCode == this.PICKFILE_RESULT_CODE) {
            if (data == null && data.getData() == null) {
                Toast.makeText((Context)this, (CharSequence)"Error!!!", (int)0).show();
            } else {
                String myData = "";
                Uri pdfFile = data.getData();
                this.path = GetFilePath.getPath(this.getApplicationContext(), pdfFile);
                try {
                    this.openRenderer((Context)this);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Toast.makeText((Context)this, (CharSequence)("Error!!!" + e.getMessage()), (int)0).show();
                }
            }
        } else if (resultCode == -1 && requestCode == 168) {
            this.camScannerApi.handleResult(requestCode, resultCode, data, new CSOpenApiHandler(){

                public void onSuccess() {
                    Log.d((String)"Rajeev", (String)("onSuccess: " + OneStepActivity.this.mOutputImagePath));
                    File file = new File(OneStepActivity.this.mOutputImagePath);
                    Log.d((String)"Rajeev", (String)("onSuccess: " + Uri.fromFile((File)file)));
                    OneStepActivity.this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)file)));
                    OneStepActivity.this.afterPictureTaken(OneStepActivity.this.mOutputImagePath);
                    NeonUtils.deleteFile((Context)OneStepActivity.this, OneStepActivity.this.mInputImagePath);
                }

                public void onError(int i) {
                    Log.d((String)"Rajeev", (String)("onError: " + i));
                }

                public void onCancel() {
                    Log.d((String)"Rajeev", (String)"onCancel: ");
                }
            });
        }
    }

    @Override
    public void imageCollection(NeonResponse neonResponse) {
    }

    @RequiresApi(api=19)
    private void showFileChooser() {
        if (this.mSelectedImages.size() != 0) {
            this.showImageLostAlertDialog();
        } else {
            Intent chooseFile = new Intent("android.intent.action.GET_CONTENT");
            chooseFile.setType("application/pdf");
            chooseFile.addCategory("android.intent.category.OPENABLE");
            this.startActivityForResult(Intent.createChooser((Intent)chooseFile, (CharSequence)"Choose a PDF file"), this.PICKFILE_RESULT_CODE);
        }
    }

    private void showImageLostAlertDialog() {
        new AlertDialog.Builder((Context)this).setTitle(R.string.please_confirm).setCancelable(true).setMessage((CharSequence)"Captured images will be replace. \n Would you like to proceed?").setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            @RequiresApi(api=19)
            public void onClick(DialogInterface dialog, int which) {
                OneStepActivity.this.mSelectedImages.clear();
                OneStepActivity.this.count = 0;
                OneStepActivity.this.tvImageCount.setVisibility(4);
                OneStepActivity.this.tvNext.setVisibility(4);
                OneStepActivity.this.showFileChooser();
            }
        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create().show();
    }

    @TargetApi(value=21)
    private void openRenderer(Context context) throws IOException {
        File file = new File(this.path);
        if (!file.exists()) {
            return;
        }
        this.mFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        if (this.mFileDescriptor != null) {
            this.mPdfRenderer = new PdfRenderer(this.mFileDescriptor);
            for (int i = 0; i < this.mPdfRenderer.getPageCount(); ++i) {
                this.convertIntoImage(i);
            }
            if (this.mSelectedImages.size() != 0) {
                this.showPdfUploadDialog();
            } else {
                Toast.makeText((Context)this, (CharSequence)"Can't read the pdf file.", (int)0).show();
            }
        }
    }

    @TargetApi(value=21)
    private void closeRenderer() throws IOException {
        if (null != this.mCurrentPage) {
            this.mCurrentPage.close();
        }
        if (this.mPdfRenderer != null) {
            this.mPdfRenderer.close();
        }
        if (this.mFileDescriptor != null) {
            this.mFileDescriptor.close();
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private void convertIntoImage(int index) throws IOException {
        if (this.mPdfRenderer.getPageCount() <= index) {
            return;
        }
        if (null != this.mCurrentPage) {
            try {
                this.mCurrentPage.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.mCurrentPage = this.mPdfRenderer.openPage(index);
        Bitmap bitmap = Bitmap.createBitmap((int)this.mCurrentPage.getWidth(), (int)this.mCurrentPage.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mCurrentPage.render(bitmap, null, null, 1);
        this.saveImage(bitmap, index);
    }

    @TargetApi(value=21)
    public int getPageCount() {
        return this.mPdfRenderer.getPageCount();
    }

    private void saveImage(Bitmap bitmap, int index) {
        String root = Environment.getExternalStorageDirectory().toString();
        File myDir = new File(root + "/downloads");
        myDir.mkdirs();
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());
        File imageFile = new File(myDir, "IMG_" + timeStamp + "_" + index + ".png");
        this.mSelectedImages.add(imageFile.getPath());
        try {
            FileOutputStream os = new FileOutputStream(imageFile);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
            os.flush();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showPdfUploadDialog() {
        new AlertDialog.Builder((Context)this).setTitle(R.string.please_confirm).setCancelable(false).setMessage(R.string.would_you_like_to_save_captured_pdf).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                OneStepActivity.this.sendResponse();
            }
        }).setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create().show();
    }

    protected void onDestroy() {
        try {
            this.closeRenderer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.onDestroy();
    }

    private void sendResponse() {
        ArrayList<String> images = new ArrayList<String>(this.mSelectedImages);
        ArrayList<FileInfo> imageCollection = new ArrayList<FileInfo>();
        for (String path : images) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setFilePath(path);
            imageCollection.add(fileInfo);
        }
        NeonResponse response = new NeonResponse();
        response.setImageCollection(imageCollection);
        OneStepImageHandler.getInstance().getOneStepImagesActionListener().imageCollection(response);
        this.finish();
    }
}

