/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.activity.gallery.GridFilesActivity;
import com.gaadi.neon.util.Constants;
import com.gaadi.neon.util.ExifInterfaceHandling;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;
import java.io.File;
import java.util.ArrayList;

public class GridFilesAdapter
extends BaseAdapter {
    private AppCompatActivity context;
    private ArrayList<FileInfo> fileInfos;

    public GridFilesAdapter(AppCompatActivity _context, ArrayList<FileInfo> _fileInfos) {
        this.context = _context;
        this.fileInfos = _fileInfos;
    }

    public int getCount() {
        return this.fileInfos.size();
    }

    public Object getItem(int position) {
        return this.fileInfos.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        FilesHolder filesHolder;
        if (convertView == null) {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            convertView = inflater.inflate(R.layout.select_files, null);
            filesHolder = new FilesHolder();
            filesHolder.selectedImage = (ImageView)convertView.findViewById(R.id.imageSelected);
            filesHolder.selection_view = (ImageView)convertView.findViewById(R.id.selection_view);
            filesHolder.transparentLayer = (ImageView)convertView.findViewById(R.id.vTransparentLayer);
            convertView.setTag((Object)filesHolder);
        } else {
            Log.e((String)"tag", (String)"came");
        }
        filesHolder = (FilesHolder)convertView.getTag();
        Glide.with((FragmentActivity)this.context).load(this.fileInfos.get(position).getFilePath()).placeholder(R.drawable.default_placeholder).centerCrop().diskCacheStrategy(DiskCacheStrategy.NONE).into(filesHolder.selectedImage);
        if (NeonImagesHandler.getSingleonInstance().checkImageAvailableForPath(this.fileInfos.get(position))) {
            filesHolder.selection_view.setVisibility(0);
            filesHolder.transparentLayer.setVisibility(0);
        } else {
            filesHolder.selection_view.setVisibility(8);
            filesHolder.transparentLayer.setVisibility(8);
        }
        final FilesHolder finalFilesHolder = filesHolder;
        convertView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                block11: {
                    if (NeonImagesHandler.getSingletonInstance().checkImageAvailableForPath((FileInfo)GridFilesAdapter.this.fileInfos.get(position))) {
                        if (NeonImagesHandler.getSingletonInstance().removeFromCollection((FileInfo)GridFilesAdapter.this.fileInfos.get(position))) {
                            finalFilesHolder.selection_view.setVisibility(8);
                            finalFilesHolder.transparentLayer.setVisibility(8);
                            ((GridFilesActivity)GridFilesAdapter.this.context).removeImageFromRecentCollection((FileInfo)GridFilesAdapter.this.fileInfos.get(position));
                        }
                    } else if (NeonImagesHandler.getSingletonInstance().getGenericParam() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters() != null && NeonImagesHandler.getSingletonInstance().getGenericParam().getCustomParameters().getFolderRestrictive()) {
                        String appName = Constants.getAppName((Context)GridFilesAdapter.this.context);
                        File file = new File(((FileInfo)GridFilesAdapter.this.fileInfos.get(position)).getFilePath());
                        if (file.exists()) {
                            try {
                                ExifInterfaceHandling exifInterfaceHandling = new ExifInterfaceHandling(file);
                                String artist = exifInterfaceHandling.getAttribute("Artist");
                                if (artist != null && String.valueOf(appName).equals(artist)) {
                                    if (NeonImagesHandler.getSingletonInstance().putInImageCollection((FileInfo)GridFilesAdapter.this.fileInfos.get(position), (Context)GridFilesAdapter.this.context)) {
                                        finalFilesHolder.selection_view.setVisibility(0);
                                        finalFilesHolder.transparentLayer.setVisibility(0);
                                        ((GridFilesActivity)GridFilesAdapter.this.context).addImageToRecentelySelected((FileInfo)GridFilesAdapter.this.fileInfos.get(position));
                                    }
                                    break block11;
                                }
                                Toast.makeText((Context)GridFilesAdapter.this.context, (CharSequence)"Not allowed", (int)0).show();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (NeonImagesHandler.getSingletonInstance().putInImageCollection((FileInfo)GridFilesAdapter.this.fileInfos.get(position), (Context)GridFilesAdapter.this.context)) {
                        finalFilesHolder.selection_view.setVisibility(0);
                        finalFilesHolder.transparentLayer.setVisibility(0);
                        ((GridFilesActivity)GridFilesAdapter.this.context).addImageToRecentelySelected((FileInfo)GridFilesAdapter.this.fileInfos.get(position));
                    }
                }
            }
        });
        return convertView;
    }

    private class FilesHolder {
        ImageView selectedImage;
        ImageView transparentLayer;
        ImageView selection_view;

        private FilesHolder() {
        }
    }
}

