/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.util;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.support.v7.app.AlertDialog;
import android.widget.Toast;
import com.gaadi.neon.enumerations.LibraryMode;
import com.gaadi.neon.enumerations.ResponseCode;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.IGalleryParam;
import com.gaadi.neon.interfaces.INeutralParam;
import com.gaadi.neon.interfaces.IParam;
import com.gaadi.neon.interfaces.LivePhotoNextTagListener;
import com.gaadi.neon.interfaces.LivePhotosListener;
import com.gaadi.neon.interfaces.OnImageCollectionListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.NeonResponse;
import com.gaadi.neon.util.FileInfo;
import com.scanlibrary.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class NeonImagesHandler {
    private static NeonImagesHandler singleonInstance;
    private boolean clearInstance;
    private List<FileInfo> imagesCollection;
    private ICameraParam cameraParam;
    private IGalleryParam galleryParam;
    private boolean neutralEnabled;
    private INeutralParam neutralParam;
    private OnImageCollectionListener imageResultListener;
    private LivePhotosListener livePhotosListener;
    private LivePhotoNextTagListener livePhotoNextTagListener;
    private String currentTag = "";
    private LibraryMode libraryMode;
    private int requestCode;

    private NeonImagesHandler() {
    }

    @Deprecated
    public static synchronized NeonImagesHandler getSingleonInstance() {
        return NeonImagesHandler.getSingletonInstance();
    }

    public static synchronized NeonImagesHandler getSingletonInstance() {
        if (singleonInstance == null || NeonImagesHandler.singleonInstance.clearInstance) {
            singleonInstance = new NeonImagesHandler();
            NeonImagesHandler.singleonInstance.clearInstance = false;
        }
        return singleonInstance;
    }

    public void scheduleSingletonClearance() {
        this.clearInstance = true;
    }

    public int getNumberOfPhotosCollected(ImageTagModel imageTagModel) {
        int count = 0;
        if (this.imagesCollection != null && this.imagesCollection.size() > 0) {
            for (FileInfo fileInfo : this.imagesCollection) {
                if (fileInfo.getFileTag() == null || !fileInfo.getFileTag().getTagId().equals(imageTagModel.getTagId())) continue;
                ++count;
            }
        }
        return count;
    }

    public OnImageCollectionListener getImageResultListener() {
        return this.imageResultListener;
    }

    public void setImageResultListener(OnImageCollectionListener imageResultListener) {
        this.imageResultListener = imageResultListener;
    }

    public LivePhotosListener getLivePhotosListener() {
        return this.livePhotosListener;
    }

    public void setLivePhotosListener(LivePhotosListener livePhotosListener) {
        this.livePhotosListener = livePhotosListener;
    }

    public LivePhotoNextTagListener getLivePhotoNextTagListener() {
        return this.livePhotoNextTagListener;
    }

    public void setLivePhotoNextTagListener(LivePhotoNextTagListener livePhotoNextTagListener) {
        this.livePhotoNextTagListener = livePhotoNextTagListener;
    }

    public String getCurrentTag() {
        return this.currentTag;
    }

    public void setCurrentTag(String currentTag) {
        this.currentTag = currentTag;
    }

    public IParam getGenericParam() {
        if (this.galleryParam != null) {
            return this.galleryParam;
        }
        if (this.cameraParam != null) {
            return this.cameraParam;
        }
        return this.neutralParam;
    }

    public boolean isNeutralEnabled() {
        return this.neutralEnabled;
    }

    public void setNeutralEnabled(boolean neutralEnabled) {
        this.neutralEnabled = neutralEnabled;
    }

    public INeutralParam getNeutralParam() {
        return this.neutralParam;
    }

    public void setNeutralParam(INeutralParam neutralParam) {
        this.neutralParam = neutralParam;
    }

    public List<FileInfo> getImagesCollection() {
        return this.imagesCollection;
    }

    public void setImagesCollection(List<FileInfo> allreadyAdded) {
        this.imagesCollection = new ArrayList<FileInfo>();
        if (allreadyAdded != null && allreadyAdded.size() > 0) {
            for (int i = 0; i < allreadyAdded.size(); ++i) {
                FileInfo cloneFile = new FileInfo();
                FileInfo originalFile = allreadyAdded.get(i);
                if (originalFile == null) continue;
                if (originalFile.getFileTag() != null) {
                    cloneFile.setFileTag(new ImageTagModel(originalFile.getFileTag().getTagName(), originalFile.getFileTag().getTagId(), originalFile.getFileTag().isMandatory(), originalFile.getFileTag().getNumberOfPhotos()));
                }
                cloneFile.setSelected(originalFile.getSelected());
                cloneFile.setSource(originalFile.getSource());
                cloneFile.setFileName(originalFile.getFileName());
                cloneFile.setDateTimeTaken(originalFile.getDateTimeTaken());
                cloneFile.setDisplayName(originalFile.getDisplayName());
                cloneFile.setFileCount(originalFile.getFileCount());
                cloneFile.setFilePath(originalFile.getFilePath());
                cloneFile.setType(originalFile.getType());
                this.imagesCollection.add(cloneFile);
            }
        }
    }

    public boolean checkImagesAvailableForTag(ImageTagModel tagModel) {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            if (this.imagesCollection.get(i).getFileTag() == null || !this.imagesCollection.get(i).getFileTag().getTagId().equals(tagModel.getTagId()) || !this.imagesCollection.get(i).getFileTag().getTagName().equals(tagModel.getTagName())) continue;
            return true;
        }
        return false;
    }

    public boolean checkImageAvailableForPath(FileInfo fileInfo) {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return false;
        }
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            if (!this.imagesCollection.get(i).getFilePath().equalsIgnoreCase(fileInfo.getFilePath())) continue;
            return true;
        }
        return false;
    }

    public boolean removeFromCollection(FileInfo fileInfo) {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return true;
        }
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            if (!this.imagesCollection.get(i).getFilePath().equals(fileInfo.getFilePath())) continue;
            return this.imagesCollection.remove(i) != null;
        }
        return true;
    }

    public boolean putInImageCollection(FileInfo fileInfo, Context context) {
        if (this.imagesCollection == null) {
            this.imagesCollection = new ArrayList<FileInfo>();
        }
        if (this.getGenericParam() != null && !this.getGenericParam().getTagEnabled()) {
            if (this.getGenericParam().getNumberOfPhotos() > 0 && this.getImagesCollection() != null && this.getGenericParam().getNumberOfPhotos() == this.getImagesCollection().size()) {
                Toast.makeText((Context)context, (CharSequence)context.getString(R.string.max_count_error, new Object[]{this.getGenericParam().getNumberOfPhotos()}), (int)0).show();
                return false;
            }
        } else {
            ImageTagModel imageTagModel = fileInfo.getFileTag();
            if (imageTagModel != null && imageTagModel.getNumberOfPhotos() > 0 && this.getNumberOfPhotosCollected(imageTagModel) >= imageTagModel.getNumberOfPhotos()) {
                Toast.makeText((Context)context, (CharSequence)(context.getString(R.string.max_tag_count_error, new Object[]{imageTagModel.getNumberOfPhotos()}) + imageTagModel.getTagName()), (int)0).show();
                return false;
            }
        }
        this.imagesCollection.add(fileInfo);
        return true;
    }

    public boolean removeFromCollection(int position) {
        return this.imagesCollection == null || this.imagesCollection.size() <= 0 || this.imagesCollection.remove(position) != null;
    }

    private HashMap<String, List<FileInfo>> getFileHashMap() {
        if (this.imagesCollection == null || this.imagesCollection.size() <= 0) {
            return null;
        }
        HashMap<String, List<FileInfo>> hashMap = new HashMap<String, List<FileInfo>>();
        for (int i = 0; i < this.imagesCollection.size(); ++i) {
            FileInfo singleFile = this.imagesCollection.get(i);
            if (singleFile.getFileTag() == null) continue;
            if (hashMap.containsKey(singleFile.getFileTag().getTagId())) {
                hashMap.get(singleFile.getFileTag().getTagId()).add(singleFile);
                continue;
            }
            ArrayList<FileInfo> singleTagFiles = new ArrayList<FileInfo>();
            singleTagFiles.add(singleFile);
            hashMap.put(singleFile.getFileTag().getTagId(), singleTagFiles);
        }
        return hashMap;
    }

    public IGalleryParam getGalleryParam() {
        return this.galleryParam;
    }

    public void setGalleryParam(IGalleryParam params) {
        this.galleryParam = params;
    }

    public ICameraParam getCameraParam() {
        return this.cameraParam;
    }

    public void setCameraParam(ICameraParam cameraParam) {
        this.cameraParam = cameraParam;
    }

    public void sendImageCollectionAndFinish(Activity activity, ResponseCode responseCode) {
        NeonResponse neonResponse = new NeonResponse();
        neonResponse.setRequestCode(this.getRequestCode());
        neonResponse.setResponseCode(responseCode);
        neonResponse.setImageCollection(NeonImagesHandler.getSingletonInstance().getImagesCollection());
        neonResponse.setImageTagsCollection(NeonImagesHandler.getSingletonInstance().getFileHashMap());
        NeonImagesHandler.getSingletonInstance().getImageResultListener().imageCollection(neonResponse);
        NeonImagesHandler.getSingletonInstance().scheduleSingletonClearance();
        activity.finish();
    }

    public void showBackOperationAlertIfNeeded(Activity activity) {
        if (this.validateNeonExit(null)) {
            this.sendImageCollectionAndFinish(activity, ResponseCode.Back);
        } else if (NeonImagesHandler.getSingleonInstance().getLibraryMode() == LibraryMode.Restrict) {
            this.showExitConfirmation(activity);
        } else {
            this.sendImageCollectionAndFinish(activity, ResponseCode.Back);
        }
    }

    private void showExitConfirmation(final Activity activity) {
        new AlertDialog.Builder((Context)activity).setTitle((CharSequence)"Are you sure want to go back?").setCancelable(true).setIcon(17301543).setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                NeonImagesHandler.this.sendImageCollectionAndFinish(activity, ResponseCode.Back);
            }
        }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).show();
    }

    public void showBackOperationAlertIfNeededLive(Activity activity) {
        if (NeonImagesHandler.getSingletonInstance().getLibraryMode() == LibraryMode.Restrict) {
            if (!this.validateNeonExit(null)) {
                new AlertDialog.Builder((Context)activity).setTitle((CharSequence)("Please upload " + NeonImagesHandler.getSingletonInstance().getCurrentTag() + " Photo")).setCancelable(true).setIcon(17301543).setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                }).show();
            } else {
                this.sendImageCollectionAndFinish(activity, ResponseCode.Back);
            }
        } else {
            if (!this.validateNeonExit(null)) {
                this.showExitConfirmation(activity);
            }
            this.showBackOperationAlertIfNeeded(activity);
        }
    }

    public boolean validateNeonExit(Activity activity) {
        try {
            if (NeonImagesHandler.getSingletonInstance() != null && NeonImagesHandler.getSingletonInstance().getGenericParam() != null && !NeonImagesHandler.getSingletonInstance().getGenericParam().getTagEnabled()) {
                return true;
            }
            List<FileInfo> fileInfos = NeonImagesHandler.getSingletonInstance().getImagesCollection();
            if (fileInfos != null && fileInfos.size() > 0) {
                for (int i = 0; i < fileInfos.size(); ++i) {
                    if (fileInfos.get(i).getFileTag() != null) continue;
                    if (activity != null) {
                        Toast.makeText((Context)activity, (CharSequence)"Set tag for all images", (int)0).show();
                    }
                    return false;
                }
            }
            List<ImageTagModel> imageTagModels = NeonImagesHandler.getSingletonInstance().getGenericParam().getImageTagsModel();
            for (int j = 0; j < imageTagModels.size(); ++j) {
                if (!imageTagModels.get(j).isMandatory() || NeonImagesHandler.getSingletonInstance().checkImagesAvailableForTag(imageTagModels.get(j))) continue;
                if (activity != null) {
                    Toast.makeText((Context)activity, (CharSequence)(imageTagModels.get(j).getTagName() + " tag not covered."), (int)0).show();
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public LibraryMode getLibraryMode() {
        return this.libraryMode;
    }

    public void setLibraryMode(LibraryMode libraryMode) {
        this.libraryMode = libraryMode;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public void setRequestCode(int requestCode) {
        this.requestCode = requestCode;
    }
}

