/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.gaadi.neon.activity.neutral.NeonNeutralActivity;
import com.gaadi.neon.dynamicgrid.BaseDynamicGridAdapter;
import com.gaadi.neon.util.NeonImagesHandler;
import com.scanlibrary.R;

public class ImageShowAdapter
extends BaseDynamicGridAdapter {
    private Context context;

    public ImageShowAdapter(Context context) {
        super(context, NeonImagesHandler.getSingletonInstance().getImagesCollection(), 2);
        this.context = context;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        PhotosHolder holder;
        if (convertView == null) {
            convertView = View.inflate((Context)this.context, (int)R.layout.display_images, null);
            holder = new PhotosHolder();
            holder.image = (ImageView)convertView.findViewById(R.id.ivImageDisplay);
            holder.removeImage = (ImageView)convertView.findViewById(R.id.ivRemoveImage);
            holder.tvProfile = (TextView)convertView.findViewById(R.id.tvProfilePhoto);
            convertView.setTag((Object)holder);
        } else {
            holder = (PhotosHolder)convertView.getTag();
        }
        if (!NeonImagesHandler.getSingletonInstance().getGenericParam().getTagEnabled()) {
            holder.tvProfile.setVisibility(8);
        } else {
            holder.tvProfile.setVisibility(0);
        }
        if (NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position).getFileTag() != null) {
            holder.tvProfile.setText((CharSequence)NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position).getFileTag().getTagName());
        } else {
            holder.tvProfile.setText(R.string.select_tag);
        }
        holder.removeImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (NeonImagesHandler.getSingleonInstance().removeFromCollection(position)) {
                    ImageShowAdapter.this.notifyDataSetChanged();
                    if ((NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) && ImageShowAdapter.this.context instanceof NeonNeutralActivity) {
                        ((NeonNeutralActivity)ImageShowAdapter.this.context).onPostResume();
                    }
                } else {
                    Toast.makeText((Context)ImageShowAdapter.this.context, (CharSequence)"Failed to delete.Please try again later.", (int)0).show();
                }
            }
        });
        Glide.with((Context)this.context).load(NeonImagesHandler.getSingleonInstance().getImagesCollection().get(position).getFilePath()).crossFade().placeholder(R.drawable.default_placeholder).centerCrop().diskCacheStrategy(DiskCacheStrategy.ALL).into(holder.image);
        return convertView;
    }

    private class PhotosHolder {
        ImageView image;
        ImageView removeImage;
        TextView tvProfile;

        private PhotosHolder() {
        }
    }
}

