/*
 * Decompiled with CFR 0.152.
 */
package com.gaadi.neon.activity.gallery;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.Toast;
import com.gaadi.neon.PhotosLibrary;
import com.gaadi.neon.activity.ImageShow;
import com.gaadi.neon.activity.gallery.NeonBaseGalleryActivity;
import com.gaadi.neon.adapter.ImagesFoldersAdapter;
import com.gaadi.neon.enumerations.CameraFacing;
import com.gaadi.neon.enumerations.CameraOrientation;
import com.gaadi.neon.enumerations.CameraType;
import com.gaadi.neon.interfaces.ICameraParam;
import com.gaadi.neon.interfaces.OnPermissionResultListener;
import com.gaadi.neon.model.ImageTagModel;
import com.gaadi.neon.model.PhotosMode;
import com.gaadi.neon.util.FileInfo;
import com.gaadi.neon.util.ManifestPermission;
import com.gaadi.neon.util.NeonException;
import com.gaadi.neon.util.NeonImagesHandler;
import com.gaadi.neon.util.PermissionType;
import com.scanlibrary.R;
import com.scanlibrary.databinding.ActivityGridFoldersBinding;
import java.util.ArrayList;
import java.util.List;

public class GridFoldersActivity
extends NeonBaseGalleryActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.bindXml();
        this.setTitle(R.string.gallery);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_done_file, menu2);
        MenuItem textViewDone = menu2.findItem(R.id.menu_next);
        MenuItem textViewCamera = menu2.findItem(R.id.menuCamera);
        if (NeonImagesHandler.getSingleonInstance().getGalleryParam().galleryToCameraSwitchEnabled()) {
            textViewCamera.setVisible(true);
        } else {
            textViewCamera.setVisible(false);
        }
        textViewDone.setVisible(true);
        return super.onCreateOptionsMenu(menu2);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.menuCamera) {
            this.performCameraOperation();
        } else if (id2 == R.id.menu_next) {
            if (NeonImagesHandler.getSingleonInstance().isNeutralEnabled()) {
                this.finish();
            } else {
                if (NeonImagesHandler.getSingleonInstance().getImagesCollection() == null || NeonImagesHandler.getSingleonInstance().getImagesCollection().size() <= 0) {
                    Toast.makeText((Context)this, (int)R.string.no_image_selected, (int)0).show();
                    return super.onOptionsItemSelected(item);
                }
                Intent intent = new Intent((Context)this, ImageShow.class);
                this.startActivity(intent);
                this.finish();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        if (NeonImagesHandler.getSingleonInstance().isNeutralEnabled()) {
            super.onBackPressed();
        } else {
            NeonImagesHandler.getSingleonInstance().showBackOperationAlertIfNeeded((Activity)this);
        }
    }

    private void performCameraOperation() {
        ICameraParam cameraParam = NeonImagesHandler.getSingleonInstance().getCameraParam();
        if (cameraParam == null) {
            cameraParam = new ICameraParam(){

                @Override
                public CameraFacing getCameraFacing() {
                    return CameraFacing.front;
                }

                @Override
                public CameraOrientation getCameraOrientation() {
                    return CameraOrientation.portrait;
                }

                @Override
                public boolean getFlashEnabled() {
                    return true;
                }

                @Override
                public boolean getCameraSwitchingEnabled() {
                    return true;
                }

                @Override
                public boolean getVideoCaptureEnabled() {
                    return false;
                }

                @Override
                public CameraType getCameraViewType() {
                    return CameraType.normal_camera;
                }

                @Override
                public boolean cameraToGallerySwitchEnabled() {
                    return true;
                }

                @Override
                public int getNumberOfPhotos() {
                    return NeonImagesHandler.getSingleonInstance().getGalleryParam().getNumberOfPhotos();
                }

                @Override
                public boolean getTagEnabled() {
                    return NeonImagesHandler.getSingleonInstance().getGalleryParam().getTagEnabled();
                }

                @Override
                public List<ImageTagModel> getImageTagsModel() {
                    return NeonImagesHandler.getSingleonInstance().getGalleryParam().getImageTagsModel();
                }

                public ArrayList<FileInfo> getAlreadyAddedImages() {
                    return null;
                }
            };
        }
        try {
            PhotosLibrary.collectPhotos((Context)this, NeonImagesHandler.getSingleonInstance().getLibraryMode(), PhotosMode.setCameraMode().setParams(cameraParam), NeonImagesHandler.getSingleonInstance().getImageResultListener());
        }
        catch (NeonException e) {
            e.printStackTrace();
        }
        this.finish();
    }

    private void bindXml() {
        try {
            this.askForPermissionIfNeeded(PermissionType.write_external_storage, new OnPermissionResultListener(){

                @Override
                public void onResult(boolean permissionGranted) {
                    if (permissionGranted) {
                        ActivityGridFoldersBinding binder = (ActivityGridFoldersBinding)DataBindingUtil.inflate((LayoutInflater)GridFoldersActivity.this.getLayoutInflater(), (int)R.layout.activity_grid_folders, (ViewGroup)GridFoldersActivity.this.frameLayout, (boolean)true);
                        ImagesFoldersAdapter adapter = new ImagesFoldersAdapter((Activity)GridFoldersActivity.this, GridFoldersActivity.this.getImageBuckets());
                        binder.gvFolders.setAdapter((ListAdapter)adapter);
                    } else {
                        Toast.makeText((Context)GridFoldersActivity.this, (int)R.string.permission_error, (int)0).show();
                    }
                }
            });
        }
        catch (ManifestPermission manifestPermission) {
            manifestPermission.printStackTrace();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == 300 && requestCode == 300) {
            this.finish();
        }
    }
}

